/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module testmodel-js/nullable_tck */
var utils = require('vertx-js/util/utils');
var RefedInterface1 = require('testmodel-js/refed_interface1');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JNullableTCK = Java.type('io.vertx.codegen.testmodel.NullableTCK');
var TestDataObject = Java.type('io.vertx.codegen.testmodel.TestDataObject');

/**

 @class
*/
var NullableTCK = function(j_val) {

  var j_nullableTCK = j_val;
  var that = this;

  var __super_methodWithNonNullableByteParam = this.methodWithNonNullableByteParam;
  var __super_methodWithNullableByteParam = this.methodWithNullableByteParam;
  var __super_methodWithNullableByteHandler = this.methodWithNullableByteHandler;
  var __super_methodWithNullableByteHandlerAsyncResult = this.methodWithNullableByteHandlerAsyncResult;
  var __super_methodWithNullableByteReturn = this.methodWithNullableByteReturn;
  var __super_methodWithNonNullableShortParam = this.methodWithNonNullableShortParam;
  var __super_methodWithNullableShortParam = this.methodWithNullableShortParam;
  var __super_methodWithNullableShortHandler = this.methodWithNullableShortHandler;
  var __super_methodWithNullableShortHandlerAsyncResult = this.methodWithNullableShortHandlerAsyncResult;
  var __super_methodWithNullableShortReturn = this.methodWithNullableShortReturn;
  var __super_methodWithNonNullableIntegerParam = this.methodWithNonNullableIntegerParam;
  var __super_methodWithNullableIntegerParam = this.methodWithNullableIntegerParam;
  var __super_methodWithNullableIntegerHandler = this.methodWithNullableIntegerHandler;
  var __super_methodWithNullableIntegerHandlerAsyncResult = this.methodWithNullableIntegerHandlerAsyncResult;
  var __super_methodWithNullableIntegerReturn = this.methodWithNullableIntegerReturn;
  var __super_methodWithNonNullableLongParam = this.methodWithNonNullableLongParam;
  var __super_methodWithNullableLongParam = this.methodWithNullableLongParam;
  var __super_methodWithNullableLongHandler = this.methodWithNullableLongHandler;
  var __super_methodWithNullableLongHandlerAsyncResult = this.methodWithNullableLongHandlerAsyncResult;
  var __super_methodWithNullableLongReturn = this.methodWithNullableLongReturn;
  var __super_methodWithNonNullableFloatParam = this.methodWithNonNullableFloatParam;
  var __super_methodWithNullableFloatParam = this.methodWithNullableFloatParam;
  var __super_methodWithNullableFloatHandler = this.methodWithNullableFloatHandler;
  var __super_methodWithNullableFloatHandlerAsyncResult = this.methodWithNullableFloatHandlerAsyncResult;
  var __super_methodWithNullableFloatReturn = this.methodWithNullableFloatReturn;
  var __super_methodWithNonNullableDoubleParam = this.methodWithNonNullableDoubleParam;
  var __super_methodWithNullableDoubleParam = this.methodWithNullableDoubleParam;
  var __super_methodWithNullableDoubleHandler = this.methodWithNullableDoubleHandler;
  var __super_methodWithNullableDoubleHandlerAsyncResult = this.methodWithNullableDoubleHandlerAsyncResult;
  var __super_methodWithNullableDoubleReturn = this.methodWithNullableDoubleReturn;
  var __super_methodWithNonNullableBooleanParam = this.methodWithNonNullableBooleanParam;
  var __super_methodWithNullableBooleanParam = this.methodWithNullableBooleanParam;
  var __super_methodWithNullableBooleanHandler = this.methodWithNullableBooleanHandler;
  var __super_methodWithNullableBooleanHandlerAsyncResult = this.methodWithNullableBooleanHandlerAsyncResult;
  var __super_methodWithNullableBooleanReturn = this.methodWithNullableBooleanReturn;
  var __super_methodWithNonNullableStringParam = this.methodWithNonNullableStringParam;
  var __super_methodWithNullableStringParam = this.methodWithNullableStringParam;
  var __super_methodWithNullableStringHandler = this.methodWithNullableStringHandler;
  var __super_methodWithNullableStringHandlerAsyncResult = this.methodWithNullableStringHandlerAsyncResult;
  var __super_methodWithNullableStringReturn = this.methodWithNullableStringReturn;
  var __super_methodWithNonNullableCharParam = this.methodWithNonNullableCharParam;
  var __super_methodWithNullableCharParam = this.methodWithNullableCharParam;
  var __super_methodWithNullableCharHandler = this.methodWithNullableCharHandler;
  var __super_methodWithNullableCharHandlerAsyncResult = this.methodWithNullableCharHandlerAsyncResult;
  var __super_methodWithNullableCharReturn = this.methodWithNullableCharReturn;
  var __super_methodWithNonNullableJsonObjectParam = this.methodWithNonNullableJsonObjectParam;
  var __super_methodWithNullableJsonObjectParam = this.methodWithNullableJsonObjectParam;
  var __super_methodWithNullableJsonObjectHandler = this.methodWithNullableJsonObjectHandler;
  var __super_methodWithNullableJsonObjectHandlerAsyncResult = this.methodWithNullableJsonObjectHandlerAsyncResult;
  var __super_methodWithNullableJsonObjectReturn = this.methodWithNullableJsonObjectReturn;
  var __super_methodWithNonNullableJsonArrayParam = this.methodWithNonNullableJsonArrayParam;
  var __super_methodWithNullableJsonArrayParam = this.methodWithNullableJsonArrayParam;
  var __super_methodWithNullableJsonArrayHandler = this.methodWithNullableJsonArrayHandler;
  var __super_methodWithNullableJsonArrayHandlerAsyncResult = this.methodWithNullableJsonArrayHandlerAsyncResult;
  var __super_methodWithNullableJsonArrayReturn = this.methodWithNullableJsonArrayReturn;
  var __super_methodWithNonNullableApiParam = this.methodWithNonNullableApiParam;
  var __super_methodWithNullableApiParam = this.methodWithNullableApiParam;
  var __super_methodWithNullableApiHandler = this.methodWithNullableApiHandler;
  var __super_methodWithNullableApiHandlerAsyncResult = this.methodWithNullableApiHandlerAsyncResult;
  var __super_methodWithNullableApiReturn = this.methodWithNullableApiReturn;
  var __super_methodWithNonNullableDataObjectParam = this.methodWithNonNullableDataObjectParam;
  var __super_methodWithNullableDataObjectParam = this.methodWithNullableDataObjectParam;
  var __super_methodWithNullableDataObjectHandler = this.methodWithNullableDataObjectHandler;
  var __super_methodWithNullableDataObjectHandlerAsyncResult = this.methodWithNullableDataObjectHandlerAsyncResult;
  var __super_methodWithNullableDataObjectReturn = this.methodWithNullableDataObjectReturn;
  var __super_methodWithNonNullableEnumParam = this.methodWithNonNullableEnumParam;
  var __super_methodWithNullableEnumParam = this.methodWithNullableEnumParam;
  var __super_methodWithNullableEnumHandler = this.methodWithNullableEnumHandler;
  var __super_methodWithNullableEnumHandlerAsyncResult = this.methodWithNullableEnumHandlerAsyncResult;
  var __super_methodWithNullableEnumReturn = this.methodWithNullableEnumReturn;
  var __super_methodWithNonNullableGenEnumParam = this.methodWithNonNullableGenEnumParam;
  var __super_methodWithNullableGenEnumParam = this.methodWithNullableGenEnumParam;
  var __super_methodWithNullableGenEnumHandler = this.methodWithNullableGenEnumHandler;
  var __super_methodWithNullableGenEnumHandlerAsyncResult = this.methodWithNullableGenEnumHandlerAsyncResult;
  var __super_methodWithNullableGenEnumReturn = this.methodWithNullableGenEnumReturn;
  var __super_methodWithNullableTypeVariableParam = this.methodWithNullableTypeVariableParam;
  var __super_methodWithNullableTypeVariableHandler = this.methodWithNullableTypeVariableHandler;
  var __super_methodWithNullableTypeVariableHandlerAsyncResult = this.methodWithNullableTypeVariableHandlerAsyncResult;
  var __super_methodWithNullableTypeVariableReturn = this.methodWithNullableTypeVariableReturn;
  var __super_methodWithNullableObjectParam = this.methodWithNullableObjectParam;
  var __super_methodWithNonNullableListByteParam = this.methodWithNonNullableListByteParam;
  var __super_methodWithNullableListByteParam = this.methodWithNullableListByteParam;
  var __super_methodWithNullableListByteHandler = this.methodWithNullableListByteHandler;
  var __super_methodWithNullableListByteHandlerAsyncResult = this.methodWithNullableListByteHandlerAsyncResult;
  var __super_methodWithNullableListByteReturn = this.methodWithNullableListByteReturn;
  var __super_methodWithNonNullableListShortParam = this.methodWithNonNullableListShortParam;
  var __super_methodWithNullableListShortParam = this.methodWithNullableListShortParam;
  var __super_methodWithNullableListShortHandler = this.methodWithNullableListShortHandler;
  var __super_methodWithNullableListShortHandlerAsyncResult = this.methodWithNullableListShortHandlerAsyncResult;
  var __super_methodWithNullableListShortReturn = this.methodWithNullableListShortReturn;
  var __super_methodWithNonNullableListIntegerParam = this.methodWithNonNullableListIntegerParam;
  var __super_methodWithNullableListIntegerParam = this.methodWithNullableListIntegerParam;
  var __super_methodWithNullableListIntegerHandler = this.methodWithNullableListIntegerHandler;
  var __super_methodWithNullableListIntegerHandlerAsyncResult = this.methodWithNullableListIntegerHandlerAsyncResult;
  var __super_methodWithNullableListIntegerReturn = this.methodWithNullableListIntegerReturn;
  var __super_methodWithNonNullableListLongParam = this.methodWithNonNullableListLongParam;
  var __super_methodWithNullableListLongParam = this.methodWithNullableListLongParam;
  var __super_methodWithNullableListLongHandler = this.methodWithNullableListLongHandler;
  var __super_methodWithNullableListLongHandlerAsyncResult = this.methodWithNullableListLongHandlerAsyncResult;
  var __super_methodWithNullableListLongReturn = this.methodWithNullableListLongReturn;
  var __super_methodWithNonNullableListFloatParam = this.methodWithNonNullableListFloatParam;
  var __super_methodWithNullableListFloatParam = this.methodWithNullableListFloatParam;
  var __super_methodWithNullableListFloatHandler = this.methodWithNullableListFloatHandler;
  var __super_methodWithNullableListFloatHandlerAsyncResult = this.methodWithNullableListFloatHandlerAsyncResult;
  var __super_methodWithNullableListFloatReturn = this.methodWithNullableListFloatReturn;
  var __super_methodWithNonNullableListDoubleParam = this.methodWithNonNullableListDoubleParam;
  var __super_methodWithNullableListDoubleParam = this.methodWithNullableListDoubleParam;
  var __super_methodWithNullableListDoubleHandler = this.methodWithNullableListDoubleHandler;
  var __super_methodWithNullableListDoubleHandlerAsyncResult = this.methodWithNullableListDoubleHandlerAsyncResult;
  var __super_methodWithNullableListDoubleReturn = this.methodWithNullableListDoubleReturn;
  var __super_methodWithNonNullableListBooleanParam = this.methodWithNonNullableListBooleanParam;
  var __super_methodWithNullableListBooleanParam = this.methodWithNullableListBooleanParam;
  var __super_methodWithNullableListBooleanHandler = this.methodWithNullableListBooleanHandler;
  var __super_methodWithNullableListBooleanHandlerAsyncResult = this.methodWithNullableListBooleanHandlerAsyncResult;
  var __super_methodWithNullableListBooleanReturn = this.methodWithNullableListBooleanReturn;
  var __super_methodWithNonNullableListStringParam = this.methodWithNonNullableListStringParam;
  var __super_methodWithNullableListStringParam = this.methodWithNullableListStringParam;
  var __super_methodWithNullableListStringHandler = this.methodWithNullableListStringHandler;
  var __super_methodWithNullableListStringHandlerAsyncResult = this.methodWithNullableListStringHandlerAsyncResult;
  var __super_methodWithNullableListStringReturn = this.methodWithNullableListStringReturn;
  var __super_methodWithNonNullableListCharParam = this.methodWithNonNullableListCharParam;
  var __super_methodWithNullableListCharParam = this.methodWithNullableListCharParam;
  var __super_methodWithNullableListCharHandler = this.methodWithNullableListCharHandler;
  var __super_methodWithNullableListCharHandlerAsyncResult = this.methodWithNullableListCharHandlerAsyncResult;
  var __super_methodWithNullableListCharReturn = this.methodWithNullableListCharReturn;
  var __super_methodWithNonNullableListJsonObjectParam = this.methodWithNonNullableListJsonObjectParam;
  var __super_methodWithNullableListJsonObjectParam = this.methodWithNullableListJsonObjectParam;
  var __super_methodWithNullableListJsonObjectHandler = this.methodWithNullableListJsonObjectHandler;
  var __super_methodWithNullableListJsonObjectHandlerAsyncResult = this.methodWithNullableListJsonObjectHandlerAsyncResult;
  var __super_methodWithNullableListJsonObjectReturn = this.methodWithNullableListJsonObjectReturn;
  var __super_methodWithNonNullableListJsonArrayParam = this.methodWithNonNullableListJsonArrayParam;
  var __super_methodWithNullableListJsonArrayParam = this.methodWithNullableListJsonArrayParam;
  var __super_methodWithNullableListJsonArrayHandler = this.methodWithNullableListJsonArrayHandler;
  var __super_methodWithNullableListJsonArrayHandlerAsyncResult = this.methodWithNullableListJsonArrayHandlerAsyncResult;
  var __super_methodWithNullableListJsonArrayReturn = this.methodWithNullableListJsonArrayReturn;
  var __super_methodWithNonNullableListApiParam = this.methodWithNonNullableListApiParam;
  var __super_methodWithNullableListApiParam = this.methodWithNullableListApiParam;
  var __super_methodWithNullableListApiHandler = this.methodWithNullableListApiHandler;
  var __super_methodWithNullableListApiHandlerAsyncResult = this.methodWithNullableListApiHandlerAsyncResult;
  var __super_methodWithNullableListApiReturn = this.methodWithNullableListApiReturn;
  var __super_methodWithNonNullableListDataObjectParam = this.methodWithNonNullableListDataObjectParam;
  var __super_methodWithNullableListDataObjectParam = this.methodWithNullableListDataObjectParam;
  var __super_methodWithNullableListDataObjectHandler = this.methodWithNullableListDataObjectHandler;
  var __super_methodWithNullableListDataObjectHandlerAsyncResult = this.methodWithNullableListDataObjectHandlerAsyncResult;
  var __super_methodWithNullableListDataObjectReturn = this.methodWithNullableListDataObjectReturn;
  var __super_methodWithNonNullableListEnumParam = this.methodWithNonNullableListEnumParam;
  var __super_methodWithNullableListEnumParam = this.methodWithNullableListEnumParam;
  var __super_methodWithNullableListEnumHandler = this.methodWithNullableListEnumHandler;
  var __super_methodWithNullableListEnumHandlerAsyncResult = this.methodWithNullableListEnumHandlerAsyncResult;
  var __super_methodWithNullableListEnumReturn = this.methodWithNullableListEnumReturn;
  var __super_methodWithNonNullableListGenEnumParam = this.methodWithNonNullableListGenEnumParam;
  var __super_methodWithNullableListGenEnumParam = this.methodWithNullableListGenEnumParam;
  var __super_methodWithNullableListGenEnumHandler = this.methodWithNullableListGenEnumHandler;
  var __super_methodWithNullableListGenEnumHandlerAsyncResult = this.methodWithNullableListGenEnumHandlerAsyncResult;
  var __super_methodWithNullableListGenEnumReturn = this.methodWithNullableListGenEnumReturn;
  var __super_methodWithNonNullableSetByteParam = this.methodWithNonNullableSetByteParam;
  var __super_methodWithNullableSetByteParam = this.methodWithNullableSetByteParam;
  var __super_methodWithNullableSetByteHandler = this.methodWithNullableSetByteHandler;
  var __super_methodWithNullableSetByteHandlerAsyncResult = this.methodWithNullableSetByteHandlerAsyncResult;
  var __super_methodWithNullableSetByteReturn = this.methodWithNullableSetByteReturn;
  var __super_methodWithNonNullableSetShortParam = this.methodWithNonNullableSetShortParam;
  var __super_methodWithNullableSetShortParam = this.methodWithNullableSetShortParam;
  var __super_methodWithNullableSetShortHandler = this.methodWithNullableSetShortHandler;
  var __super_methodWithNullableSetShortHandlerAsyncResult = this.methodWithNullableSetShortHandlerAsyncResult;
  var __super_methodWithNullableSetShortReturn = this.methodWithNullableSetShortReturn;
  var __super_methodWithNonNullableSetIntegerParam = this.methodWithNonNullableSetIntegerParam;
  var __super_methodWithNullableSetIntegerParam = this.methodWithNullableSetIntegerParam;
  var __super_methodWithNullableSetIntegerHandler = this.methodWithNullableSetIntegerHandler;
  var __super_methodWithNullableSetIntegerHandlerAsyncResult = this.methodWithNullableSetIntegerHandlerAsyncResult;
  var __super_methodWithNullableSetIntegerReturn = this.methodWithNullableSetIntegerReturn;
  var __super_methodWithNonNullableSetLongParam = this.methodWithNonNullableSetLongParam;
  var __super_methodWithNullableSetLongParam = this.methodWithNullableSetLongParam;
  var __super_methodWithNullableSetLongHandler = this.methodWithNullableSetLongHandler;
  var __super_methodWithNullableSetLongHandlerAsyncResult = this.methodWithNullableSetLongHandlerAsyncResult;
  var __super_methodWithNullableSetLongReturn = this.methodWithNullableSetLongReturn;
  var __super_methodWithNonNullableSetFloatParam = this.methodWithNonNullableSetFloatParam;
  var __super_methodWithNullableSetFloatParam = this.methodWithNullableSetFloatParam;
  var __super_methodWithNullableSetFloatHandler = this.methodWithNullableSetFloatHandler;
  var __super_methodWithNullableSetFloatHandlerAsyncResult = this.methodWithNullableSetFloatHandlerAsyncResult;
  var __super_methodWithNullableSetFloatReturn = this.methodWithNullableSetFloatReturn;
  var __super_methodWithNonNullableSetDoubleParam = this.methodWithNonNullableSetDoubleParam;
  var __super_methodWithNullableSetDoubleParam = this.methodWithNullableSetDoubleParam;
  var __super_methodWithNullableSetDoubleHandler = this.methodWithNullableSetDoubleHandler;
  var __super_methodWithNullableSetDoubleHandlerAsyncResult = this.methodWithNullableSetDoubleHandlerAsyncResult;
  var __super_methodWithNullableSetDoubleReturn = this.methodWithNullableSetDoubleReturn;
  var __super_methodWithNonNullableSetBooleanParam = this.methodWithNonNullableSetBooleanParam;
  var __super_methodWithNullableSetBooleanParam = this.methodWithNullableSetBooleanParam;
  var __super_methodWithNullableSetBooleanHandler = this.methodWithNullableSetBooleanHandler;
  var __super_methodWithNullableSetBooleanHandlerAsyncResult = this.methodWithNullableSetBooleanHandlerAsyncResult;
  var __super_methodWithNullableSetBooleanReturn = this.methodWithNullableSetBooleanReturn;
  var __super_methodWithNonNullableSetStringParam = this.methodWithNonNullableSetStringParam;
  var __super_methodWithNullableSetStringParam = this.methodWithNullableSetStringParam;
  var __super_methodWithNullableSetStringHandler = this.methodWithNullableSetStringHandler;
  var __super_methodWithNullableSetStringHandlerAsyncResult = this.methodWithNullableSetStringHandlerAsyncResult;
  var __super_methodWithNullableSetStringReturn = this.methodWithNullableSetStringReturn;
  var __super_methodWithNonNullableSetCharParam = this.methodWithNonNullableSetCharParam;
  var __super_methodWithNullableSetCharParam = this.methodWithNullableSetCharParam;
  var __super_methodWithNullableSetCharHandler = this.methodWithNullableSetCharHandler;
  var __super_methodWithNullableSetCharHandlerAsyncResult = this.methodWithNullableSetCharHandlerAsyncResult;
  var __super_methodWithNullableSetCharReturn = this.methodWithNullableSetCharReturn;
  var __super_methodWithNonNullableSetJsonObjectParam = this.methodWithNonNullableSetJsonObjectParam;
  var __super_methodWithNullableSetJsonObjectParam = this.methodWithNullableSetJsonObjectParam;
  var __super_methodWithNullableSetJsonObjectHandler = this.methodWithNullableSetJsonObjectHandler;
  var __super_methodWithNullableSetJsonObjectHandlerAsyncResult = this.methodWithNullableSetJsonObjectHandlerAsyncResult;
  var __super_methodWithNullableSetJsonObjectReturn = this.methodWithNullableSetJsonObjectReturn;
  var __super_methodWithNonNullableSetJsonArrayParam = this.methodWithNonNullableSetJsonArrayParam;
  var __super_methodWithNullableSetJsonArrayParam = this.methodWithNullableSetJsonArrayParam;
  var __super_methodWithNullableSetJsonArrayHandler = this.methodWithNullableSetJsonArrayHandler;
  var __super_methodWithNullableSetJsonArrayHandlerAsyncResult = this.methodWithNullableSetJsonArrayHandlerAsyncResult;
  var __super_methodWithNullableSetJsonArrayReturn = this.methodWithNullableSetJsonArrayReturn;
  var __super_methodWithNonNullableSetApiParam = this.methodWithNonNullableSetApiParam;
  var __super_methodWithNullableSetApiParam = this.methodWithNullableSetApiParam;
  var __super_methodWithNullableSetApiHandler = this.methodWithNullableSetApiHandler;
  var __super_methodWithNullableSetApiHandlerAsyncResult = this.methodWithNullableSetApiHandlerAsyncResult;
  var __super_methodWithNullableSetApiReturn = this.methodWithNullableSetApiReturn;
  var __super_methodWithNonNullableSetDataObjectParam = this.methodWithNonNullableSetDataObjectParam;
  var __super_methodWithNullableSetDataObjectParam = this.methodWithNullableSetDataObjectParam;
  var __super_methodWithNullableSetDataObjectHandler = this.methodWithNullableSetDataObjectHandler;
  var __super_methodWithNullableSetDataObjectHandlerAsyncResult = this.methodWithNullableSetDataObjectHandlerAsyncResult;
  var __super_methodWithNullableSetDataObjectReturn = this.methodWithNullableSetDataObjectReturn;
  var __super_methodWithNonNullableSetEnumParam = this.methodWithNonNullableSetEnumParam;
  var __super_methodWithNullableSetEnumParam = this.methodWithNullableSetEnumParam;
  var __super_methodWithNullableSetEnumHandler = this.methodWithNullableSetEnumHandler;
  var __super_methodWithNullableSetEnumHandlerAsyncResult = this.methodWithNullableSetEnumHandlerAsyncResult;
  var __super_methodWithNullableSetEnumReturn = this.methodWithNullableSetEnumReturn;
  var __super_methodWithNonNullableSetGenEnumParam = this.methodWithNonNullableSetGenEnumParam;
  var __super_methodWithNullableSetGenEnumParam = this.methodWithNullableSetGenEnumParam;
  var __super_methodWithNullableSetGenEnumHandler = this.methodWithNullableSetGenEnumHandler;
  var __super_methodWithNullableSetGenEnumHandlerAsyncResult = this.methodWithNullableSetGenEnumHandlerAsyncResult;
  var __super_methodWithNullableSetGenEnumReturn = this.methodWithNullableSetGenEnumReturn;
  var __super_methodWithNonNullableMapByteParam = this.methodWithNonNullableMapByteParam;
  var __super_methodWithNullableMapByteParam = this.methodWithNullableMapByteParam;
  var __super_methodWithNullableMapByteHandler = this.methodWithNullableMapByteHandler;
  var __super_methodWithNullableMapByteHandlerAsyncResult = this.methodWithNullableMapByteHandlerAsyncResult;
  var __super_methodWithNullableMapByteReturn = this.methodWithNullableMapByteReturn;
  var __super_methodWithNonNullableMapShortParam = this.methodWithNonNullableMapShortParam;
  var __super_methodWithNullableMapShortParam = this.methodWithNullableMapShortParam;
  var __super_methodWithNullableMapShortHandler = this.methodWithNullableMapShortHandler;
  var __super_methodWithNullableMapShortHandlerAsyncResult = this.methodWithNullableMapShortHandlerAsyncResult;
  var __super_methodWithNullableMapShortReturn = this.methodWithNullableMapShortReturn;
  var __super_methodWithNonNullableMapIntegerParam = this.methodWithNonNullableMapIntegerParam;
  var __super_methodWithNullableMapIntegerParam = this.methodWithNullableMapIntegerParam;
  var __super_methodWithNullableMapIntegerHandler = this.methodWithNullableMapIntegerHandler;
  var __super_methodWithNullableMapIntegerHandlerAsyncResult = this.methodWithNullableMapIntegerHandlerAsyncResult;
  var __super_methodWithNullableMapIntegerReturn = this.methodWithNullableMapIntegerReturn;
  var __super_methodWithNonNullableMapLongParam = this.methodWithNonNullableMapLongParam;
  var __super_methodWithNullableMapLongParam = this.methodWithNullableMapLongParam;
  var __super_methodWithNullableMapLongHandler = this.methodWithNullableMapLongHandler;
  var __super_methodWithNullableMapLongHandlerAsyncResult = this.methodWithNullableMapLongHandlerAsyncResult;
  var __super_methodWithNullableMapLongReturn = this.methodWithNullableMapLongReturn;
  var __super_methodWithNonNullableMapFloatParam = this.methodWithNonNullableMapFloatParam;
  var __super_methodWithNullableMapFloatParam = this.methodWithNullableMapFloatParam;
  var __super_methodWithNullableMapFloatHandler = this.methodWithNullableMapFloatHandler;
  var __super_methodWithNullableMapFloatHandlerAsyncResult = this.methodWithNullableMapFloatHandlerAsyncResult;
  var __super_methodWithNullableMapFloatReturn = this.methodWithNullableMapFloatReturn;
  var __super_methodWithNonNullableMapDoubleParam = this.methodWithNonNullableMapDoubleParam;
  var __super_methodWithNullableMapDoubleParam = this.methodWithNullableMapDoubleParam;
  var __super_methodWithNullableMapDoubleHandler = this.methodWithNullableMapDoubleHandler;
  var __super_methodWithNullableMapDoubleHandlerAsyncResult = this.methodWithNullableMapDoubleHandlerAsyncResult;
  var __super_methodWithNullableMapDoubleReturn = this.methodWithNullableMapDoubleReturn;
  var __super_methodWithNonNullableMapBooleanParam = this.methodWithNonNullableMapBooleanParam;
  var __super_methodWithNullableMapBooleanParam = this.methodWithNullableMapBooleanParam;
  var __super_methodWithNullableMapBooleanHandler = this.methodWithNullableMapBooleanHandler;
  var __super_methodWithNullableMapBooleanHandlerAsyncResult = this.methodWithNullableMapBooleanHandlerAsyncResult;
  var __super_methodWithNullableMapBooleanReturn = this.methodWithNullableMapBooleanReturn;
  var __super_methodWithNonNullableMapStringParam = this.methodWithNonNullableMapStringParam;
  var __super_methodWithNullableMapStringParam = this.methodWithNullableMapStringParam;
  var __super_methodWithNullableMapStringHandler = this.methodWithNullableMapStringHandler;
  var __super_methodWithNullableMapStringHandlerAsyncResult = this.methodWithNullableMapStringHandlerAsyncResult;
  var __super_methodWithNullableMapStringReturn = this.methodWithNullableMapStringReturn;
  var __super_methodWithNonNullableMapCharParam = this.methodWithNonNullableMapCharParam;
  var __super_methodWithNullableMapCharParam = this.methodWithNullableMapCharParam;
  var __super_methodWithNullableMapCharHandler = this.methodWithNullableMapCharHandler;
  var __super_methodWithNullableMapCharHandlerAsyncResult = this.methodWithNullableMapCharHandlerAsyncResult;
  var __super_methodWithNullableMapCharReturn = this.methodWithNullableMapCharReturn;
  var __super_methodWithNonNullableMapJsonObjectParam = this.methodWithNonNullableMapJsonObjectParam;
  var __super_methodWithNullableMapJsonObjectParam = this.methodWithNullableMapJsonObjectParam;
  var __super_methodWithNullableMapJsonObjectHandler = this.methodWithNullableMapJsonObjectHandler;
  var __super_methodWithNullableMapJsonObjectHandlerAsyncResult = this.methodWithNullableMapJsonObjectHandlerAsyncResult;
  var __super_methodWithNullableMapJsonObjectReturn = this.methodWithNullableMapJsonObjectReturn;
  var __super_methodWithNonNullableMapJsonArrayParam = this.methodWithNonNullableMapJsonArrayParam;
  var __super_methodWithNullableMapJsonArrayParam = this.methodWithNullableMapJsonArrayParam;
  var __super_methodWithNullableMapJsonArrayHandler = this.methodWithNullableMapJsonArrayHandler;
  var __super_methodWithNullableMapJsonArrayHandlerAsyncResult = this.methodWithNullableMapJsonArrayHandlerAsyncResult;
  var __super_methodWithNullableMapJsonArrayReturn = this.methodWithNullableMapJsonArrayReturn;
  var __super_methodWithNonNullableMapApiParam = this.methodWithNonNullableMapApiParam;
  var __super_methodWithNullableMapApiParam = this.methodWithNullableMapApiParam;
  var __super_methodWithListNullableByteParam = this.methodWithListNullableByteParam;
  var __super_methodWithListNullableByteHandler = this.methodWithListNullableByteHandler;
  var __super_methodWithListNullableByteHandlerAsyncResult = this.methodWithListNullableByteHandlerAsyncResult;
  var __super_methodWithListNullableByteReturn = this.methodWithListNullableByteReturn;
  var __super_methodWithListNullableShortParam = this.methodWithListNullableShortParam;
  var __super_methodWithListNullableShortHandler = this.methodWithListNullableShortHandler;
  var __super_methodWithListNullableShortHandlerAsyncResult = this.methodWithListNullableShortHandlerAsyncResult;
  var __super_methodWithListNullableShortReturn = this.methodWithListNullableShortReturn;
  var __super_methodWithListNullableIntegerParam = this.methodWithListNullableIntegerParam;
  var __super_methodWithListNullableIntegerHandler = this.methodWithListNullableIntegerHandler;
  var __super_methodWithListNullableIntegerHandlerAsyncResult = this.methodWithListNullableIntegerHandlerAsyncResult;
  var __super_methodWithListNullableIntegerReturn = this.methodWithListNullableIntegerReturn;
  var __super_methodWithListNullableLongParam = this.methodWithListNullableLongParam;
  var __super_methodWithListNullableLongHandler = this.methodWithListNullableLongHandler;
  var __super_methodWithListNullableLongHandlerAsyncResult = this.methodWithListNullableLongHandlerAsyncResult;
  var __super_methodWithListNullableLongReturn = this.methodWithListNullableLongReturn;
  var __super_methodWithListNullableBooleanParam = this.methodWithListNullableBooleanParam;
  var __super_methodWithListNullableBooleanHandler = this.methodWithListNullableBooleanHandler;
  var __super_methodWithListNullableBooleanHandlerAsyncResult = this.methodWithListNullableBooleanHandlerAsyncResult;
  var __super_methodWithListNullableBooleanReturn = this.methodWithListNullableBooleanReturn;
  var __super_methodWithListNullableFloatParam = this.methodWithListNullableFloatParam;
  var __super_methodWithListNullableFloatHandler = this.methodWithListNullableFloatHandler;
  var __super_methodWithListNullableFloatHandlerAsyncResult = this.methodWithListNullableFloatHandlerAsyncResult;
  var __super_methodWithListNullableFloatReturn = this.methodWithListNullableFloatReturn;
  var __super_methodWithListNullableDoubleParam = this.methodWithListNullableDoubleParam;
  var __super_methodWithListNullableDoubleHandler = this.methodWithListNullableDoubleHandler;
  var __super_methodWithListNullableDoubleHandlerAsyncResult = this.methodWithListNullableDoubleHandlerAsyncResult;
  var __super_methodWithListNullableDoubleReturn = this.methodWithListNullableDoubleReturn;
  var __super_methodWithListNullableStringParam = this.methodWithListNullableStringParam;
  var __super_methodWithListNullableStringHandler = this.methodWithListNullableStringHandler;
  var __super_methodWithListNullableStringHandlerAsyncResult = this.methodWithListNullableStringHandlerAsyncResult;
  var __super_methodWithListNullableStringReturn = this.methodWithListNullableStringReturn;
  var __super_methodWithListNullableCharParam = this.methodWithListNullableCharParam;
  var __super_methodWithListNullableCharHandler = this.methodWithListNullableCharHandler;
  var __super_methodWithListNullableCharHandlerAsyncResult = this.methodWithListNullableCharHandlerAsyncResult;
  var __super_methodWithListNullableCharReturn = this.methodWithListNullableCharReturn;
  var __super_methodWithListNullableJsonObjectParam = this.methodWithListNullableJsonObjectParam;
  var __super_methodWithListNullableJsonObjectHandler = this.methodWithListNullableJsonObjectHandler;
  var __super_methodWithListNullableJsonObjectHandlerAsyncResult = this.methodWithListNullableJsonObjectHandlerAsyncResult;
  var __super_methodWithListNullableJsonObjectReturn = this.methodWithListNullableJsonObjectReturn;
  var __super_methodWithListNullableJsonArrayParam = this.methodWithListNullableJsonArrayParam;
  var __super_methodWithListNullableJsonArrayHandler = this.methodWithListNullableJsonArrayHandler;
  var __super_methodWithListNullableJsonArrayHandlerAsyncResult = this.methodWithListNullableJsonArrayHandlerAsyncResult;
  var __super_methodWithListNullableJsonArrayReturn = this.methodWithListNullableJsonArrayReturn;
  var __super_methodWithListNullableApiParam = this.methodWithListNullableApiParam;
  var __super_methodWithListNullableApiHandler = this.methodWithListNullableApiHandler;
  var __super_methodWithListNullableApiHandlerAsyncResult = this.methodWithListNullableApiHandlerAsyncResult;
  var __super_methodWithListNullableApiReturn = this.methodWithListNullableApiReturn;
  var __super_methodWithListNullableDataObjectParam = this.methodWithListNullableDataObjectParam;
  var __super_methodWithListNullableDataObjectHandler = this.methodWithListNullableDataObjectHandler;
  var __super_methodWithListNullableDataObjectHandlerAsyncResult = this.methodWithListNullableDataObjectHandlerAsyncResult;
  var __super_methodWithListNullableDataObjectReturn = this.methodWithListNullableDataObjectReturn;
  var __super_methodWithListNullableEnumParam = this.methodWithListNullableEnumParam;
  var __super_methodWithListNullableEnumHandler = this.methodWithListNullableEnumHandler;
  var __super_methodWithListNullableEnumHandlerAsyncResult = this.methodWithListNullableEnumHandlerAsyncResult;
  var __super_methodWithListNullableEnumReturn = this.methodWithListNullableEnumReturn;
  var __super_methodWithListNullableGenEnumParam = this.methodWithListNullableGenEnumParam;
  var __super_methodWithListNullableGenEnumHandler = this.methodWithListNullableGenEnumHandler;
  var __super_methodWithListNullableGenEnumHandlerAsyncResult = this.methodWithListNullableGenEnumHandlerAsyncResult;
  var __super_methodWithListNullableGenEnumReturn = this.methodWithListNullableGenEnumReturn;
  var __super_methodWithSetNullableByteParam = this.methodWithSetNullableByteParam;
  var __super_methodWithSetNullableByteHandler = this.methodWithSetNullableByteHandler;
  var __super_methodWithSetNullableByteHandlerAsyncResult = this.methodWithSetNullableByteHandlerAsyncResult;
  var __super_methodWithSetNullableByteReturn = this.methodWithSetNullableByteReturn;
  var __super_methodWithSetNullableShortParam = this.methodWithSetNullableShortParam;
  var __super_methodWithSetNullableShortHandler = this.methodWithSetNullableShortHandler;
  var __super_methodWithSetNullableShortHandlerAsyncResult = this.methodWithSetNullableShortHandlerAsyncResult;
  var __super_methodWithSetNullableShortReturn = this.methodWithSetNullableShortReturn;
  var __super_methodWithSetNullableIntegerParam = this.methodWithSetNullableIntegerParam;
  var __super_methodWithSetNullableIntegerHandler = this.methodWithSetNullableIntegerHandler;
  var __super_methodWithSetNullableIntegerHandlerAsyncResult = this.methodWithSetNullableIntegerHandlerAsyncResult;
  var __super_methodWithSetNullableIntegerReturn = this.methodWithSetNullableIntegerReturn;
  var __super_methodWithSetNullableLongParam = this.methodWithSetNullableLongParam;
  var __super_methodWithSetNullableLongHandler = this.methodWithSetNullableLongHandler;
  var __super_methodWithSetNullableLongHandlerAsyncResult = this.methodWithSetNullableLongHandlerAsyncResult;
  var __super_methodWithSetNullableLongReturn = this.methodWithSetNullableLongReturn;
  var __super_methodWithSetNullableBooleanParam = this.methodWithSetNullableBooleanParam;
  var __super_methodWithSetNullableBooleanHandler = this.methodWithSetNullableBooleanHandler;
  var __super_methodWithSetNullableBooleanHandlerAsyncResult = this.methodWithSetNullableBooleanHandlerAsyncResult;
  var __super_methodWithSetNullableBooleanReturn = this.methodWithSetNullableBooleanReturn;
  var __super_methodWithSetNullableFloatParam = this.methodWithSetNullableFloatParam;
  var __super_methodWithSetNullableFloatHandler = this.methodWithSetNullableFloatHandler;
  var __super_methodWithSetNullableFloatHandlerAsyncResult = this.methodWithSetNullableFloatHandlerAsyncResult;
  var __super_methodWithSetNullableFloatReturn = this.methodWithSetNullableFloatReturn;
  var __super_methodWithSetNullableDoubleParam = this.methodWithSetNullableDoubleParam;
  var __super_methodWithSetNullableDoubleHandler = this.methodWithSetNullableDoubleHandler;
  var __super_methodWithSetNullableDoubleHandlerAsyncResult = this.methodWithSetNullableDoubleHandlerAsyncResult;
  var __super_methodWithSetNullableDoubleReturn = this.methodWithSetNullableDoubleReturn;
  var __super_methodWithSetNullableStringParam = this.methodWithSetNullableStringParam;
  var __super_methodWithSetNullableStringHandler = this.methodWithSetNullableStringHandler;
  var __super_methodWithSetNullableStringHandlerAsyncResult = this.methodWithSetNullableStringHandlerAsyncResult;
  var __super_methodWithSetNullableStringReturn = this.methodWithSetNullableStringReturn;
  var __super_methodWithSetNullableCharParam = this.methodWithSetNullableCharParam;
  var __super_methodWithSetNullableCharHandler = this.methodWithSetNullableCharHandler;
  var __super_methodWithSetNullableCharHandlerAsyncResult = this.methodWithSetNullableCharHandlerAsyncResult;
  var __super_methodWithSetNullableCharReturn = this.methodWithSetNullableCharReturn;
  var __super_methodWithSetNullableJsonObjectParam = this.methodWithSetNullableJsonObjectParam;
  var __super_methodWithSetNullableJsonObjectHandler = this.methodWithSetNullableJsonObjectHandler;
  var __super_methodWithSetNullableJsonObjectHandlerAsyncResult = this.methodWithSetNullableJsonObjectHandlerAsyncResult;
  var __super_methodWithSetNullableJsonObjectReturn = this.methodWithSetNullableJsonObjectReturn;
  var __super_methodWithSetNullableJsonArrayParam = this.methodWithSetNullableJsonArrayParam;
  var __super_methodWithSetNullableJsonArrayHandler = this.methodWithSetNullableJsonArrayHandler;
  var __super_methodWithSetNullableJsonArrayHandlerAsyncResult = this.methodWithSetNullableJsonArrayHandlerAsyncResult;
  var __super_methodWithSetNullableJsonArrayReturn = this.methodWithSetNullableJsonArrayReturn;
  var __super_methodWithSetNullableApiParam = this.methodWithSetNullableApiParam;
  var __super_methodWithSetNullableApiHandler = this.methodWithSetNullableApiHandler;
  var __super_methodWithSetNullableApiHandlerAsyncResult = this.methodWithSetNullableApiHandlerAsyncResult;
  var __super_methodWithSetNullableApiReturn = this.methodWithSetNullableApiReturn;
  var __super_methodWithSetNullableDataObjectParam = this.methodWithSetNullableDataObjectParam;
  var __super_methodWithSetNullableDataObjectHandler = this.methodWithSetNullableDataObjectHandler;
  var __super_methodWithSetNullableDataObjectHandlerAsyncResult = this.methodWithSetNullableDataObjectHandlerAsyncResult;
  var __super_methodWithSetNullableDataObjectReturn = this.methodWithSetNullableDataObjectReturn;
  var __super_methodWithSetNullableEnumParam = this.methodWithSetNullableEnumParam;
  var __super_methodWithSetNullableEnumHandler = this.methodWithSetNullableEnumHandler;
  var __super_methodWithSetNullableEnumHandlerAsyncResult = this.methodWithSetNullableEnumHandlerAsyncResult;
  var __super_methodWithSetNullableEnumReturn = this.methodWithSetNullableEnumReturn;
  var __super_methodWithSetNullableGenEnumParam = this.methodWithSetNullableGenEnumParam;
  var __super_methodWithSetNullableGenEnumHandler = this.methodWithSetNullableGenEnumHandler;
  var __super_methodWithSetNullableGenEnumHandlerAsyncResult = this.methodWithSetNullableGenEnumHandlerAsyncResult;
  var __super_methodWithSetNullableGenEnumReturn = this.methodWithSetNullableGenEnumReturn;
  var __super_methodWithMapNullableByteParam = this.methodWithMapNullableByteParam;
  var __super_methodWithMapNullableByteHandler = this.methodWithMapNullableByteHandler;
  var __super_methodWithMapNullableByteHandlerAsyncResult = this.methodWithMapNullableByteHandlerAsyncResult;
  var __super_methodWithMapNullableByteReturn = this.methodWithMapNullableByteReturn;
  var __super_methodWithMapNullableShortParam = this.methodWithMapNullableShortParam;
  var __super_methodWithMapNullableShortHandler = this.methodWithMapNullableShortHandler;
  var __super_methodWithMapNullableShortHandlerAsyncResult = this.methodWithMapNullableShortHandlerAsyncResult;
  var __super_methodWithMapNullableShortReturn = this.methodWithMapNullableShortReturn;
  var __super_methodWithMapNullableIntegerParam = this.methodWithMapNullableIntegerParam;
  var __super_methodWithMapNullableIntegerHandler = this.methodWithMapNullableIntegerHandler;
  var __super_methodWithMapNullableIntegerHandlerAsyncResult = this.methodWithMapNullableIntegerHandlerAsyncResult;
  var __super_methodWithMapNullableIntegerReturn = this.methodWithMapNullableIntegerReturn;
  var __super_methodWithMapNullableLongParam = this.methodWithMapNullableLongParam;
  var __super_methodWithMapNullableLongHandler = this.methodWithMapNullableLongHandler;
  var __super_methodWithMapNullableLongHandlerAsyncResult = this.methodWithMapNullableLongHandlerAsyncResult;
  var __super_methodWithMapNullableLongReturn = this.methodWithMapNullableLongReturn;
  var __super_methodWithMapNullableBooleanParam = this.methodWithMapNullableBooleanParam;
  var __super_methodWithMapNullableBooleanHandler = this.methodWithMapNullableBooleanHandler;
  var __super_methodWithMapNullableBooleanHandlerAsyncResult = this.methodWithMapNullableBooleanHandlerAsyncResult;
  var __super_methodWithMapNullableBooleanReturn = this.methodWithMapNullableBooleanReturn;
  var __super_methodWithMapNullableFloatParam = this.methodWithMapNullableFloatParam;
  var __super_methodWithMapNullableFloatHandler = this.methodWithMapNullableFloatHandler;
  var __super_methodWithMapNullableFloatHandlerAsyncResult = this.methodWithMapNullableFloatHandlerAsyncResult;
  var __super_methodWithMapNullableFloatReturn = this.methodWithMapNullableFloatReturn;
  var __super_methodWithMapNullableDoubleParam = this.methodWithMapNullableDoubleParam;
  var __super_methodWithMapNullableDoubleHandler = this.methodWithMapNullableDoubleHandler;
  var __super_methodWithMapNullableDoubleHandlerAsyncResult = this.methodWithMapNullableDoubleHandlerAsyncResult;
  var __super_methodWithMapNullableDoubleReturn = this.methodWithMapNullableDoubleReturn;
  var __super_methodWithMapNullableStringParam = this.methodWithMapNullableStringParam;
  var __super_methodWithMapNullableStringHandler = this.methodWithMapNullableStringHandler;
  var __super_methodWithMapNullableStringHandlerAsyncResult = this.methodWithMapNullableStringHandlerAsyncResult;
  var __super_methodWithMapNullableStringReturn = this.methodWithMapNullableStringReturn;
  var __super_methodWithMapNullableCharParam = this.methodWithMapNullableCharParam;
  var __super_methodWithMapNullableCharHandler = this.methodWithMapNullableCharHandler;
  var __super_methodWithMapNullableCharHandlerAsyncResult = this.methodWithMapNullableCharHandlerAsyncResult;
  var __super_methodWithMapNullableCharReturn = this.methodWithMapNullableCharReturn;
  var __super_methodWithMapNullableJsonObjectParam = this.methodWithMapNullableJsonObjectParam;
  var __super_methodWithMapNullableJsonObjectHandler = this.methodWithMapNullableJsonObjectHandler;
  var __super_methodWithMapNullableJsonObjectHandlerAsyncResult = this.methodWithMapNullableJsonObjectHandlerAsyncResult;
  var __super_methodWithMapNullableJsonObjectReturn = this.methodWithMapNullableJsonObjectReturn;
  var __super_methodWithMapNullableJsonArrayParam = this.methodWithMapNullableJsonArrayParam;
  var __super_methodWithMapNullableJsonArrayHandler = this.methodWithMapNullableJsonArrayHandler;
  var __super_methodWithMapNullableJsonArrayHandlerAsyncResult = this.methodWithMapNullableJsonArrayHandlerAsyncResult;
  var __super_methodWithMapNullableJsonArrayReturn = this.methodWithMapNullableJsonArrayReturn;
  var __super_methodWithMapNullableApiParam = this.methodWithMapNullableApiParam;
  var __super_methodWithNullableHandler = this.methodWithNullableHandler;
  var __super_methodWithNullableHandlerAsyncResult = this.methodWithNullableHandlerAsyncResult;
  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableByteParam(java.lang.Byte)"](utils.convParamByte(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableByteParam != 'undefined') {
      return __super_methodWithNonNullableByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableByteParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableByteParam(boolean,java.lang.Byte)"](__args[0], utils.convParamByte(__args[1]));
    } else if (typeof __super_methodWithNullableByteParam != 'undefined') {
      return __super_methodWithNullableByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableByteHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableByteHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableByteHandler != 'undefined') {
      return __super_methodWithNullableByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableByteHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableByteHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableByteReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableByteReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableByteReturn != 'undefined') {
      return __super_methodWithNullableByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableShortParam(java.lang.Short)"](utils.convParamShort(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableShortParam != 'undefined') {
      return __super_methodWithNonNullableShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableShortParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableShortParam(boolean,java.lang.Short)"](__args[0], utils.convParamShort(__args[1]));
    } else if (typeof __super_methodWithNullableShortParam != 'undefined') {
      return __super_methodWithNullableShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableShortHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableShortHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableShortHandler != 'undefined') {
      return __super_methodWithNullableShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableShortHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableShortHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableShortReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableShortReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableShortReturn != 'undefined') {
      return __super_methodWithNullableShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableIntegerParam(java.lang.Integer)"](utils.convParamInteger(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableIntegerParam != 'undefined') {
      return __super_methodWithNonNullableIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableIntegerParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableIntegerParam(boolean,java.lang.Integer)"](__args[0], utils.convParamInteger(__args[1]));
    } else if (typeof __super_methodWithNullableIntegerParam != 'undefined') {
      return __super_methodWithNullableIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableIntegerHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableIntegerHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableIntegerHandler != 'undefined') {
      return __super_methodWithNullableIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableIntegerHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableIntegerHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableIntegerReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableIntegerReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableIntegerReturn != 'undefined') {
      return __super_methodWithNullableIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableLongParam(java.lang.Long)"](utils.convParamLong(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableLongParam != 'undefined') {
      return __super_methodWithNonNullableLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableLongParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableLongParam(boolean,java.lang.Long)"](__args[0], utils.convParamLong(__args[1]));
    } else if (typeof __super_methodWithNullableLongParam != 'undefined') {
      return __super_methodWithNullableLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableLongHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableLongHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnLong(jVal));
      });
    } else if (typeof __super_methodWithNullableLongHandler != 'undefined') {
      return __super_methodWithNullableLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableLongHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableLongHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnLong(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableLongReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnLong(j_nullableTCK["methodWithNullableLongReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableLongReturn != 'undefined') {
      return __super_methodWithNullableLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableFloatParam(java.lang.Float)"](utils.convParamFloat(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableFloatParam != 'undefined') {
      return __super_methodWithNonNullableFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableFloatParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableFloatParam(boolean,java.lang.Float)"](__args[0], utils.convParamFloat(__args[1]));
    } else if (typeof __super_methodWithNullableFloatParam != 'undefined') {
      return __super_methodWithNullableFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableFloatHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableFloatHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableFloatHandler != 'undefined') {
      return __super_methodWithNullableFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableFloatHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableFloatHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableFloatReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableFloatReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableFloatReturn != 'undefined') {
      return __super_methodWithNullableFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {number} 
   @return {boolean}
   */
  this.methodWithNonNullableDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='number') {
      return j_nullableTCK["methodWithNonNullableDoubleParam(java.lang.Double)"](utils.convParamDouble(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableDoubleParam != 'undefined') {
      return __super_methodWithNonNullableDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {number} 
   */
  this.methodWithNullableDoubleParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='number' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableDoubleParam(boolean,java.lang.Double)"](__args[0], utils.convParamDouble(__args[1]));
    } else if (typeof __super_methodWithNullableDoubleParam != 'undefined') {
      return __super_methodWithNullableDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableDoubleHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableDoubleHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableDoubleHandler != 'undefined') {
      return __super_methodWithNullableDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableDoubleHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableDoubleHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {number}
   */
  this.methodWithNullableDoubleReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableDoubleReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableDoubleReturn != 'undefined') {
      return __super_methodWithNullableDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {boolean} 
   @return {boolean}
   */
  this.methodWithNonNullableBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNonNullableBooleanParam(java.lang.Boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableBooleanParam != 'undefined') {
      return __super_methodWithNonNullableBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {boolean} 
   */
  this.methodWithNullableBooleanParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='boolean' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableBooleanParam(boolean,java.lang.Boolean)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableBooleanParam != 'undefined') {
      return __super_methodWithNullableBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableBooleanHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableBooleanHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableBooleanHandler != 'undefined') {
      return __super_methodWithNullableBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableBooleanHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableBooleanHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {boolean}
   */
  this.methodWithNullableBooleanReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableBooleanReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableBooleanReturn != 'undefined') {
      return __super_methodWithNullableBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {string} 
   @return {boolean}
   */
  this.methodWithNonNullableStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_nullableTCK["methodWithNonNullableStringParam(java.lang.String)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableStringParam != 'undefined') {
      return __super_methodWithNonNullableStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {string} 
   */
  this.methodWithNullableStringParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] === 'string' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableStringParam(boolean,java.lang.String)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableStringParam != 'undefined') {
      return __super_methodWithNullableStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableStringHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableStringHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableStringHandler != 'undefined') {
      return __super_methodWithNullableStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableStringHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableStringHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {string}
   */
  this.methodWithNullableStringReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableStringReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableStringReturn != 'undefined') {
      return __super_methodWithNullableStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {string} 
   @return {boolean}
   */
  this.methodWithNonNullableCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='string') {
      return j_nullableTCK["methodWithNonNullableCharParam(java.lang.Character)"](utils.convParamCharacter(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableCharParam != 'undefined') {
      return __super_methodWithNonNullableCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {string} 
   */
  this.methodWithNullableCharParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] ==='string' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableCharParam(boolean,java.lang.Character)"](__args[0], utils.convParamCharacter(__args[1]));
    } else if (typeof __super_methodWithNullableCharParam != 'undefined') {
      return __super_methodWithNullableCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableCharHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableCharHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableCharHandler != 'undefined') {
      return __super_methodWithNullableCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableCharHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableCharHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {string}
   */
  this.methodWithNullableCharReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableCharReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableCharReturn != 'undefined') {
      return __super_methodWithNullableCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object} 
   @return {boolean}
   */
  this.methodWithNonNullableJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableJsonObjectParam(io.vertx.core.json.JsonObject)"](utils.convParamJsonObject(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableJsonObjectParam != 'undefined') {
      return __super_methodWithNonNullableJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableJsonObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableJsonObjectParam(boolean,io.vertx.core.json.JsonObject)"](__args[0], utils.convParamJsonObject(__args[1]));
    } else if (typeof __super_methodWithNullableJsonObjectParam != 'undefined') {
      return __super_methodWithNullableJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableJsonObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableJsonObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnJson(jVal));
      });
    } else if (typeof __super_methodWithNullableJsonObjectHandler != 'undefined') {
      return __super_methodWithNullableJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableJsonObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableJsonObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object}
   */
  this.methodWithNullableJsonObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnJson(j_nullableTCK["methodWithNullableJsonObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableJsonObjectReturn != 'undefined') {
      return __super_methodWithNullableJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array} 
   @return {boolean}
   */
  this.methodWithNonNullableJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableJsonArrayParam(io.vertx.core.json.JsonArray)"](utils.convParamJsonArray(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableJsonArrayParam != 'undefined') {
      return __super_methodWithNonNullableJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array} 
   */
  this.methodWithNullableJsonArrayParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableJsonArrayParam(boolean,io.vertx.core.json.JsonArray)"](__args[0], utils.convParamJsonArray(__args[1]));
    } else if (typeof __super_methodWithNullableJsonArrayParam != 'undefined') {
      return __super_methodWithNullableJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableJsonArrayHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableJsonArrayHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnJson(jVal));
      });
    } else if (typeof __super_methodWithNullableJsonArrayHandler != 'undefined') {
      return __super_methodWithNullableJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableJsonArrayHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableJsonArrayHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array}
   */
  this.methodWithNullableJsonArrayReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnJson(j_nullableTCK["methodWithNullableJsonArrayReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableJsonArrayReturn != 'undefined') {
      return __super_methodWithNullableJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {RefedInterface1} 
   @return {boolean}
   */
  this.methodWithNonNullableApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return j_nullableTCK["methodWithNonNullableApiParam(io.vertx.codegen.testmodel.RefedInterface1)"](__args[0]._jdel) ;
    } else if (typeof __super_methodWithNonNullableApiParam != 'undefined') {
      return __super_methodWithNonNullableApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {RefedInterface1} 
   */
  this.methodWithNullableApiParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] == null || __args[1]._jdel)) {
      j_nullableTCK["methodWithNullableApiParam(boolean,io.vertx.codegen.testmodel.RefedInterface1)"](__args[0], __args[1] == null ? null : __args[1]._jdel);
    } else if (typeof __super_methodWithNullableApiParam != 'undefined') {
      return __super_methodWithNullableApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableApiHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableApiHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnVertxGen(RefedInterface1, jVal));
      });
    } else if (typeof __super_methodWithNullableApiHandler != 'undefined') {
      return __super_methodWithNullableApiHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableApiHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableApiHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RefedInterface1, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableApiHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableApiHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {RefedInterface1}
   */
  this.methodWithNullableApiReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnVertxGen(RefedInterface1, j_nullableTCK["methodWithNullableApiReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableApiReturn != 'undefined') {
      return __super_methodWithNullableApiReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object} 
   @return {boolean}
   */
  this.methodWithNonNullableDataObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableDataObjectParam(io.vertx.codegen.testmodel.TestDataObject)"](__args[0]  != null ? new TestDataObject(new JsonObject(Java.asJSONCompatible(__args[0]))) : null) ;
    } else if (typeof __super_methodWithNonNullableDataObjectParam != 'undefined') {
      return __super_methodWithNonNullableDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableDataObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableDataObjectParam(boolean,io.vertx.codegen.testmodel.TestDataObject)"](__args[0], __args[1]  != null ? new TestDataObject(new JsonObject(Java.asJSONCompatible(__args[1]))) : null);
    } else if (typeof __super_methodWithNullableDataObjectParam != 'undefined') {
      return __super_methodWithNullableDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableDataObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableDataObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnDataObject(jVal));
      });
    } else if (typeof __super_methodWithNullableDataObjectHandler != 'undefined') {
      return __super_methodWithNullableDataObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableDataObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableDataObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableDataObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableDataObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object}
   */
  this.methodWithNullableDataObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnDataObject(j_nullableTCK["methodWithNullableDataObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableDataObjectReturn != 'undefined') {
      return __super_methodWithNullableDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object} 
   @return {boolean}
   */
  this.methodWithNonNullableEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_nullableTCK["methodWithNonNullableEnumParam(io.vertx.codegen.testmodel.TestEnum)"](io.vertx.codegen.testmodel.TestEnum.valueOf(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableEnumParam != 'undefined') {
      return __super_methodWithNonNullableEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] === 'string' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableEnumParam(boolean,io.vertx.codegen.testmodel.TestEnum)"](__args[0], __args[1] == null ? null : io.vertx.codegen.testmodel.TestEnum.valueOf(__args[1]));
    } else if (typeof __super_methodWithNullableEnumParam != 'undefined') {
      return __super_methodWithNullableEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableEnumHandler != 'undefined') {
      return __super_methodWithNullableEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object}
   */
  this.methodWithNullableEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnEnum(j_nullableTCK["methodWithNullableEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableEnumReturn != 'undefined') {
      return __super_methodWithNullableEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object} 
   @return {boolean}
   */
  this.methodWithNonNullableGenEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_nullableTCK["methodWithNonNullableGenEnumParam(io.vertx.codegen.testmodel.TestGenEnum)"](io.vertx.codegen.testmodel.TestGenEnum.valueOf(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableGenEnumParam != 'undefined') {
      return __super_methodWithNonNullableGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableGenEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] === 'string' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableGenEnumParam(boolean,io.vertx.codegen.testmodel.TestGenEnum)"](__args[0], __args[1] == null ? null : io.vertx.codegen.testmodel.TestGenEnum.valueOf(__args[1]));
    } else if (typeof __super_methodWithNullableGenEnumParam != 'undefined') {
      return __super_methodWithNullableGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableGenEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableGenEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableGenEnumHandler != 'undefined') {
      return __super_methodWithNullableGenEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableGenEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableGenEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableGenEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableGenEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object}
   */
  this.methodWithNullableGenEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnEnum(j_nullableTCK["methodWithNullableGenEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableGenEnumReturn != 'undefined') {
      return __super_methodWithNullableGenEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableTypeVariableParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] !== 'function') {
      j_nullableTCK["methodWithNullableTypeVariableParam(boolean,java.lang.Object)"](__args[0], utils.convParamTypeUnknown(__args[1]));
    } else if (typeof __super_methodWithNullableTypeVariableParam != 'undefined') {
      return __super_methodWithNullableTypeVariableParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param value {Object} 
   @param handler {function} 
   */
  this.methodWithNullableTypeVariableHandler =  function(notNull, value, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] ==='boolean' && typeof __args[1] !== 'function' && typeof __args[2] === 'function') {
      j_nullableTCK["methodWithNullableTypeVariableHandler(boolean,java.lang.Object,io.vertx.core.Handler)"](__args[0], utils.convParamTypeUnknown(__args[1]), function(jVal) {
        __args[2](utils.convReturnTypeUnknown(jVal));
      });
    } else if (typeof __super_methodWithNullableTypeVariableHandler != 'undefined') {
      return __super_methodWithNullableTypeVariableHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param value {Object} 
   @param handler {function} 
   */
  this.methodWithNullableTypeVariableHandlerAsyncResult =  function(notNull, value, handler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] ==='boolean' && typeof __args[1] !== 'function' && typeof __args[2] === 'function') {
      j_nullableTCK["methodWithNullableTypeVariableHandlerAsyncResult(boolean,java.lang.Object,io.vertx.core.Handler)"](__args[0], utils.convParamTypeUnknown(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnTypeUnknown(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableTypeVariableHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableTypeVariableHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param value {Object} 
   @return {Object}
   */
  this.methodWithNullableTypeVariableReturn =  function(notNull, value) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] !== 'function') {
      return utils.convReturnTypeUnknown(j_nullableTCK["methodWithNullableTypeVariableReturn(boolean,java.lang.Object)"](__args[0], utils.convParamTypeUnknown(__args[1]))) ;
    } else if (typeof __super_methodWithNullableTypeVariableReturn != 'undefined') {
      return __super_methodWithNullableTypeVariableReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object} 
   */
  this.methodWithNullableObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] !== 'function') {
      j_nullableTCK["methodWithNullableObjectParam(boolean,java.lang.Object)"](__args[0], utils.convParamTypeUnknown(__args[1]));
    } else if (typeof __super_methodWithNullableObjectParam != 'undefined') {
      return __super_methodWithNullableObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListByteParam(java.util.List)"](utils.convParamListByte(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListByteParam != 'undefined') {
      return __super_methodWithNonNullableListByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListByteParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListByteParam(boolean,java.util.List)"](__args[0], utils.convParamListByte(__args[1]));
    } else if (typeof __super_methodWithNullableListByteParam != 'undefined') {
      return __super_methodWithNullableListByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListByteHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListByteHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListByteHandler != 'undefined') {
      return __super_methodWithNullableListByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListByteHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListByteHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListByteReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListByteReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListByteReturn != 'undefined') {
      return __super_methodWithNullableListByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListShortParam(java.util.List)"](utils.convParamListShort(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListShortParam != 'undefined') {
      return __super_methodWithNonNullableListShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListShortParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListShortParam(boolean,java.util.List)"](__args[0], utils.convParamListShort(__args[1]));
    } else if (typeof __super_methodWithNullableListShortParam != 'undefined') {
      return __super_methodWithNullableListShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListShortHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListShortHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListShortHandler != 'undefined') {
      return __super_methodWithNullableListShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListShortHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListShortHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListShortReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListShortReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListShortReturn != 'undefined') {
      return __super_methodWithNullableListShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListIntegerParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListIntegerParam != 'undefined') {
      return __super_methodWithNonNullableListIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListIntegerParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListIntegerParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListIntegerParam != 'undefined') {
      return __super_methodWithNullableListIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListIntegerHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListIntegerHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListIntegerHandler != 'undefined') {
      return __super_methodWithNullableListIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListIntegerHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListIntegerHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListIntegerReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListIntegerReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListIntegerReturn != 'undefined') {
      return __super_methodWithNullableListIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListLongParam(java.util.List)"](utils.convParamListLong(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListLongParam != 'undefined') {
      return __super_methodWithNonNullableListLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListLongParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListLongParam(boolean,java.util.List)"](__args[0], utils.convParamListLong(__args[1]));
    } else if (typeof __super_methodWithNullableListLongParam != 'undefined') {
      return __super_methodWithNullableListLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListLongHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListLongHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetLong(jVal));
      });
    } else if (typeof __super_methodWithNullableListLongHandler != 'undefined') {
      return __super_methodWithNullableListLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListLongHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListLongHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetLong(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListLongReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetLong(j_nullableTCK["methodWithNullableListLongReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListLongReturn != 'undefined') {
      return __super_methodWithNullableListLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListFloatParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListFloatParam != 'undefined') {
      return __super_methodWithNonNullableListFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListFloatParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListFloatParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListFloatParam != 'undefined') {
      return __super_methodWithNullableListFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListFloatHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListFloatHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListFloatHandler != 'undefined') {
      return __super_methodWithNullableListFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListFloatHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListFloatHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListFloatReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListFloatReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListFloatReturn != 'undefined') {
      return __super_methodWithNullableListFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableListDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListDoubleParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListDoubleParam != 'undefined') {
      return __super_methodWithNonNullableListDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableListDoubleParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListDoubleParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListDoubleParam != 'undefined') {
      return __super_methodWithNullableListDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListDoubleHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListDoubleHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListDoubleHandler != 'undefined') {
      return __super_methodWithNullableListDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListDoubleHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListDoubleHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableListDoubleReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListDoubleReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListDoubleReturn != 'undefined') {
      return __super_methodWithNullableListDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<boolean>} 
   @return {boolean}
   */
  this.methodWithNonNullableListBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListBooleanParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListBooleanParam != 'undefined') {
      return __super_methodWithNonNullableListBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<boolean>} 
   */
  this.methodWithNullableListBooleanParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListBooleanParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListBooleanParam != 'undefined') {
      return __super_methodWithNullableListBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListBooleanHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListBooleanHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListBooleanHandler != 'undefined') {
      return __super_methodWithNullableListBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListBooleanHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListBooleanHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<boolean>}
   */
  this.methodWithNullableListBooleanReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListBooleanReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListBooleanReturn != 'undefined') {
      return __super_methodWithNullableListBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   @return {boolean}
   */
  this.methodWithNonNullableListStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListStringParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListStringParam != 'undefined') {
      return __super_methodWithNonNullableListStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<string>} 
   */
  this.methodWithNullableListStringParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListStringParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListStringParam != 'undefined') {
      return __super_methodWithNullableListStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListStringHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListStringHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListStringHandler != 'undefined') {
      return __super_methodWithNullableListStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListStringHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListStringHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<string>}
   */
  this.methodWithNullableListStringReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListStringReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListStringReturn != 'undefined') {
      return __super_methodWithNullableListStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   @return {boolean}
   */
  this.methodWithNonNullableListCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListCharParam(java.util.List)"](utils.convParamListBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListCharParam != 'undefined') {
      return __super_methodWithNonNullableListCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<string>} 
   */
  this.methodWithNullableListCharParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListCharParam(boolean,java.util.List)"](__args[0], __args[1] == null ? null : utils.convParamListBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableListCharParam != 'undefined') {
      return __super_methodWithNullableListCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListCharHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListCharHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableListCharHandler != 'undefined') {
      return __super_methodWithNullableListCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListCharHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListCharHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<string>}
   */
  this.methodWithNullableListCharReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return j_nullableTCK["methodWithNullableListCharReturn(boolean)"](__args[0]) ;
    } else if (typeof __super_methodWithNullableListCharReturn != 'undefined') {
      return __super_methodWithNullableListCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableListJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListJsonObjectParam(java.util.List)"](utils.convParamListJsonObject(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListJsonObjectParam != 'undefined') {
      return __super_methodWithNonNullableListJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableListJsonObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListJsonObjectParam(boolean,java.util.List)"](__args[0], utils.convParamListJsonObject(__args[1]));
    } else if (typeof __super_methodWithNullableListJsonObjectParam != 'undefined') {
      return __super_methodWithNullableListJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListJsonObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListJsonObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithNullableListJsonObjectHandler != 'undefined') {
      return __super_methodWithNullableListJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListJsonObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListJsonObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableListJsonObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithNullableListJsonObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListJsonObjectReturn != 'undefined') {
      return __super_methodWithNullableListJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Array>} 
   @return {boolean}
   */
  this.methodWithNonNullableListJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListJsonArrayParam(java.util.List)"](utils.convParamListJsonArray(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListJsonArrayParam != 'undefined') {
      return __super_methodWithNonNullableListJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Array>} 
   */
  this.methodWithNullableListJsonArrayParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListJsonArrayParam(boolean,java.util.List)"](__args[0], utils.convParamListJsonArray(__args[1]));
    } else if (typeof __super_methodWithNullableListJsonArrayParam != 'undefined') {
      return __super_methodWithNullableListJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListJsonArrayHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListJsonArrayHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithNullableListJsonArrayHandler != 'undefined') {
      return __super_methodWithNullableListJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListJsonArrayHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListJsonArrayHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Array>}
   */
  this.methodWithNullableListJsonArrayReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithNullableListJsonArrayReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListJsonArrayReturn != 'undefined') {
      return __super_methodWithNullableListJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<RefedInterface1>} 
   @return {boolean}
   */
  this.methodWithNonNullableListApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListApiParam(java.util.List)"](utils.convParamListVertxGen(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableListApiParam != 'undefined') {
      return __super_methodWithNonNullableListApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<RefedInterface1>} 
   */
  this.methodWithNullableListApiParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListApiParam(boolean,java.util.List)"](__args[0], utils.convParamListVertxGen(__args[1]));
    } else if (typeof __super_methodWithNullableListApiParam != 'undefined') {
      return __super_methodWithNullableListApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListApiHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListApiHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithNullableListApiHandler != 'undefined') {
      return __super_methodWithNullableListApiHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListApiHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListApiHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListApiHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListApiHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<RefedInterface1>}
   */
  this.methodWithNullableListApiReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetVertxGen(j_nullableTCK["methodWithNullableListApiReturn(boolean)"](__args[0]), RefedInterface1) ;
    } else if (typeof __super_methodWithNullableListApiReturn != 'undefined') {
      return __super_methodWithNullableListApiReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableListDataObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListDataObjectParam(java.util.List)"](utils.convParamListDataObject(__args[0], function(json) { return new TestDataObject(json); })) ;
    } else if (typeof __super_methodWithNonNullableListDataObjectParam != 'undefined') {
      return __super_methodWithNonNullableListDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableListDataObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListDataObjectParam(boolean,java.util.List)"](__args[0], utils.convParamListDataObject(__args[1], function(json) { return new TestDataObject(json); }));
    } else if (typeof __super_methodWithNullableListDataObjectParam != 'undefined') {
      return __super_methodWithNullableListDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListDataObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListDataObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithNullableListDataObjectHandler != 'undefined') {
      return __super_methodWithNullableListDataObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListDataObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListDataObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListDataObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListDataObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableListDataObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetDataObject(j_nullableTCK["methodWithNullableListDataObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListDataObjectReturn != 'undefined') {
      return __super_methodWithNullableListDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableListEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListEnumParam(java.util.List)"](utils.convParamListEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); })) ;
    } else if (typeof __super_methodWithNonNullableListEnumParam != 'undefined') {
      return __super_methodWithNonNullableListEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableListEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListEnumParam(boolean,java.util.List)"](__args[0], utils.convParamListEnum(__args[1], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }));
    } else if (typeof __super_methodWithNullableListEnumParam != 'undefined') {
      return __super_methodWithNullableListEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableListEnumHandler != 'undefined') {
      return __super_methodWithNullableListEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableListEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithNullableListEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListEnumReturn != 'undefined') {
      return __super_methodWithNullableListEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableListGenEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableListGenEnumParam(java.util.List)"](utils.convParamListEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); })) ;
    } else if (typeof __super_methodWithNonNullableListGenEnumParam != 'undefined') {
      return __super_methodWithNonNullableListGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableListGenEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableListGenEnumParam(boolean,java.util.List)"](__args[0], utils.convParamListEnum(__args[1], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); }));
    } else if (typeof __super_methodWithNullableListGenEnumParam != 'undefined') {
      return __super_methodWithNullableListGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListGenEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListGenEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableListGenEnumHandler != 'undefined') {
      return __super_methodWithNullableListGenEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableListGenEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableListGenEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableListGenEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableListGenEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableListGenEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithNullableListGenEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableListGenEnumReturn != 'undefined') {
      return __super_methodWithNullableListGenEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetByteParam(java.util.Set)"](utils.convParamSetByte(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetByteParam != 'undefined') {
      return __super_methodWithNonNullableSetByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetByteParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetByteParam(boolean,java.util.Set)"](__args[0], utils.convParamSetByte(__args[1]));
    } else if (typeof __super_methodWithNullableSetByteParam != 'undefined') {
      return __super_methodWithNullableSetByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetByteHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetByteHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetByteHandler != 'undefined') {
      return __super_methodWithNullableSetByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetByteHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetByteHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetByteReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetByteReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetByteReturn != 'undefined') {
      return __super_methodWithNullableSetByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetShortParam(java.util.Set)"](utils.convParamSetShort(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetShortParam != 'undefined') {
      return __super_methodWithNonNullableSetShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetShortParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetShortParam(boolean,java.util.Set)"](__args[0], utils.convParamSetShort(__args[1]));
    } else if (typeof __super_methodWithNullableSetShortParam != 'undefined') {
      return __super_methodWithNullableSetShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetShortHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetShortHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetShortHandler != 'undefined') {
      return __super_methodWithNullableSetShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetShortHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetShortHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetShortReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetShortReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetShortReturn != 'undefined') {
      return __super_methodWithNullableSetShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetIntegerParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetIntegerParam != 'undefined') {
      return __super_methodWithNonNullableSetIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetIntegerParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetIntegerParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetIntegerParam != 'undefined') {
      return __super_methodWithNullableSetIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetIntegerHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetIntegerHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetIntegerHandler != 'undefined') {
      return __super_methodWithNullableSetIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetIntegerHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetIntegerHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetIntegerReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetIntegerReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetIntegerReturn != 'undefined') {
      return __super_methodWithNullableSetIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetLongParam(java.util.Set)"](utils.convParamSetLong(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetLongParam != 'undefined') {
      return __super_methodWithNonNullableSetLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetLongParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetLongParam(boolean,java.util.Set)"](__args[0], utils.convParamSetLong(__args[1]));
    } else if (typeof __super_methodWithNullableSetLongParam != 'undefined') {
      return __super_methodWithNullableSetLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetLongHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetLongHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetLong(jVal));
      });
    } else if (typeof __super_methodWithNullableSetLongHandler != 'undefined') {
      return __super_methodWithNullableSetLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetLongHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetLongHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetLong(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetLongReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetLong(j_nullableTCK["methodWithNullableSetLongReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetLongReturn != 'undefined') {
      return __super_methodWithNullableSetLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetFloatParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetFloatParam != 'undefined') {
      return __super_methodWithNonNullableSetFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetFloatParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetFloatParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetFloatParam != 'undefined') {
      return __super_methodWithNullableSetFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetFloatHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetFloatHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetFloatHandler != 'undefined') {
      return __super_methodWithNullableSetFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetFloatHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetFloatHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetFloatReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetFloatReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetFloatReturn != 'undefined') {
      return __super_methodWithNullableSetFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetDoubleParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetDoubleParam != 'undefined') {
      return __super_methodWithNonNullableSetDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<number>} 
   */
  this.methodWithNullableSetDoubleParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetDoubleParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetDoubleParam != 'undefined') {
      return __super_methodWithNullableSetDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetDoubleHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetDoubleHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetDoubleHandler != 'undefined') {
      return __super_methodWithNullableSetDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetDoubleHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetDoubleHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<number>}
   */
  this.methodWithNullableSetDoubleReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetDoubleReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetDoubleReturn != 'undefined') {
      return __super_methodWithNullableSetDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<boolean>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetBooleanParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetBooleanParam != 'undefined') {
      return __super_methodWithNonNullableSetBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<boolean>} 
   */
  this.methodWithNullableSetBooleanParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetBooleanParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetBooleanParam != 'undefined') {
      return __super_methodWithNullableSetBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetBooleanHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetBooleanHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetBooleanHandler != 'undefined') {
      return __super_methodWithNullableSetBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetBooleanHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetBooleanHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<boolean>}
   */
  this.methodWithNullableSetBooleanReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetBooleanReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetBooleanReturn != 'undefined') {
      return __super_methodWithNullableSetBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetStringParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetStringParam != 'undefined') {
      return __super_methodWithNonNullableSetStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<string>} 
   */
  this.methodWithNullableSetStringParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetStringParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetStringParam != 'undefined') {
      return __super_methodWithNullableSetStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetStringHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetStringHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetStringHandler != 'undefined') {
      return __super_methodWithNullableSetStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetStringHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetStringHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<string>}
   */
  this.methodWithNullableSetStringReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetStringReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetStringReturn != 'undefined') {
      return __super_methodWithNullableSetStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetCharParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetCharParam != 'undefined') {
      return __super_methodWithNonNullableSetCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<string>} 
   */
  this.methodWithNullableSetCharParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetCharParam(boolean,java.util.Set)"](__args[0], __args[1] == null ? null : utils.convParamSetBasicOther(__args[1]));
    } else if (typeof __super_methodWithNullableSetCharParam != 'undefined') {
      return __super_methodWithNullableSetCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetCharHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetCharHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithNullableSetCharHandler != 'undefined') {
      return __super_methodWithNullableSetCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetCharHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetCharHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnSet(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<string>}
   */
  this.methodWithNullableSetCharReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnSet(j_nullableTCK["methodWithNullableSetCharReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetCharReturn != 'undefined') {
      return __super_methodWithNullableSetCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetJsonObjectParam(java.util.Set)"](utils.convParamSetJsonObject(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetJsonObjectParam != 'undefined') {
      return __super_methodWithNonNullableSetJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableSetJsonObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetJsonObjectParam(boolean,java.util.Set)"](__args[0], utils.convParamSetJsonObject(__args[1]));
    } else if (typeof __super_methodWithNullableSetJsonObjectParam != 'undefined') {
      return __super_methodWithNullableSetJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetJsonObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetJsonObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithNullableSetJsonObjectHandler != 'undefined') {
      return __super_methodWithNullableSetJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetJsonObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetJsonObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableSetJsonObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithNullableSetJsonObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetJsonObjectReturn != 'undefined') {
      return __super_methodWithNullableSetJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Array>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetJsonArrayParam(java.util.Set)"](utils.convParamSetJsonArray(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetJsonArrayParam != 'undefined') {
      return __super_methodWithNonNullableSetJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Array>} 
   */
  this.methodWithNullableSetJsonArrayParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetJsonArrayParam(boolean,java.util.Set)"](__args[0], utils.convParamSetJsonArray(__args[1]));
    } else if (typeof __super_methodWithNullableSetJsonArrayParam != 'undefined') {
      return __super_methodWithNullableSetJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetJsonArrayHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetJsonArrayHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithNullableSetJsonArrayHandler != 'undefined') {
      return __super_methodWithNullableSetJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetJsonArrayHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetJsonArrayHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Array>}
   */
  this.methodWithNullableSetJsonArrayReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithNullableSetJsonArrayReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetJsonArrayReturn != 'undefined') {
      return __super_methodWithNullableSetJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<RefedInterface1>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetApiParam(java.util.Set)"](utils.convParamSetVertxGen(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableSetApiParam != 'undefined') {
      return __super_methodWithNonNullableSetApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<RefedInterface1>} 
   */
  this.methodWithNullableSetApiParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetApiParam(boolean,java.util.Set)"](__args[0], utils.convParamSetVertxGen(__args[1]));
    } else if (typeof __super_methodWithNullableSetApiParam != 'undefined') {
      return __super_methodWithNullableSetApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetApiHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetApiHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithNullableSetApiHandler != 'undefined') {
      return __super_methodWithNullableSetApiHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetApiHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetApiHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetApiHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetApiHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<RefedInterface1>}
   */
  this.methodWithNullableSetApiReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetVertxGen(j_nullableTCK["methodWithNullableSetApiReturn(boolean)"](__args[0]), RefedInterface1) ;
    } else if (typeof __super_methodWithNullableSetApiReturn != 'undefined') {
      return __super_methodWithNullableSetApiReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetDataObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetDataObjectParam(java.util.Set)"](utils.convParamSetDataObject(__args[0], function(json) { return new TestDataObject(json); })) ;
    } else if (typeof __super_methodWithNonNullableSetDataObjectParam != 'undefined') {
      return __super_methodWithNonNullableSetDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableSetDataObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetDataObjectParam(boolean,java.util.Set)"](__args[0], utils.convParamSetDataObject(__args[1], function(json) { return new TestDataObject(json); }));
    } else if (typeof __super_methodWithNullableSetDataObjectParam != 'undefined') {
      return __super_methodWithNullableSetDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetDataObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetDataObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithNullableSetDataObjectHandler != 'undefined') {
      return __super_methodWithNullableSetDataObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetDataObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetDataObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetDataObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetDataObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableSetDataObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetDataObject(j_nullableTCK["methodWithNullableSetDataObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetDataObjectReturn != 'undefined') {
      return __super_methodWithNullableSetDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetEnumParam(java.util.Set)"](utils.convParamSetEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); })) ;
    } else if (typeof __super_methodWithNonNullableSetEnumParam != 'undefined') {
      return __super_methodWithNonNullableSetEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableSetEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetEnumParam(boolean,java.util.Set)"](__args[0], utils.convParamSetEnum(__args[1], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }));
    } else if (typeof __super_methodWithNullableSetEnumParam != 'undefined') {
      return __super_methodWithNullableSetEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableSetEnumHandler != 'undefined') {
      return __super_methodWithNullableSetEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableSetEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithNullableSetEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetEnumReturn != 'undefined') {
      return __super_methodWithNullableSetEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableSetGenEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      return j_nullableTCK["methodWithNonNullableSetGenEnumParam(java.util.Set)"](utils.convParamSetEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); })) ;
    } else if (typeof __super_methodWithNonNullableSetGenEnumParam != 'undefined') {
      return __super_methodWithNonNullableSetGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Array.<Object>} 
   */
  this.methodWithNullableSetGenEnumParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object' && (__args[1] instanceof Array || __args[1] == null)) {
      j_nullableTCK["methodWithNullableSetGenEnumParam(boolean,java.util.Set)"](__args[0], utils.convParamSetEnum(__args[1], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); }));
    } else if (typeof __super_methodWithNullableSetGenEnumParam != 'undefined') {
      return __super_methodWithNullableSetGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetGenEnumHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetGenEnumHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithNullableSetGenEnumHandler != 'undefined') {
      return __super_methodWithNullableSetGenEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableSetGenEnumHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableSetGenEnumHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableSetGenEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableSetGenEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Array.<Object>}
   */
  this.methodWithNullableSetGenEnumReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithNullableSetGenEnumReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableSetGenEnumReturn != 'undefined') {
      return __super_methodWithNullableSetGenEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapByteParam(java.util.Map)"](utils.convParamMapByte(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapByteParam != 'undefined') {
      return __super_methodWithNonNullableMapByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapByteParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapByteParam(boolean,java.util.Map)"](__args[0], utils.convParamMapByte(__args[1]));
    } else if (typeof __super_methodWithNullableMapByteParam != 'undefined') {
      return __super_methodWithNullableMapByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapByteHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapByteHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapByteHandler != 'undefined') {
      return __super_methodWithNullableMapByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapByteHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapByteHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapByteReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapByteReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapByteReturn != 'undefined') {
      return __super_methodWithNullableMapByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapShortParam(java.util.Map)"](utils.convParamMapShort(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapShortParam != 'undefined') {
      return __super_methodWithNonNullableMapShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapShortParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapShortParam(boolean,java.util.Map)"](__args[0], utils.convParamMapShort(__args[1]));
    } else if (typeof __super_methodWithNullableMapShortParam != 'undefined') {
      return __super_methodWithNullableMapShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapShortHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapShortHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapShortHandler != 'undefined') {
      return __super_methodWithNullableMapShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapShortHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapShortHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapShortReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapShortReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapShortReturn != 'undefined') {
      return __super_methodWithNullableMapShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapIntegerParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapIntegerParam != 'undefined') {
      return __super_methodWithNonNullableMapIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapIntegerParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapIntegerParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapIntegerParam != 'undefined') {
      return __super_methodWithNullableMapIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapIntegerHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapIntegerHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapIntegerHandler != 'undefined') {
      return __super_methodWithNullableMapIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapIntegerHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapIntegerHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapIntegerReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapIntegerReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapIntegerReturn != 'undefined') {
      return __super_methodWithNullableMapIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapLongParam(java.util.Map)"](utils.convParamMapLong(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapLongParam != 'undefined') {
      return __super_methodWithNonNullableMapLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapLongParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapLongParam(boolean,java.util.Map)"](__args[0], utils.convParamMapLong(__args[1]));
    } else if (typeof __super_methodWithNullableMapLongParam != 'undefined') {
      return __super_methodWithNullableMapLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapLongHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapLongHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapLongHandler != 'undefined') {
      return __super_methodWithNullableMapLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapLongHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapLongHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapLongReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapLongReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapLongReturn != 'undefined') {
      return __super_methodWithNullableMapLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapFloatParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapFloatParam != 'undefined') {
      return __super_methodWithNonNullableMapFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapFloatParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapFloatParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapFloatParam != 'undefined') {
      return __super_methodWithNullableMapFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapFloatHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapFloatHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapFloatHandler != 'undefined') {
      return __super_methodWithNullableMapFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapFloatHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapFloatHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapFloatReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapFloatReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapFloatReturn != 'undefined') {
      return __super_methodWithNullableMapFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapDoubleParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapDoubleParam != 'undefined') {
      return __super_methodWithNonNullableMapDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, number>} 
   */
  this.methodWithNullableMapDoubleParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapDoubleParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapDoubleParam != 'undefined') {
      return __super_methodWithNullableMapDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapDoubleHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapDoubleHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapDoubleHandler != 'undefined') {
      return __super_methodWithNullableMapDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapDoubleHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapDoubleHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, number>}
   */
  this.methodWithNullableMapDoubleReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapDoubleReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapDoubleReturn != 'undefined') {
      return __super_methodWithNullableMapDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, boolean>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapBooleanParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapBooleanParam != 'undefined') {
      return __super_methodWithNonNullableMapBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, boolean>} 
   */
  this.methodWithNullableMapBooleanParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapBooleanParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapBooleanParam != 'undefined') {
      return __super_methodWithNullableMapBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapBooleanHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapBooleanHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapBooleanHandler != 'undefined') {
      return __super_methodWithNullableMapBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapBooleanHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapBooleanHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, boolean>}
   */
  this.methodWithNullableMapBooleanReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapBooleanReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapBooleanReturn != 'undefined') {
      return __super_methodWithNullableMapBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, string>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapStringParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapStringParam != 'undefined') {
      return __super_methodWithNonNullableMapStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, string>} 
   */
  this.methodWithNullableMapStringParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapStringParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapStringParam != 'undefined') {
      return __super_methodWithNullableMapStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapStringHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapStringHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapStringHandler != 'undefined') {
      return __super_methodWithNullableMapStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapStringHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapStringHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, string>}
   */
  this.methodWithNullableMapStringReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapStringReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapStringReturn != 'undefined') {
      return __super_methodWithNullableMapStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, string>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapCharParam(java.util.Map)"](__args[0]) ;
    } else if (typeof __super_methodWithNonNullableMapCharParam != 'undefined') {
      return __super_methodWithNonNullableMapCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, string>} 
   */
  this.methodWithNullableMapCharParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapCharParam(boolean,java.util.Map)"](__args[0], __args[1]);
    } else if (typeof __super_methodWithNullableMapCharParam != 'undefined') {
      return __super_methodWithNullableMapCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapCharHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapCharHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapCharHandler != 'undefined') {
      return __super_methodWithNullableMapCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapCharHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapCharHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, string>}
   */
  this.methodWithNullableMapCharReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapCharReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapCharReturn != 'undefined') {
      return __super_methodWithNullableMapCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, Object>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapJsonObjectParam(java.util.Map)"](utils.convParamMapJsonObject(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapJsonObjectParam != 'undefined') {
      return __super_methodWithNonNullableMapJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, Object>} 
   */
  this.methodWithNullableMapJsonObjectParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapJsonObjectParam(boolean,java.util.Map)"](__args[0], utils.convParamMapJsonObject(__args[1]));
    } else if (typeof __super_methodWithNullableMapJsonObjectParam != 'undefined') {
      return __super_methodWithNullableMapJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapJsonObjectHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapJsonObjectHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapJsonObjectHandler != 'undefined') {
      return __super_methodWithNullableMapJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapJsonObjectHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapJsonObjectHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, Object>}
   */
  this.methodWithNullableMapJsonObjectReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapJsonObjectReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapJsonObjectReturn != 'undefined') {
      return __super_methodWithNullableMapJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, Array>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapJsonArrayParam(java.util.Map)"](utils.convParamMapJsonArray(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapJsonArrayParam != 'undefined') {
      return __super_methodWithNonNullableMapJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, Array>} 
   */
  this.methodWithNullableMapJsonArrayParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapJsonArrayParam(boolean,java.util.Map)"](__args[0], utils.convParamMapJsonArray(__args[1]));
    } else if (typeof __super_methodWithNullableMapJsonArrayParam != 'undefined') {
      return __super_methodWithNullableMapJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapJsonArrayHandler =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapJsonArrayHandler(boolean,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithNullableMapJsonArrayHandler != 'undefined') {
      return __super_methodWithNullableMapJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableMapJsonArrayHandlerAsyncResult =  function(notNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'function') {
      j_nullableTCK["methodWithNullableMapJsonArrayHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnMap(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableMapJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableMapJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param notNull {boolean} 
   @return {Object.<string, Array>}
   */
  this.methodWithNullableMapJsonArrayReturn =  function(notNull) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] ==='boolean') {
      return utils.convReturnMap(j_nullableTCK["methodWithNullableMapJsonArrayReturn(boolean)"](__args[0])) ;
    } else if (typeof __super_methodWithNullableMapJsonArrayReturn != 'undefined') {
      return __super_methodWithNullableMapJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, RefedInterface1>} 
   @return {boolean}
   */
  this.methodWithNonNullableMapApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      return j_nullableTCK["methodWithNonNullableMapApiParam(java.util.Map)"](utils.convParamMapVertxGen(__args[0])) ;
    } else if (typeof __super_methodWithNonNullableMapApiParam != 'undefined') {
      return __super_methodWithNonNullableMapApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param param {Object.<string, RefedInterface1>} 
   */
  this.methodWithNullableMapApiParam =  function(expectNull, param) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && typeof __args[1] === 'object') {
      j_nullableTCK["methodWithNullableMapApiParam(boolean,java.util.Map)"](__args[0], utils.convParamMapVertxGen(__args[1]));
    } else if (typeof __super_methodWithNullableMapApiParam != 'undefined') {
      return __super_methodWithNullableMapApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableByteParam(java.util.List)"](utils.convParamListByte(__args[0]));
    } else if (typeof __super_methodWithListNullableByteParam != 'undefined') {
      return __super_methodWithListNullableByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableByteHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableByteHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableByteHandler != 'undefined') {
      return __super_methodWithListNullableByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableByteHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableByteHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableByteReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableByteReturn()"]() ;
    } else if (typeof __super_methodWithListNullableByteReturn != 'undefined') {
      return __super_methodWithListNullableByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableShortParam(java.util.List)"](utils.convParamListShort(__args[0]));
    } else if (typeof __super_methodWithListNullableShortParam != 'undefined') {
      return __super_methodWithListNullableShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableShortHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableShortHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableShortHandler != 'undefined') {
      return __super_methodWithListNullableShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableShortHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableShortHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableShortReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableShortReturn()"]() ;
    } else if (typeof __super_methodWithListNullableShortReturn != 'undefined') {
      return __super_methodWithListNullableShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableIntegerParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableIntegerParam != 'undefined') {
      return __super_methodWithListNullableIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableIntegerHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableIntegerHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableIntegerHandler != 'undefined') {
      return __super_methodWithListNullableIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableIntegerHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableIntegerHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableIntegerReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableIntegerReturn()"]() ;
    } else if (typeof __super_methodWithListNullableIntegerReturn != 'undefined') {
      return __super_methodWithListNullableIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableLongParam(java.util.List)"](utils.convParamListLong(__args[0]));
    } else if (typeof __super_methodWithListNullableLongParam != 'undefined') {
      return __super_methodWithListNullableLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableLongHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableLongHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetLong(jVal));
      });
    } else if (typeof __super_methodWithListNullableLongHandler != 'undefined') {
      return __super_methodWithListNullableLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableLongHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableLongHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetLong(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableLongReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetLong(j_nullableTCK["methodWithListNullableLongReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableLongReturn != 'undefined') {
      return __super_methodWithListNullableLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<boolean>} 
   */
  this.methodWithListNullableBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableBooleanParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableBooleanParam != 'undefined') {
      return __super_methodWithListNullableBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableBooleanHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableBooleanHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableBooleanHandler != 'undefined') {
      return __super_methodWithListNullableBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableBooleanHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableBooleanHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<boolean>}
   */
  this.methodWithListNullableBooleanReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableBooleanReturn()"]() ;
    } else if (typeof __super_methodWithListNullableBooleanReturn != 'undefined') {
      return __super_methodWithListNullableBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableFloatParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableFloatParam != 'undefined') {
      return __super_methodWithListNullableFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableFloatHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableFloatHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableFloatHandler != 'undefined') {
      return __super_methodWithListNullableFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableFloatHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableFloatHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableFloatReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableFloatReturn()"]() ;
    } else if (typeof __super_methodWithListNullableFloatReturn != 'undefined') {
      return __super_methodWithListNullableFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithListNullableDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableDoubleParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableDoubleParam != 'undefined') {
      return __super_methodWithListNullableDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableDoubleHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableDoubleHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableDoubleHandler != 'undefined') {
      return __super_methodWithListNullableDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableDoubleHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableDoubleHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListNullableDoubleReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableDoubleReturn()"]() ;
    } else if (typeof __super_methodWithListNullableDoubleReturn != 'undefined') {
      return __super_methodWithListNullableDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   */
  this.methodWithListNullableStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableStringParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableStringParam != 'undefined') {
      return __super_methodWithListNullableStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableStringHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableStringHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableStringHandler != 'undefined') {
      return __super_methodWithListNullableStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableStringHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableStringHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithListNullableStringReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableStringReturn()"]() ;
    } else if (typeof __super_methodWithListNullableStringReturn != 'undefined') {
      return __super_methodWithListNullableStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   */
  this.methodWithListNullableCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableCharParam(java.util.List)"](utils.convParamListBasicOther(__args[0]));
    } else if (typeof __super_methodWithListNullableCharParam != 'undefined') {
      return __super_methodWithListNullableCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableCharHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableCharHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      });
    } else if (typeof __super_methodWithListNullableCharHandler != 'undefined') {
      return __super_methodWithListNullableCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableCharHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableCharHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithListNullableCharReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_nullableTCK["methodWithListNullableCharReturn()"]() ;
    } else if (typeof __super_methodWithListNullableCharReturn != 'undefined') {
      return __super_methodWithListNullableCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithListNullableJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableJsonObjectParam(java.util.List)"](utils.convParamListJsonObject(__args[0]));
    } else if (typeof __super_methodWithListNullableJsonObjectParam != 'undefined') {
      return __super_methodWithListNullableJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableJsonObjectHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableJsonObjectHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithListNullableJsonObjectHandler != 'undefined') {
      return __super_methodWithListNullableJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableJsonObjectHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListNullableJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithListNullableJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableJsonObjectReturn != 'undefined') {
      return __super_methodWithListNullableJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Array>} 
   */
  this.methodWithListNullableJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableJsonArrayParam(java.util.List)"](utils.convParamListJsonArray(__args[0]));
    } else if (typeof __super_methodWithListNullableJsonArrayParam != 'undefined') {
      return __super_methodWithListNullableJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableJsonArrayHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableJsonArrayHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithListNullableJsonArrayHandler != 'undefined') {
      return __super_methodWithListNullableJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableJsonArrayHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithListNullableJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithListNullableJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableJsonArrayReturn != 'undefined') {
      return __super_methodWithListNullableJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<RefedInterface1>} 
   */
  this.methodWithListNullableApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableApiParam(java.util.List)"](utils.convParamListVertxGen(__args[0]));
    } else if (typeof __super_methodWithListNullableApiParam != 'undefined') {
      return __super_methodWithListNullableApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableApiHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableApiHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithListNullableApiHandler != 'undefined') {
      return __super_methodWithListNullableApiHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableApiHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableApiHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableApiHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableApiHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<RefedInterface1>}
   */
  this.methodWithListNullableApiReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_nullableTCK["methodWithListNullableApiReturn()"](), RefedInterface1) ;
    } else if (typeof __super_methodWithListNullableApiReturn != 'undefined') {
      return __super_methodWithListNullableApiReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithListNullableDataObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableDataObjectParam(java.util.List)"](utils.convParamListDataObject(__args[0], function(json) { return new TestDataObject(json); }));
    } else if (typeof __super_methodWithListNullableDataObjectParam != 'undefined') {
      return __super_methodWithListNullableDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableDataObjectHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableDataObjectHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithListNullableDataObjectHandler != 'undefined') {
      return __super_methodWithListNullableDataObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableDataObjectHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableDataObjectHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableDataObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableDataObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListNullableDataObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetDataObject(j_nullableTCK["methodWithListNullableDataObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableDataObjectReturn != 'undefined') {
      return __super_methodWithListNullableDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithListNullableEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableEnumParam(java.util.List)"](utils.convParamListEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }));
    } else if (typeof __super_methodWithListNullableEnumParam != 'undefined') {
      return __super_methodWithListNullableEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableEnumHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableEnumHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithListNullableEnumHandler != 'undefined') {
      return __super_methodWithListNullableEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableEnumHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableEnumHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListNullableEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithListNullableEnumReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableEnumReturn != 'undefined') {
      return __super_methodWithListNullableEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithListNullableGenEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithListNullableGenEnumParam(java.util.List)"](utils.convParamListEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); }));
    } else if (typeof __super_methodWithListNullableGenEnumParam != 'undefined') {
      return __super_methodWithListNullableGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableGenEnumHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableGenEnumHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithListNullableGenEnumHandler != 'undefined') {
      return __super_methodWithListNullableGenEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithListNullableGenEnumHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithListNullableGenEnumHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithListNullableGenEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithListNullableGenEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListNullableGenEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithListNullableGenEnumReturn()"]()) ;
    } else if (typeof __super_methodWithListNullableGenEnumReturn != 'undefined') {
      return __super_methodWithListNullableGenEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableByteParam(java.util.Set)"](utils.convParamSetByte(__args[0]));
    } else if (typeof __super_methodWithSetNullableByteParam != 'undefined') {
      return __super_methodWithSetNullableByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableByteHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableByteHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableByteHandler != 'undefined') {
      return __super_methodWithSetNullableByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableByteHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableByteHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableByteReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableByteReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableByteReturn != 'undefined') {
      return __super_methodWithSetNullableByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableShortParam(java.util.Set)"](utils.convParamSetShort(__args[0]));
    } else if (typeof __super_methodWithSetNullableShortParam != 'undefined') {
      return __super_methodWithSetNullableShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableShortHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableShortHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableShortHandler != 'undefined') {
      return __super_methodWithSetNullableShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableShortHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableShortHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableShortReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableShortReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableShortReturn != 'undefined') {
      return __super_methodWithSetNullableShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableIntegerParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableIntegerParam != 'undefined') {
      return __super_methodWithSetNullableIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableIntegerHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableIntegerHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableIntegerHandler != 'undefined') {
      return __super_methodWithSetNullableIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableIntegerHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableIntegerHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableIntegerReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableIntegerReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableIntegerReturn != 'undefined') {
      return __super_methodWithSetNullableIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableLongParam(java.util.Set)"](utils.convParamSetLong(__args[0]));
    } else if (typeof __super_methodWithSetNullableLongParam != 'undefined') {
      return __super_methodWithSetNullableLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableLongHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableLongHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetLong(jVal));
      });
    } else if (typeof __super_methodWithSetNullableLongHandler != 'undefined') {
      return __super_methodWithSetNullableLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableLongHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableLongHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetLong(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableLongReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetLong(j_nullableTCK["methodWithSetNullableLongReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableLongReturn != 'undefined') {
      return __super_methodWithSetNullableLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<boolean>} 
   */
  this.methodWithSetNullableBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableBooleanParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableBooleanParam != 'undefined') {
      return __super_methodWithSetNullableBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableBooleanHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableBooleanHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableBooleanHandler != 'undefined') {
      return __super_methodWithSetNullableBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableBooleanHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableBooleanHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<boolean>}
   */
  this.methodWithSetNullableBooleanReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableBooleanReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableBooleanReturn != 'undefined') {
      return __super_methodWithSetNullableBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableFloatParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableFloatParam != 'undefined') {
      return __super_methodWithSetNullableFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableFloatHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableFloatHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableFloatHandler != 'undefined') {
      return __super_methodWithSetNullableFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableFloatHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableFloatHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableFloatReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableFloatReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableFloatReturn != 'undefined') {
      return __super_methodWithSetNullableFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<number>} 
   */
  this.methodWithSetNullableDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableDoubleParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableDoubleParam != 'undefined') {
      return __super_methodWithSetNullableDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableDoubleHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableDoubleHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableDoubleHandler != 'undefined') {
      return __super_methodWithSetNullableDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableDoubleHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableDoubleHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetNullableDoubleReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableDoubleReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableDoubleReturn != 'undefined') {
      return __super_methodWithSetNullableDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   */
  this.methodWithSetNullableStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableStringParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableStringParam != 'undefined') {
      return __super_methodWithSetNullableStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableStringHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableStringHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableStringHandler != 'undefined') {
      return __super_methodWithSetNullableStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableStringHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableStringHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithSetNullableStringReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableStringReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableStringReturn != 'undefined') {
      return __super_methodWithSetNullableStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<string>} 
   */
  this.methodWithSetNullableCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableCharParam(java.util.Set)"](utils.convParamSetBasicOther(__args[0]));
    } else if (typeof __super_methodWithSetNullableCharParam != 'undefined') {
      return __super_methodWithSetNullableCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableCharHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableCharHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithSetNullableCharHandler != 'undefined') {
      return __super_methodWithSetNullableCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableCharHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableCharHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithSetNullableCharReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_nullableTCK["methodWithSetNullableCharReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableCharReturn != 'undefined') {
      return __super_methodWithSetNullableCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithSetNullableJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableJsonObjectParam(java.util.Set)"](utils.convParamSetJsonObject(__args[0]));
    } else if (typeof __super_methodWithSetNullableJsonObjectParam != 'undefined') {
      return __super_methodWithSetNullableJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableJsonObjectHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableJsonObjectHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithSetNullableJsonObjectHandler != 'undefined') {
      return __super_methodWithSetNullableJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableJsonObjectHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetNullableJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithSetNullableJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableJsonObjectReturn != 'undefined') {
      return __super_methodWithSetNullableJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Array>} 
   */
  this.methodWithSetNullableJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableJsonArrayParam(java.util.Set)"](utils.convParamSetJsonArray(__args[0]));
    } else if (typeof __super_methodWithSetNullableJsonArrayParam != 'undefined') {
      return __super_methodWithSetNullableJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableJsonArrayHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableJsonArrayHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithSetNullableJsonArrayHandler != 'undefined') {
      return __super_methodWithSetNullableJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableJsonArrayHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithSetNullableJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_nullableTCK["methodWithSetNullableJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableJsonArrayReturn != 'undefined') {
      return __super_methodWithSetNullableJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<RefedInterface1>} 
   */
  this.methodWithSetNullableApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableApiParam(java.util.Set)"](utils.convParamSetVertxGen(__args[0]));
    } else if (typeof __super_methodWithSetNullableApiParam != 'undefined') {
      return __super_methodWithSetNullableApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableApiHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableApiHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithSetNullableApiHandler != 'undefined') {
      return __super_methodWithSetNullableApiHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableApiHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableApiHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableApiHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableApiHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<RefedInterface1>}
   */
  this.methodWithSetNullableApiReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_nullableTCK["methodWithSetNullableApiReturn()"](), RefedInterface1) ;
    } else if (typeof __super_methodWithSetNullableApiReturn != 'undefined') {
      return __super_methodWithSetNullableApiReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithSetNullableDataObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableDataObjectParam(java.util.Set)"](utils.convParamSetDataObject(__args[0], function(json) { return new TestDataObject(json); }));
    } else if (typeof __super_methodWithSetNullableDataObjectParam != 'undefined') {
      return __super_methodWithSetNullableDataObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableDataObjectHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableDataObjectHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithSetNullableDataObjectHandler != 'undefined') {
      return __super_methodWithSetNullableDataObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableDataObjectHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableDataObjectHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableDataObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableDataObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetNullableDataObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetDataObject(j_nullableTCK["methodWithSetNullableDataObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableDataObjectReturn != 'undefined') {
      return __super_methodWithSetNullableDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithSetNullableEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableEnumParam(java.util.Set)"](utils.convParamSetEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }));
    } else if (typeof __super_methodWithSetNullableEnumParam != 'undefined') {
      return __super_methodWithSetNullableEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableEnumHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableEnumHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithSetNullableEnumHandler != 'undefined') {
      return __super_methodWithSetNullableEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableEnumHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableEnumHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetNullableEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithSetNullableEnumReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableEnumReturn != 'undefined') {
      return __super_methodWithSetNullableEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Array.<Object>} 
   */
  this.methodWithSetNullableGenEnumParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0] instanceof Array) {
      j_nullableTCK["methodWithSetNullableGenEnumParam(java.util.Set)"](utils.convParamSetEnum(__args[0], function(val) { return Packages.io.vertx.codegen.testmodel.TestGenEnum.valueOf(val); }));
    } else if (typeof __super_methodWithSetNullableGenEnumParam != 'undefined') {
      return __super_methodWithSetNullableGenEnumParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableGenEnumHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableGenEnumHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithSetNullableGenEnumHandler != 'undefined') {
      return __super_methodWithSetNullableGenEnumHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithSetNullableGenEnumHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithSetNullableGenEnumHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithSetNullableGenEnumHandlerAsyncResult != 'undefined') {
      return __super_methodWithSetNullableGenEnumHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetNullableGenEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_nullableTCK["methodWithSetNullableGenEnumReturn()"]()) ;
    } else if (typeof __super_methodWithSetNullableGenEnumReturn != 'undefined') {
      return __super_methodWithSetNullableGenEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableByteParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableByteParam(java.util.Map)"](utils.convParamMapByte(__args[0]));
    } else if (typeof __super_methodWithMapNullableByteParam != 'undefined') {
      return __super_methodWithMapNullableByteParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableByteHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableByteHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableByteHandler != 'undefined') {
      return __super_methodWithMapNullableByteHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableByteHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableByteHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableByteHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableByteHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableByteReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableByteReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableByteReturn != 'undefined') {
      return __super_methodWithMapNullableByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableShortParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableShortParam(java.util.Map)"](utils.convParamMapShort(__args[0]));
    } else if (typeof __super_methodWithMapNullableShortParam != 'undefined') {
      return __super_methodWithMapNullableShortParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableShortHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableShortHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableShortHandler != 'undefined') {
      return __super_methodWithMapNullableShortHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableShortHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableShortHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableShortHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableShortHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableShortReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableShortReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableShortReturn != 'undefined') {
      return __super_methodWithMapNullableShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableIntegerParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableIntegerParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableIntegerParam != 'undefined') {
      return __super_methodWithMapNullableIntegerParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableIntegerHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableIntegerHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableIntegerHandler != 'undefined') {
      return __super_methodWithMapNullableIntegerHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableIntegerHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableIntegerHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableIntegerHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableIntegerHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableIntegerReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableIntegerReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableIntegerReturn != 'undefined') {
      return __super_methodWithMapNullableIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableLongParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableLongParam(java.util.Map)"](utils.convParamMapLong(__args[0]));
    } else if (typeof __super_methodWithMapNullableLongParam != 'undefined') {
      return __super_methodWithMapNullableLongParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableLongHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableLongHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableLongHandler != 'undefined') {
      return __super_methodWithMapNullableLongHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableLongHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableLongHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableLongHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableLongHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableLongReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableLongReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableLongReturn != 'undefined') {
      return __super_methodWithMapNullableLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, boolean>} 
   */
  this.methodWithMapNullableBooleanParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableBooleanParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableBooleanParam != 'undefined') {
      return __super_methodWithMapNullableBooleanParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableBooleanHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableBooleanHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableBooleanHandler != 'undefined') {
      return __super_methodWithMapNullableBooleanHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableBooleanHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableBooleanHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableBooleanHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableBooleanHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, boolean>}
   */
  this.methodWithMapNullableBooleanReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableBooleanReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableBooleanReturn != 'undefined') {
      return __super_methodWithMapNullableBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableFloatParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableFloatParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableFloatParam != 'undefined') {
      return __super_methodWithMapNullableFloatParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableFloatHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableFloatHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableFloatHandler != 'undefined') {
      return __super_methodWithMapNullableFloatHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableFloatHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableFloatHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableFloatHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableFloatHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableFloatReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableFloatReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableFloatReturn != 'undefined') {
      return __super_methodWithMapNullableFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, number>} 
   */
  this.methodWithMapNullableDoubleParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableDoubleParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableDoubleParam != 'undefined') {
      return __super_methodWithMapNullableDoubleParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableDoubleHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableDoubleHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableDoubleHandler != 'undefined') {
      return __super_methodWithMapNullableDoubleHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableDoubleHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableDoubleHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableDoubleHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableDoubleHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, number>}
   */
  this.methodWithMapNullableDoubleReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableDoubleReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableDoubleReturn != 'undefined') {
      return __super_methodWithMapNullableDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, string>} 
   */
  this.methodWithMapNullableStringParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableStringParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableStringParam != 'undefined') {
      return __super_methodWithMapNullableStringParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableStringHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableStringHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableStringHandler != 'undefined') {
      return __super_methodWithMapNullableStringHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableStringHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableStringHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableStringHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableStringHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, string>}
   */
  this.methodWithMapNullableStringReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableStringReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableStringReturn != 'undefined') {
      return __super_methodWithMapNullableStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, string>} 
   */
  this.methodWithMapNullableCharParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableCharParam(java.util.Map)"](__args[0]);
    } else if (typeof __super_methodWithMapNullableCharParam != 'undefined') {
      return __super_methodWithMapNullableCharParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableCharHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableCharHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableCharHandler != 'undefined') {
      return __super_methodWithMapNullableCharHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableCharHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableCharHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableCharHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableCharHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, string>}
   */
  this.methodWithMapNullableCharReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableCharReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableCharReturn != 'undefined') {
      return __super_methodWithMapNullableCharReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, Object>} 
   */
  this.methodWithMapNullableJsonObjectParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableJsonObjectParam(java.util.Map)"](utils.convParamMapJsonObject(__args[0]));
    } else if (typeof __super_methodWithMapNullableJsonObjectParam != 'undefined') {
      return __super_methodWithMapNullableJsonObjectParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableJsonObjectHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableJsonObjectHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableJsonObjectHandler != 'undefined') {
      return __super_methodWithMapNullableJsonObjectHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableJsonObjectHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableJsonObjectHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableJsonObjectHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableJsonObjectHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, Object>}
   */
  this.methodWithMapNullableJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableJsonObjectReturn != 'undefined') {
      return __super_methodWithMapNullableJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, Array>} 
   */
  this.methodWithMapNullableJsonArrayParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableJsonArrayParam(java.util.Map)"](utils.convParamMapJsonArray(__args[0]));
    } else if (typeof __super_methodWithMapNullableJsonArrayParam != 'undefined') {
      return __super_methodWithMapNullableJsonArrayParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableJsonArrayHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableJsonArrayHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnMap(jVal));
      });
    } else if (typeof __super_methodWithMapNullableJsonArrayHandler != 'undefined') {
      return __super_methodWithMapNullableJsonArrayHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithMapNullableJsonArrayHandlerAsyncResult =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_nullableTCK["methodWithMapNullableJsonArrayHandlerAsyncResult(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnMap(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithMapNullableJsonArrayHandlerAsyncResult != 'undefined') {
      return __super_methodWithMapNullableJsonArrayHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Object.<string, Array>}
   */
  this.methodWithMapNullableJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnMap(j_nullableTCK["methodWithMapNullableJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithMapNullableJsonArrayReturn != 'undefined') {
      return __super_methodWithMapNullableJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param param {Object.<string, RefedInterface1>} 
   */
  this.methodWithMapNullableApiParam =  function(param) {
    var __args = arguments;
    if (__args.length === 1 && (typeof __args[0] === 'object' && __args[0] != null)) {
      j_nullableTCK["methodWithMapNullableApiParam(java.util.Map)"](utils.convParamMapVertxGen(__args[0]));
    } else if (typeof __super_methodWithMapNullableApiParam != 'undefined') {
      return __super_methodWithMapNullableApiParam.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableHandler =  function(expectNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] === 'function' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableHandler(boolean,io.vertx.core.Handler)"](__args[0], __args[1] == null ? null : function(jVal) {
        __args[1](jVal);
      });
    } else if (typeof __super_methodWithNullableHandler != 'undefined') {
      return __super_methodWithNullableHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param expectNull {boolean} 
   @param handler {function} 
   */
  this.methodWithNullableHandlerAsyncResult =  function(expectNull, handler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='boolean' && (typeof __args[1] === 'function' || __args[1] == null)) {
      j_nullableTCK["methodWithNullableHandlerAsyncResult(boolean,io.vertx.core.Handler)"](__args[0], __args[1] == null ? null : function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithNullableHandlerAsyncResult != 'undefined') {
      return __super_methodWithNullableHandlerAsyncResult.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_nullableTCK;
};

NullableTCK._jclass = utils.getJavaClass("io.vertx.codegen.testmodel.NullableTCK");
NullableTCK._jtype = {accept: function(obj) {
    return NullableTCK._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(NullableTCK.prototype, {});
    NullableTCK.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
NullableTCK._create = function(jdel) {var obj = Object.create(NullableTCK.prototype, {});
  NullableTCK.apply(obj, arguments);
  return obj;
}
module.exports = NullableTCK;