/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module extra-js/interface_with_method */
var utils = require('vertx-js/util/utils');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JInterfaceWithMethod = Java.type('io.vertx.test.codegen.InterfaceWithMethod');

/**

 @class
*/
var InterfaceWithMethod = function(j_val) {

  var j_interfaceWithMethod = j_val;
  var that = this;

  var __super_meth1 = this.meth1;
  var __super_meth1 = this.meth1;
  var __super_meth2 = this.meth2;
  var __super_meth2 = this.meth2;
  var __super_static_meth1 = this.static_meth1;
  var __super_static_meth1 = this.static_meth1;
  var __super_static_meth2 = this.static_meth2;
  var __super_static_meth2 = this.static_meth2;
  /**

   @public
   @param arg {string} 
   @return {string}
   */
  this.meth1 =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_interfaceWithMethod["meth1()"]() ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_interfaceWithMethod["meth1(java.lang.String)"](__args[0]) ;
    } else if (typeof __super_meth1 != 'undefined') {
      return __super_meth1.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg {string} 
   @return {string}
   */
  this.meth2 =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_interfaceWithMethod["meth2()"]() ;
    } else if (__args.length === 1 && typeof __args[0] === 'string') {
      return j_interfaceWithMethod["meth2(java.lang.String)"](__args[0]) ;
    } else if (typeof __super_meth2 != 'undefined') {
      return __super_meth2.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_interfaceWithMethod;
};

InterfaceWithMethod._jclass = utils.getJavaClass("io.vertx.test.codegen.InterfaceWithMethod");
InterfaceWithMethod._jtype = {accept: function(obj) {
    return InterfaceWithMethod._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(InterfaceWithMethod.prototype, {});
    InterfaceWithMethod.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
InterfaceWithMethod._create = function(jdel) {var obj = Object.create(InterfaceWithMethod.prototype, {});
  InterfaceWithMethod.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:extra-js/interface_with_method
 @param arg {string} 
 @return {string}
 */
InterfaceWithMethod.static_meth1 =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return JInterfaceWithMethod["static_meth1()"]() ;
  } else if (__args.length === 1 && typeof __args[0] === 'string') {
    return JInterfaceWithMethod["static_meth1(java.lang.String)"](__args[0]) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**

 @memberof module:extra-js/interface_with_method
 @param arg {string} 
 @return {string}
 */
InterfaceWithMethod.static_meth2 =  function() {
  var __args = arguments;
  if (__args.length === 0) {
    return JInterfaceWithMethod["static_meth2()"]() ;
  } else if (__args.length === 1 && typeof __args[0] === 'string') {
    return JInterfaceWithMethod["static_meth2(java.lang.String)"](__args[0]) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = InterfaceWithMethod;