/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-web-client-js/error_converter */
var utils = require('vertx-js/util/utils');
var ResponsePredicateResult = require('vertx-web-client-js/response_predicate_result');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JErrorConverter = Java.type('io.vertx.ext.web.client.predicate.ErrorConverter');

/**

 @class
*/
var ErrorConverter = function(j_val) {

  var j_errorConverter = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_createFullBody = this.createFullBody;
  var __super_apply = this.apply;
  var __super_requiresBody = this.requiresBody;
  /**

   @public
   @param result {ResponsePredicateResult} 
   @return {todo}
   */
  this.apply =  function(result) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnThrowable(j_errorConverter["apply(io.vertx.ext.web.client.predicate.ResponsePredicateResult)"](__args[0]._jdel)) ;
    } else if (typeof __super_apply != 'undefined') {
      return __super_apply.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {boolean} <code>true</code> when the converter wants to process the request body.
   */
  this.requiresBody =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_errorConverter["requiresBody()"]() ;
    } else if (typeof __super_requiresBody != 'undefined') {
      return __super_requiresBody.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_errorConverter;
};

ErrorConverter._jclass = utils.getJavaClass("io.vertx.ext.web.client.predicate.ErrorConverter");
ErrorConverter._jtype = {accept: function(obj) {
    return ErrorConverter._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ErrorConverter.prototype, {});
    ErrorConverter.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ErrorConverter._create = function(jdel) {var obj = Object.create(ErrorConverter.prototype, {});
  ErrorConverter.apply(obj, arguments);
  return obj;
}
/**
 Creates a full {@link ErrorConverter}, that will passed a predicate result with the response body.

 <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.

 @memberof module:vertx-web-client-js/error_converter
 @param converter {function} a function creating a Throwable from a {@link ResponsePredicateResult} 
 @return {ErrorConverter}
 */
ErrorConverter.create =  function(converter) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'function') {
    return utils.convReturnVertxGen(ErrorConverter, JErrorConverter["create(java.util.function.Function)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(ResponsePredicateResult, jVal));
      return utils.convParamThrowable(jRet);
    })) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Creates a full {@link ErrorConverter}, that will passed a predicate result with the response body.

 <p>The <code>converter</code> function will be invoked <em>after</em> the HTTP response body is received.

 @memberof module:vertx-web-client-js/error_converter
 @param converter {function} a function creating a Throwable from a {@link ResponsePredicateResult} 
 @return {ErrorConverter}
 */
ErrorConverter.createFullBody =  function(converter) {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'function') {
    return utils.convReturnVertxGen(ErrorConverter, JErrorConverter["createFullBody(java.util.function.Function)"](function(jVal) {
      var jRet = __args[0](utils.convReturnVertxGen(ResponsePredicateResult, jVal));
      return utils.convParamThrowable(jRet);
    })) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

ErrorConverter.DEFAULT_CONVERTER = utils.convReturnVertxGen(ErrorConverter, JErrorConverter.DEFAULT_CONVERTER);
module.exports = ErrorConverter;