/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-shell-js/term */
var utils = require('vertx-js/util/utils');
var Completion = require('vertx-shell-js/completion');
var SignalHandler = require('vertx-shell-js/signal_handler');
var Tty = require('vertx-shell-js/tty');
var Session = require('vertx-shell-js/session');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JTerm = Java.type('io.vertx.ext.shell.term.Term');

/**
 The terminal.

 @class
*/
var Term = function(j_val) {

  var j_term = j_val;
  var that = this;
  Tty.call(this, j_val);

  var __super_resizehandler = this.resizehandler;
  var __super_stdinHandler = this.stdinHandler;
  var __super_write = this.write;
  var __super_lastAccessedTime = this.lastAccessedTime;
  var __super_echo = this.echo;
  var __super_setSession = this.setSession;
  var __super_interruptHandler = this.interruptHandler;
  var __super_suspendHandler = this.suspendHandler;
  var __super_readline = this.readline;
  var __super_readline = this.readline;
  var __super_closeHandler = this.closeHandler;
  var __super_close = this.close;
  /**

   @public
   @param handler {function} 
   @return {Term}
   */
  this.resizehandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_term["resizehandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_resizehandler != 'undefined') {
      return __super_resizehandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Term}
   */
  this.stdinHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_term["stdinHandler(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      }) ;
      return that;
    } else if (typeof __super_stdinHandler != 'undefined') {
      return __super_stdinHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param data {string} 
   @return {Term}
   */
  this.write =  function(data) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_term["write(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_write != 'undefined') {
      return __super_write.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {number} the last time this term received input
   */
  this.lastAccessedTime =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_term["lastAccessedTime()"]() ;
    } else if (typeof __super_lastAccessedTime != 'undefined') {
      return __super_lastAccessedTime.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Echo some text in the terminal, escaped if necessary.<p/>

   @public
   @param text {string} the text to echo 
   @return {Term} a reference to this, so the API can be used fluently
   */
  this.echo =  function(text) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_term["echo(java.lang.String)"](__args[0]) ;
      return that;
    } else if (typeof __super_echo != 'undefined') {
      return __super_echo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Associate the term with a session.

   @public
   @param session {Session} the session to set 
   @return {Term} a reference to this, so the API can be used fluently
   */
  this.setSession =  function(session) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      return utils.convReturnVertxGen(Term, j_term["setSession(io.vertx.ext.shell.session.Session)"](__args[0]._jdel)) ;
    } else if (typeof __super_setSession != 'undefined') {
      return __super_setSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set an interrupt signal handler on the term.

   @public
   @param handler {SignalHandler} the interrupt handler 
   @return {Term} a reference to this, so the API can be used fluently
   */
  this.interruptHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_term["interruptHandler(io.vertx.ext.shell.term.SignalHandler)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_interruptHandler != 'undefined') {
      return __super_interruptHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a suspend signal handler on the term.

   @public
   @param handler {SignalHandler} the suspend handler 
   @return {Term} a reference to this, so the API can be used fluently
   */
  this.suspendHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
      j_term["suspendHandler(io.vertx.ext.shell.term.SignalHandler)"](__args[0]._jdel) ;
      return that;
    } else if (typeof __super_suspendHandler != 'undefined') {
      return __super_suspendHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Prompt the user a line of text, providing a completion handler to handle user's completion.

   @public
   @param prompt {string} the displayed prompt 
   @param lineHandler {function} the line handler called with the line 
   @param completionHandler {function} the completion handler 
   */
  this.readline =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_term["readline(java.lang.String,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      });
    } else if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'function' && typeof __args[2] === 'function') {
      j_term["readline(java.lang.String,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], function(jVal) {
        __args[1](jVal);
      }, function(jVal) {
        __args[2](utils.convReturnVertxGen(Completion, jVal));
      });
    } else if (typeof __super_readline != 'undefined') {
      return __super_readline.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set a handler that will be called when the terminal is closed.

   @public
   @param handler {function} the handler 
   @return {Term} a reference to this, so the API can be used fluently
   */
  this.closeHandler =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_term["closeHandler(io.vertx.core.Handler)"](__args[0]) ;
      return that;
    } else if (typeof __super_closeHandler != 'undefined') {
      return __super_closeHandler.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the connection to terminal.

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_term["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_term;
};

Term._jclass = utils.getJavaClass("io.vertx.ext.shell.term.Term");
Term._jtype = {accept: function(obj) {
    return Term._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(Term.prototype, {});
    Term.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
Term._create = function(jdel) {var obj = Object.create(Term.prototype, {});
  Term.apply(obj, arguments);
  return obj;
}
module.exports = Term;