/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-rabbitmq-js/rabbit_mq_client */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var RabbitMQConsumer = require('vertx-rabbitmq-js/rabbit_mq_consumer');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JRabbitMQClient = Java.type('io.vertx.rabbitmq.RabbitMQClient');
var RabbitMQOptions = Java.type('io.vertx.rabbitmq.RabbitMQOptions');
var QueueOptions = Java.type('io.vertx.rabbitmq.QueueOptions');

/**

 @class
*/
var RabbitMQClient = function(j_val) {

  var j_rabbitMQClient = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_basicAck = this.basicAck;
  var __super_basicNack = this.basicNack;
  var __super_basicGet = this.basicGet;
  var __super_basicConsume = this.basicConsume;
  var __super_basicConsume = this.basicConsume;
  var __super_basicConsume = this.basicConsume;
  var __super_basicCancel = this.basicCancel;
  var __super_basicCancel = this.basicCancel;
  var __super_basicConsumer = this.basicConsumer;
  var __super_basicConsumer = this.basicConsumer;
  var __super_basicPublish = this.basicPublish;
  var __super_confirmSelect = this.confirmSelect;
  var __super_waitForConfirms = this.waitForConfirms;
  var __super_waitForConfirms = this.waitForConfirms;
  var __super_basicQos = this.basicQos;
  var __super_basicQos = this.basicQos;
  var __super_basicQos = this.basicQos;
  var __super_exchangeDeclare = this.exchangeDeclare;
  var __super_exchangeDeclare = this.exchangeDeclare;
  var __super_exchangeDelete = this.exchangeDelete;
  var __super_exchangeBind = this.exchangeBind;
  var __super_exchangeUnbind = this.exchangeUnbind;
  var __super_queueDeclareAuto = this.queueDeclareAuto;
  var __super_queueDeclare = this.queueDeclare;
  var __super_queueDeclare = this.queueDeclare;
  var __super_queueDelete = this.queueDelete;
  var __super_queueDeleteIf = this.queueDeleteIf;
  var __super_queueBind = this.queueBind;
  var __super_messageCount = this.messageCount;
  var __super_start = this.start;
  var __super_stop = this.stop;
  var __super_isConnected = this.isConnected;
  var __super_isOpenChannel = this.isOpenChannel;
  /**
   Acknowledge one or several received messages. Supply the deliveryTag from the AMQP.Basic.GetOk or AMQP.Basic.Deliver
   method containing the received message being acknowledged.

   @public
   @param deliveryTag {number} 
   @param multiple {boolean} 
   @param resultHandler {function} 
   */
  this.basicAck =  function(deliveryTag, multiple, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] ==='boolean' && typeof __args[2] === 'function') {
      j_rabbitMQClient["basicAck(long,boolean,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (typeof __super_basicAck != 'undefined') {
      return __super_basicAck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Reject one or several received messages.

   @public
   @param deliveryTag {number} 
   @param multiple {boolean} 
   @param requeue {boolean} 
   @param resultHandler {function} 
   */
  this.basicNack =  function(deliveryTag, multiple, requeue, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] ==='number' && typeof __args[1] ==='boolean' && typeof __args[2] ==='boolean' && typeof __args[3] === 'function') {
      j_rabbitMQClient["basicNack(long,boolean,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_basicNack != 'undefined') {
      return __super_basicNack.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Retrieve a message from a queue using AMQP.Basic.Get

   @public
   @param queue {string} 
   @param autoAck {boolean} 
   @param resultHandler {function} 
   */
  this.basicGet =  function(queue, autoAck, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] === 'function') {
      j_rabbitMQClient["basicGet(java.lang.String,boolean,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnJson(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (typeof __super_basicGet != 'undefined') {
      return __super_basicGet.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Use {@link RabbitMQClient#basicConsumer} instead
   <p>
   Start a non-nolocal, non-exclusive consumer, with a server-generated consumerTag and error handler

   @public
   @param queue {string} 
   @param address {string} 
   @param autoAck {boolean} 
   @param resultHandler {function} 
   @param errorHandler {function} 
   */
  this.basicConsume =  function() {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_rabbitMQClient["basicConsume(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] ==='boolean' && typeof __args[3] === 'function') {
      j_rabbitMQClient["basicConsume(java.lang.String,java.lang.String,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] ==='boolean' && typeof __args[3] === 'function' && typeof __args[4] === 'function') {
      j_rabbitMQClient["basicConsume(java.lang.String,java.lang.String,boolean,io.vertx.core.Handler,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      }, function(jVal) {
        __args[4](utils.convReturnThrowable(jVal));
      });
    } else if (typeof __super_basicConsume != 'undefined') {
      return __super_basicConsume.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Instead of using this and {@link RabbitMQClient#basicConsume} method,
   {@link RabbitMQClient#basicConsumer} and {@link RabbitMQConsumer#cancel} instead
   <p>
   This method should be called when you want to cancel consumption from a queue,
   started by calling {@link RabbitMQClient#basicConsume}.

   @public
   @param consumerTag {string} 
   @param resultHandler {function} 
   */
  this.basicCancel =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'string') {
      j_rabbitMQClient["basicCancel(java.lang.String)"](__args[0]);
    } else if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_rabbitMQClient["basicCancel(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_basicCancel != 'undefined') {
      return __super_basicCancel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create a consumer with the given <code>options</code>.

   @public
   @param queue {string} the name of a queue 
   @param options {Object} options for queue 
   @param resultHandler {function} a handler through which you can find out the operation status; if the operation succeeds you can begin to receive messages through an instance of {@link RabbitMQConsumer} 
   */
  this.basicConsumer =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_rabbitMQClient["basicConsumer(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnVertxGen(RabbitMQConsumer, ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_rabbitMQClient["basicConsumer(java.lang.String,io.vertx.rabbitmq.QueueOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new QueueOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnVertxGen(RabbitMQConsumer, ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (typeof __super_basicConsumer != 'undefined') {
      return __super_basicConsumer.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Publish a message. Publishing to a non-existent exchange will result in a channel-level protocol exception,
   which closes the channel. Invocations of Channel#basicPublish will eventually block if a resource-driven alarm is in effect.

   @public
   @param exchange {string} 
   @param routingKey {string} 
   @param message {Object} 
   @param resultHandler {function} 
   */
  this.basicPublish =  function(exchange, routingKey, message, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_rabbitMQClient["basicPublish(java.lang.String,java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], __args[1], utils.convParamJsonObject(__args[2]), function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_basicPublish != 'undefined') {
      return __super_basicPublish.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Enables publisher acknowledgements on this channel. Can be called once during client initialisation. Calls to basicPublish()
   will have to be confirmed.

   @public
   @param resultHandler {function} 
   */
  this.confirmSelect =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_rabbitMQClient["confirmSelect(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_confirmSelect != 'undefined') {
      return __super_confirmSelect.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Wait until all messages published since the last call have been either ack'd or nack'd by the broker; or until timeout elapses. If the timeout expires a TimeoutException is thrown.

   @public
   @param timeout {number} 
   @param resultHandler {function} 
   */
  this.waitForConfirms =  function() {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_rabbitMQClient["waitForConfirms(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] === 'function') {
      j_rabbitMQClient["waitForConfirms(long,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_waitForConfirms != 'undefined') {
      return __super_waitForConfirms.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Request specific "quality of service" settings.

   These settings impose limits on the amount of data the server
   will deliver to consumers before requiring acknowledgements.
   Thus they provide a means of consumer-initiated flow control.

   @public
   @param prefetchSize {number} maximum amount of content (measured in octets) that the server will deliver, 0 if unlimited 
   @param prefetchCount {number} maximum number of messages that the server will deliver, 0 if unlimited 
   @param global {boolean} true if the settings should be applied to the entire channel rather than each consumer 
   @param resultHandler {function} handler called when operation is done with a result of the operation 
   */
  this.basicQos =  function() {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] ==='number' && typeof __args[1] === 'function') {
      j_rabbitMQClient["basicQos(int,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (__args.length === 3 && typeof __args[0] ==='number' && typeof __args[1] ==='boolean' && typeof __args[2] === 'function') {
      j_rabbitMQClient["basicQos(int,boolean,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      });
    } else if (__args.length === 4 && typeof __args[0] ==='number' && typeof __args[1] ==='number' && typeof __args[2] ==='boolean' && typeof __args[3] === 'function') {
      j_rabbitMQClient["basicQos(int,int,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_basicQos != 'undefined') {
      return __super_basicQos.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Declare an exchange with additional parameters such as dead lettering, an alternate exchange or TTL.

   @public
   @param exchange {string} 
   @param type {string} 
   @param durable {boolean} 
   @param autoDelete {boolean} 
   @param config {Object} 
   @param resultHandler {function} 
   */
  this.exchangeDeclare =  function() {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] ==='boolean' && typeof __args[3] ==='boolean' && typeof __args[4] === 'function') {
      j_rabbitMQClient["exchangeDeclare(java.lang.String,java.lang.String,boolean,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], __args[3], function(ar) {
        if (ar.succeeded()) {
          __args[4](null, null);
        } else {
          __args[4](null, ar.cause());
        }
      });
    } else if (__args.length === 6 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] ==='boolean' && typeof __args[3] ==='boolean' && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_rabbitMQClient["exchangeDeclare(java.lang.String,java.lang.String,boolean,boolean,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], __args[3], utils.convParamJsonObject(__args[4]), function(ar) {
        if (ar.succeeded()) {
          __args[5](null, null);
        } else {
          __args[5](null, ar.cause());
        }
      });
    } else if (typeof __super_exchangeDeclare != 'undefined') {
      return __super_exchangeDeclare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Delete an exchange, without regard for whether it is in use or not.

   @public
   @param exchange {string} 
   @param resultHandler {function} 
   */
  this.exchangeDelete =  function(exchange, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_rabbitMQClient["exchangeDelete(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_exchangeDelete != 'undefined') {
      return __super_exchangeDelete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Bind an exchange to an exchange.

   @public
   @param destination {string} 
   @param source {string} 
   @param routingKey {string} 
   @param resultHandler {function} 
   */
  this.exchangeBind =  function(destination, source, routingKey, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_rabbitMQClient["exchangeBind(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_exchangeBind != 'undefined') {
      return __super_exchangeBind.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Unbind an exchange from an exchange.

   @public
   @param destination {string} 
   @param source {string} 
   @param routingKey {string} 
   @param resultHandler {function} 
   */
  this.exchangeUnbind =  function(destination, source, routingKey, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_rabbitMQClient["exchangeUnbind(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_exchangeUnbind != 'undefined') {
      return __super_exchangeUnbind.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Actively declare a server-named exclusive, autodelete, non-durable queue.

   @public
   @param resultHandler {function} 
   */
  this.queueDeclareAuto =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_rabbitMQClient["queueDeclareAuto(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_queueDeclareAuto != 'undefined') {
      return __super_queueDeclareAuto.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Declare a queue with config options

   @public
   @param queue {string} 
   @param durable {boolean} 
   @param exclusive {boolean} 
   @param autoDelete {boolean} 
   @param config {Object} 
   @param resultHandler {function} 
   */
  this.queueDeclare =  function() {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] ==='boolean' && typeof __args[3] ==='boolean' && typeof __args[4] === 'function') {
      j_rabbitMQClient["queueDeclare(java.lang.String,boolean,boolean,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], __args[3], function(ar) {
        if (ar.succeeded()) {
          __args[4](utils.convReturnJson(ar.result()), null);
        } else {
          __args[4](null, ar.cause());
        }
      });
    } else if (__args.length === 6 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] ==='boolean' && typeof __args[3] ==='boolean' && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_rabbitMQClient["queueDeclare(java.lang.String,boolean,boolean,boolean,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], __args[3], utils.convParamJsonObject(__args[4]), function(ar) {
        if (ar.succeeded()) {
          __args[5](utils.convReturnJson(ar.result()), null);
        } else {
          __args[5](null, ar.cause());
        }
      });
    } else if (typeof __super_queueDeclare != 'undefined') {
      return __super_queueDeclare.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Delete a queue, without regard for whether it is in use or has messages on it

   @public
   @param queue {string} 
   @param resultHandler {function} 
   */
  this.queueDelete =  function(queue, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_rabbitMQClient["queueDelete(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnJson(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_queueDelete != 'undefined') {
      return __super_queueDelete.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Delete a queue

   @public
   @param queue {string} 
   @param ifUnused {boolean} 
   @param ifEmpty {boolean} 
   @param resultHandler {function} 
   */
  this.queueDeleteIf =  function(queue, ifUnused, ifEmpty, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] ==='boolean' && typeof __args[3] === 'function') {
      j_rabbitMQClient["queueDeleteIf(java.lang.String,boolean,boolean,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnJson(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_queueDeleteIf != 'undefined') {
      return __super_queueDeleteIf.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Bind a queue to an exchange

   @public
   @param queue {string} 
   @param exchange {string} 
   @param routingKey {string} 
   @param resultHandler {function} 
   */
  this.queueBind =  function(queue, exchange, routingKey, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_rabbitMQClient["queueBind(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      });
    } else if (typeof __super_queueBind != 'undefined') {
      return __super_queueBind.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the number of messages in a queue ready to be delivered.

   @public
   @param queue {string} 
   @param resultHandler {function} 
   */
  this.messageCount =  function(queue, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_rabbitMQClient["messageCount(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnLong(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_messageCount != 'undefined') {
      return __super_messageCount.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Start the rabbitMQ client. Create the connection and the chanel.

   @public
   @param resultHandler {function} 
   */
  this.start =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_rabbitMQClient["start(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_start != 'undefined') {
      return __super_start.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Stop the rabbitMQ client. Close the connection and its chanel.

   @public
   @param resultHandler {function} 
   */
  this.stop =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_rabbitMQClient["stop(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](null, null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_stop != 'undefined') {
      return __super_stop.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Check if a connection is open

   @public

   @return {boolean} true when the connection is open, false otherwise
   */
  this.isConnected =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_rabbitMQClient["isConnected()"]() ;
    } else if (typeof __super_isConnected != 'undefined') {
      return __super_isConnected.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Check if a channel is open

   @public

   @return {boolean} true when the connection is open, false otherwise
   */
  this.isOpenChannel =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_rabbitMQClient["isOpenChannel()"]() ;
    } else if (typeof __super_isOpenChannel != 'undefined') {
      return __super_isOpenChannel.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_rabbitMQClient;
};

RabbitMQClient._jclass = utils.getJavaClass("io.vertx.rabbitmq.RabbitMQClient");
RabbitMQClient._jtype = {accept: function(obj) {
    return RabbitMQClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(RabbitMQClient.prototype, {});
    RabbitMQClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
RabbitMQClient._create = function(jdel) {var obj = Object.create(RabbitMQClient.prototype, {});
  RabbitMQClient.apply(obj, arguments);
  return obj;
}
/**
 Create and return a client.

 @memberof module:vertx-rabbitmq-js/rabbit_mq_client
 @param vertx {Vertx} the vertx instance 
 @param config {Object} the client config 
 @return {RabbitMQClient} the client
 */
RabbitMQClient.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(RabbitMQClient, JRabbitMQClient["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(RabbitMQClient, JRabbitMQClient["create(io.vertx.core.Vertx,io.vertx.rabbitmq.RabbitMQOptions)"](__args[0]._jdel, __args[1]  != null ? new RabbitMQOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = RabbitMQClient;