/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-kafka-client-js/kafka_admin_client */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JKafkaAdminClient = Java.type('io.vertx.kafka.admin.KafkaAdminClient');
var NewTopic = Java.type('io.vertx.kafka.admin.NewTopic');
var ConsumerGroupListing = Java.type('io.vertx.kafka.admin.ConsumerGroupListing');

/**
 Vert.x Kafka Admin client implementation

 @class
*/
var KafkaAdminClient = function(j_val) {

  var j_kafkaAdminClient = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_listTopics = this.listTopics;
  var __super_createTopics = this.createTopics;
  var __super_deleteTopics = this.deleteTopics;
  var __super_listConsumerGroups = this.listConsumerGroups;
  /**
   List the topics available in the cluster with the default options.

   @public
   @param completionHandler {function} handler called on operation completed with the topics set 
   */
  this.listTopics =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_kafkaAdminClient["listTopics(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_listTopics != 'undefined') {
      return __super_listTopics.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Creates a batch of new Kafka topics

   @public
   @param topics {Array.<Object>} topics to create 
   @param completionHandler {function} handler called on operation completed 
   */
  this.createTopics =  function(topics, completionHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_kafkaAdminClient["createTopics(java.util.List,io.vertx.core.Handler)"](utils.convParamListDataObject(__args[0], function(json) { return new NewTopic(json); }), function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_createTopics != 'undefined') {
      return __super_createTopics.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Deletes a batch of Kafka topics

   @public
   @param topicNames {Array.<string>} the names of the topics to delete 
   @param completionHandler {function} handler called on operation completed 
   */
  this.deleteTopics =  function(topicNames, completionHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'function') {
      j_kafkaAdminClient["deleteTopics(java.util.List,io.vertx.core.Handler)"](utils.convParamListBasicOther(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      });
    } else if (typeof __super_deleteTopics != 'undefined') {
      return __super_deleteTopics.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the the consumer groups available in the cluster with the default options

   @public
   @param completionHandler {function} handler called on operation completed with the consumer groups ids 
   */
  this.listConsumerGroups =  function(completionHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_kafkaAdminClient["listConsumerGroups(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_listConsumerGroups != 'undefined') {
      return __super_listConsumerGroups.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_kafkaAdminClient;
};

KafkaAdminClient._jclass = utils.getJavaClass("io.vertx.kafka.admin.KafkaAdminClient");
KafkaAdminClient._jtype = {accept: function(obj) {
    return KafkaAdminClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(KafkaAdminClient.prototype, {});
    KafkaAdminClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
KafkaAdminClient._create = function(jdel) {var obj = Object.create(KafkaAdminClient.prototype, {});
  KafkaAdminClient.apply(obj, arguments);
  return obj;
}
/**
 Create a new KafkaAdminClient instance

 @memberof module:vertx-kafka-client-js/kafka_admin_client
 @param vertx {Vertx} Vert.x instance to use 
 @param config {Object.<string, string>} Kafka admin client configuration 
 @return {KafkaAdminClient} an instance of the KafkaAdminClient
 */
KafkaAdminClient.create =  function(vertx, config) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(KafkaAdminClient, JKafkaAdminClient["create(io.vertx.core.Vertx,java.util.Map)"](__args[0]._jdel, __args[1])) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = KafkaAdminClient;