/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-consul-js/consul_client */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JConsulClient = Java.type('io.vertx.ext.consul.ConsulClient');
var ServiceQueryOptions = Java.type('io.vertx.ext.consul.ServiceQueryOptions');
var PreparedQueryDefinition = Java.type('io.vertx.ext.consul.PreparedQueryDefinition');
var Event = Java.type('io.vertx.ext.consul.Event');
var EventListOptions = Java.type('io.vertx.ext.consul.EventListOptions');
var SessionList = Java.type('io.vertx.ext.consul.SessionList');
var MaintenanceOptions = Java.type('io.vertx.ext.consul.MaintenanceOptions');
var Check = Java.type('io.vertx.ext.consul.Check');
var ConsulClientOptions = Java.type('io.vertx.ext.consul.ConsulClientOptions');
var Service = Java.type('io.vertx.ext.consul.Service');
var CheckOptions = Java.type('io.vertx.ext.consul.CheckOptions');
var NodeQueryOptions = Java.type('io.vertx.ext.consul.NodeQueryOptions');
var ServiceEntryList = Java.type('io.vertx.ext.consul.ServiceEntryList');
var KeyValue = Java.type('io.vertx.ext.consul.KeyValue');
var ServiceOptions = Java.type('io.vertx.ext.consul.ServiceOptions');
var TxnRequest = Java.type('io.vertx.ext.consul.TxnRequest');
var ServiceList = Java.type('io.vertx.ext.consul.ServiceList');
var BlockingQueryOptions = Java.type('io.vertx.ext.consul.BlockingQueryOptions');
var PreparedQueryExecuteOptions = Java.type('io.vertx.ext.consul.PreparedQueryExecuteOptions');
var NodeList = Java.type('io.vertx.ext.consul.NodeList');
var CheckQueryOptions = Java.type('io.vertx.ext.consul.CheckQueryOptions');
var TxnResponse = Java.type('io.vertx.ext.consul.TxnResponse');
var EventList = Java.type('io.vertx.ext.consul.EventList');
var PreparedQueryExecuteResponse = Java.type('io.vertx.ext.consul.PreparedQueryExecuteResponse');
var CoordinateList = Java.type('io.vertx.ext.consul.CoordinateList');
var KeyValueOptions = Java.type('io.vertx.ext.consul.KeyValueOptions');
var AclToken = Java.type('io.vertx.ext.consul.AclToken');
var SessionOptions = Java.type('io.vertx.ext.consul.SessionOptions');
var KeyValueList = Java.type('io.vertx.ext.consul.KeyValueList');
var CheckList = Java.type('io.vertx.ext.consul.CheckList');
var DcCoordinates = Java.type('io.vertx.ext.consul.DcCoordinates');
var Session = Java.type('io.vertx.ext.consul.Session');
var EventOptions = Java.type('io.vertx.ext.consul.EventOptions');

/**
 A Vert.x service used to interact with Consul.

 @class
*/
var ConsulClient = function(j_val) {

  var j_consulClient = j_val;
  var that = this;

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_agentInfo = this.agentInfo;
  var __super_coordinateNodes = this.coordinateNodes;
  var __super_coordinateNodesWithOptions = this.coordinateNodesWithOptions;
  var __super_coordinateDatacenters = this.coordinateDatacenters;
  var __super_getKeys = this.getKeys;
  var __super_getKeysWithOptions = this.getKeysWithOptions;
  var __super_getValue = this.getValue;
  var __super_getValueWithOptions = this.getValueWithOptions;
  var __super_deleteValue = this.deleteValue;
  var __super_getValues = this.getValues;
  var __super_getValuesWithOptions = this.getValuesWithOptions;
  var __super_deleteValues = this.deleteValues;
  var __super_putValue = this.putValue;
  var __super_putValueWithOptions = this.putValueWithOptions;
  var __super_transaction = this.transaction;
  var __super_createAclToken = this.createAclToken;
  var __super_updateAclToken = this.updateAclToken;
  var __super_cloneAclToken = this.cloneAclToken;
  var __super_listAclTokens = this.listAclTokens;
  var __super_infoAclToken = this.infoAclToken;
  var __super_destroyAclToken = this.destroyAclToken;
  var __super_fireEvent = this.fireEvent;
  var __super_fireEventWithOptions = this.fireEventWithOptions;
  var __super_listEvents = this.listEvents;
  var __super_listEventsWithOptions = this.listEventsWithOptions;
  var __super_registerService = this.registerService;
  var __super_maintenanceService = this.maintenanceService;
  var __super_deregisterService = this.deregisterService;
  var __super_catalogServiceNodes = this.catalogServiceNodes;
  var __super_catalogServiceNodesWithOptions = this.catalogServiceNodesWithOptions;
  var __super_catalogDatacenters = this.catalogDatacenters;
  var __super_catalogNodes = this.catalogNodes;
  var __super_catalogNodesWithOptions = this.catalogNodesWithOptions;
  var __super_healthChecks = this.healthChecks;
  var __super_healthChecksWithOptions = this.healthChecksWithOptions;
  var __super_healthState = this.healthState;
  var __super_healthStateWithOptions = this.healthStateWithOptions;
  var __super_healthServiceNodes = this.healthServiceNodes;
  var __super_healthServiceNodesWithOptions = this.healthServiceNodesWithOptions;
  var __super_catalogServices = this.catalogServices;
  var __super_catalogServicesWithOptions = this.catalogServicesWithOptions;
  var __super_catalogNodeServices = this.catalogNodeServices;
  var __super_catalogNodeServicesWithOptions = this.catalogNodeServicesWithOptions;
  var __super_localServices = this.localServices;
  var __super_localChecks = this.localChecks;
  var __super_registerCheck = this.registerCheck;
  var __super_deregisterCheck = this.deregisterCheck;
  var __super_passCheck = this.passCheck;
  var __super_passCheckWithNote = this.passCheckWithNote;
  var __super_warnCheck = this.warnCheck;
  var __super_warnCheckWithNote = this.warnCheckWithNote;
  var __super_failCheck = this.failCheck;
  var __super_failCheckWithNote = this.failCheckWithNote;
  var __super_updateCheck = this.updateCheck;
  var __super_updateCheckWithNote = this.updateCheckWithNote;
  var __super_leaderStatus = this.leaderStatus;
  var __super_peersStatus = this.peersStatus;
  var __super_createSession = this.createSession;
  var __super_createSessionWithOptions = this.createSessionWithOptions;
  var __super_infoSession = this.infoSession;
  var __super_infoSessionWithOptions = this.infoSessionWithOptions;
  var __super_renewSession = this.renewSession;
  var __super_listSessions = this.listSessions;
  var __super_listSessionsWithOptions = this.listSessionsWithOptions;
  var __super_listNodeSessions = this.listNodeSessions;
  var __super_listNodeSessionsWithOptions = this.listNodeSessionsWithOptions;
  var __super_destroySession = this.destroySession;
  var __super_createPreparedQuery = this.createPreparedQuery;
  var __super_getPreparedQuery = this.getPreparedQuery;
  var __super_getAllPreparedQueries = this.getAllPreparedQueries;
  var __super_updatePreparedQuery = this.updatePreparedQuery;
  var __super_deletePreparedQuery = this.deletePreparedQuery;
  var __super_executePreparedQuery = this.executePreparedQuery;
  var __super_executePreparedQueryWithOptions = this.executePreparedQueryWithOptions;
  var __super_close = this.close;
  /**
   Returns the configuration and member information of the local agent

   @public
   @param resultHandler {function} will be provided with the configuration and member information of the local agent 
   @return {ConsulClient} reference to this, for fluency
   */
  this.agentInfo =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["agentInfo(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_agentInfo != 'undefined') {
      return __super_agentInfo.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the LAN network coordinates for all nodes in a given DC

   @public
   @param resultHandler {function} will be provided with network coordinates of nodes in datacenter 
   @return {ConsulClient} reference to this, for fluency
   */
  this.coordinateNodes =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["coordinateNodes(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateNodes != 'undefined') {
      return __super_coordinateNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the LAN network coordinates for all nodes in a given DC
   This is blocking query unlike {@link ConsulClient#coordinateNodes}

   @public
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with network coordinates of nodes in datacenter 
   @return {ConsulClient} reference to this, for fluency
   */
  this.coordinateNodesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["coordinateNodesWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateNodesWithOptions != 'undefined') {
      return __super_coordinateNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the WAN network coordinates for all Consul servers, organized by DCs

   @public
   @param resultHandler {function} will be provided with network coordinates for all Consul servers 
   @return {ConsulClient} reference to this, for fluency
   */
  this.coordinateDatacenters =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["coordinateDatacenters(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_coordinateDatacenters != 'undefined') {
      return __super_coordinateDatacenters.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the list of keys that corresponding to the specified key prefix.

   @public
   @param keyPrefix {string} the prefix 
   @param resultHandler {function} will be provided with keys list 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getKeys =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["getKeys(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getKeys != 'undefined') {
      return __super_getKeys.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the list of keys that corresponding to the specified key prefix.

   @public
   @param keyPrefix {string} the prefix 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with keys list 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getKeysWithOptions =  function(keyPrefix, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["getKeysWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getKeysWithOptions != 'undefined') {
      return __super_getKeysWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns key/value pair that corresponding to the specified key.
   An empty <a href="../../dataobjects.html#KeyValue">KeyValue</a> object will be returned if no such key is found.

   @public
   @param key {string} the key 
   @param resultHandler {function} will be provided with key/value pair 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getValue =  function(key, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["getValue(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValue != 'undefined') {
      return __super_getValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns key/value pair that corresponding to the specified key.
   An empty <a href="../../dataobjects.html#KeyValue">KeyValue</a> object will be returned if no such key is found.
   This is blocking query unlike {@link ConsulClient#getValue}

   @public
   @param key {string} the key 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with key/value pair 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getValueWithOptions =  function(key, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["getValueWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValueWithOptions != 'undefined') {
      return __super_getValueWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Remove the key/value pair that corresponding to the specified key

   @public
   @param key {string} the key 
   @param resultHandler {function} will be called on complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.deleteValue =  function(key, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["deleteValue(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deleteValue != 'undefined') {
      return __super_deleteValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the list of key/value pairs that corresponding to the specified key prefix.
   An empty <a href="../../dataobjects.html#KeyValueList">KeyValueList</a> object will be returned if no such key prefix is found.

   @public
   @param keyPrefix {string} the prefix 
   @param resultHandler {function} will be provided with list of key/value pairs 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getValues =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["getValues(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValues != 'undefined') {
      return __super_getValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the list of key/value pairs that corresponding to the specified key prefix.
   An empty <a href="../../dataobjects.html#KeyValueList">KeyValueList</a> object will be returned if no such key prefix is found.
   This is blocking query unlike {@link ConsulClient#getValues}

   @public
   @param keyPrefix {string} the prefix 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of key/value pairs 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getValuesWithOptions =  function(keyPrefix, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["getValuesWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getValuesWithOptions != 'undefined') {
      return __super_getValuesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Removes all the key/value pair that corresponding to the specified key prefix

   @public
   @param keyPrefix {string} the prefix 
   @param resultHandler {function} will be called on complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.deleteValues =  function(keyPrefix, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["deleteValues(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deleteValues != 'undefined') {
      return __super_deleteValues.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Adds specified key/value pair

   @public
   @param key {string} the key 
   @param value {string} the value 
   @param resultHandler {function} will be provided with success of operation 
   @return {ConsulClient} reference to this, for fluency
   */
  this.putValue =  function(key, value, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulClient["putValue(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](ar.result(), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_putValue != 'undefined') {
      return __super_putValue.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param key {string} the key 
   @param value {string} the value 
   @param options {Object} options used to push pair 
   @param resultHandler {function} will be provided with success of operation 
   @return {ConsulClient} reference to this, for fluency
   */
  this.putValueWithOptions =  function(key, value, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_consulClient["putValueWithOptions(java.lang.String,java.lang.String,io.vertx.ext.consul.KeyValueOptions,io.vertx.core.Handler)"](__args[0], __args[1], __args[2]  != null ? new KeyValueOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](ar.result(), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_putValueWithOptions != 'undefined') {
      return __super_putValueWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Manages multiple operations inside a single, atomic transaction.

   @public
   @param request {Object} transaction request 
   @param resultHandler {function} will be provided with result of transaction 
   @return {ConsulClient} reference to this, for fluency
   */
  this.transaction =  function(request, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["transaction(io.vertx.ext.consul.TxnRequest,io.vertx.core.Handler)"](__args[0]  != null ? new TxnRequest(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_transaction != 'undefined') {
      return __super_transaction.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Create new Acl token

   @public
   @param token {Object} properties of the token 
   @param idHandler {function} will be provided with ID of created token 
   @return {ConsulClient} reference to this, for fluency
   */
  this.createAclToken =  function(token, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["createAclToken(io.vertx.ext.consul.AclToken,io.vertx.core.Handler)"](__args[0]  != null ? new AclToken(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createAclToken != 'undefined') {
      return __super_createAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Update Acl token

   @public
   @param token {Object} properties of the token to be updated 
   @param idHandler {function} will be provided with ID of updated 
   @return {ConsulClient} reference to this, for fluency
   */
  this.updateAclToken =  function(token, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["updateAclToken(io.vertx.ext.consul.AclToken,io.vertx.core.Handler)"](__args[0]  != null ? new AclToken(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateAclToken != 'undefined') {
      return __super_updateAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Clone Acl token

   @public
   @param id {string} the ID of token to be cloned 
   @param idHandler {function} will be provided with ID of cloned token 
   @return {ConsulClient} reference to this, for fluency
   */
  this.cloneAclToken =  function(id, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["cloneAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_cloneAclToken != 'undefined') {
      return __super_cloneAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get list of Acl token

   @public
   @param resultHandler {function} will be provided with list of tokens 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listAclTokens =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["listAclTokens(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listAclTokens != 'undefined') {
      return __super_listAclTokens.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get info of Acl token

   @public
   @param id {string} the ID of token 
   @param tokenHandler {function} will be provided with token 
   @return {ConsulClient} reference to this, for fluency
   */
  this.infoAclToken =  function(id, tokenHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["infoAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoAclToken != 'undefined') {
      return __super_infoAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Destroy Acl token

   @public
   @param id {string} the ID of token 
   @param resultHandler {function} will be called on complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.destroyAclToken =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["destroyAclToken(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_destroyAclToken != 'undefined') {
      return __super_destroyAclToken.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Fires a new user event

   @public
   @param name {string} name of event 
   @param resultHandler {function} will be provided with properties of event 
   @return {ConsulClient} reference to this, for fluency
   */
  this.fireEvent =  function(name, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["fireEvent(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_fireEvent != 'undefined') {
      return __super_fireEvent.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Fires a new user event

   @public
   @param name {string} name of event 
   @param options {Object} options used to create event 
   @param resultHandler {function} will be provided with properties of event 
   @return {ConsulClient} reference to this, for fluency
   */
  this.fireEventWithOptions =  function(name, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["fireEventWithOptions(java.lang.String,io.vertx.ext.consul.EventOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new EventOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_fireEventWithOptions != 'undefined') {
      return __super_fireEventWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the most recent events known by the agent

   @public
   @param resultHandler {function} will be provided with list of events 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listEvents =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["listEvents(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listEvents != 'undefined') {
      return __super_listEvents.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the most recent events known by the agent.
   This is blocking query unlike {@link ConsulClient#listEvents}. However, the semantics of this endpoint
   are slightly different. Most blocking queries provide a monotonic index and block until a newer index is available.
   This can be supported as a consequence of the total ordering of the consensus protocol. With gossip,
   there is no ordering, and instead <code>X-Consul-Index</code> maps to the newest event that matches the query.
   <p>
   In practice, this means the index is only useful when used against a single agent and has no meaning globally.
   Because Consul defines the index as being opaque, clients should not be expecting a natural ordering either.

   @public
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of events 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listEventsWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["listEventsWithOptions(io.vertx.ext.consul.EventListOptions,io.vertx.core.Handler)"](__args[0]  != null ? new EventListOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listEventsWithOptions != 'undefined') {
      return __super_listEventsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Adds a new service, with an optional health check, to the local agent.

   @public
   @param serviceOptions {Object} the options of new service 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.registerService =  function(serviceOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["registerService(io.vertx.ext.consul.ServiceOptions,io.vertx.core.Handler)"](__args[0]  != null ? new ServiceOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_registerService != 'undefined') {
      return __super_registerService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Places a given service into "maintenance mode"

   @public
   @param maintenanceOptions {Object} the maintenance options 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.maintenanceService =  function(maintenanceOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["maintenanceService(io.vertx.ext.consul.MaintenanceOptions,io.vertx.core.Handler)"](__args[0]  != null ? new MaintenanceOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_maintenanceService != 'undefined') {
      return __super_maintenanceService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Remove a service from the local agent. The agent will take care of deregistering the service with the Catalog.
   If there is an associated check, that is also deregistered.

   @public
   @param id {string} the ID of service 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.deregisterService =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["deregisterService(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deregisterService != 'undefined') {
      return __super_deregisterService.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes providing a service

   @public
   @param service {string} name of service 
   @param resultHandler {function} will be provided with list of nodes providing given service 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogServiceNodes =  function(service, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["catalogServiceNodes(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServiceNodes != 'undefined') {
      return __super_catalogServiceNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes providing a service

   @public
   @param service {string} name of service 
   @param options {Object} options used to request services 
   @param resultHandler {function} will be provided with list of nodes providing given service 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogServiceNodesWithOptions =  function(service, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["catalogServiceNodesWithOptions(java.lang.String,io.vertx.ext.consul.ServiceQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new ServiceQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServiceNodesWithOptions != 'undefined') {
      return __super_catalogServiceNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return all the datacenters that are known by the Consul server

   @public
   @param resultHandler {function} will be provided with list of datacenters 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogDatacenters =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["catalogDatacenters(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogDatacenters != 'undefined') {
      return __super_catalogDatacenters.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes registered in a datacenter

   @public
   @param resultHandler {function} will be provided with list of nodes 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogNodes =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["catalogNodes(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodes != 'undefined') {
      return __super_catalogNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes registered in a datacenter

   @public
   @param options {Object} options used to request nodes 
   @param resultHandler {function} will be provided with list of nodes 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogNodesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["catalogNodesWithOptions(io.vertx.ext.consul.NodeQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new NodeQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodesWithOptions != 'undefined') {
      return __super_catalogNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the checks associated with the service

   @public
   @param service {string} the service name 
   @param resultHandler {function} will be provided with list of checks 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthChecks =  function(service, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["healthChecks(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthChecks != 'undefined') {
      return __super_healthChecks.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the checks associated with the service

   @public
   @param service {string} the service name 
   @param options {Object} options used to request checks 
   @param resultHandler {function} will be provided with list of checks 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthChecksWithOptions =  function(service, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["healthChecksWithOptions(java.lang.String,io.vertx.ext.consul.CheckQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new CheckQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthChecksWithOptions != 'undefined') {
      return __super_healthChecksWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the checks in the specified status

   @public
   @param healthState {Object} the health state 
   @param resultHandler {function} will be provided with list of checks 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthState =  function(healthState, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["healthState(io.vertx.ext.consul.HealthState,io.vertx.core.Handler)"](io.vertx.ext.consul.HealthState.valueOf(__args[0]), function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthState != 'undefined') {
      return __super_healthState.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the checks in the specified status

   @public
   @param healthState {Object} the health state 
   @param options {Object} options used to request checks 
   @param resultHandler {function} will be provided with list of checks 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthStateWithOptions =  function(healthState, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["healthStateWithOptions(io.vertx.ext.consul.HealthState,io.vertx.ext.consul.CheckQueryOptions,io.vertx.core.Handler)"](io.vertx.ext.consul.HealthState.valueOf(__args[0]), __args[1]  != null ? new CheckQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthStateWithOptions != 'undefined') {
      return __super_healthStateWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes providing the service. This endpoint is very similar to the {@link ConsulClient#catalogServiceNodes} endpoint;
   however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.

   @public
   @param service {string} the service name 
   @param passing {boolean} if true, filter results to only nodes with all checks in the passing state 
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthServiceNodes =  function(service, passing, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && typeof __args[2] === 'function') {
      j_consulClient["healthServiceNodes(java.lang.String,boolean,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthServiceNodes != 'undefined') {
      return __super_healthServiceNodes.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the nodes providing the service. This endpoint is very similar to the {@link ConsulClient#catalogServiceNodesWithOptions} endpoint;
   however, this endpoint automatically returns the status of the associated health check as well as any system level health checks.

   @public
   @param service {string} the service name 
   @param passing {boolean} if true, filter results to only nodes with all checks in the passing state 
   @param options {Object} options used to request services 
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.healthServiceNodesWithOptions =  function(service, passing, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] ==='boolean' && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_consulClient["healthServiceNodesWithOptions(java.lang.String,boolean,io.vertx.ext.consul.ServiceQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1], __args[2]  != null ? new ServiceQueryOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[3](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_healthServiceNodesWithOptions != 'undefined') {
      return __super_healthServiceNodesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the services registered in a datacenter

   @public
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogServices =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["catalogServices(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServices != 'undefined') {
      return __super_catalogServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the services registered in a datacenter
   This is blocking query unlike {@link ConsulClient#catalogServices}

   @public
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogServicesWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["catalogServicesWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogServicesWithOptions != 'undefined') {
      return __super_catalogServicesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the node's registered services

   @public
   @param node {string} node name 
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogNodeServices =  function(node, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["catalogNodeServices(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodeServices != 'undefined') {
      return __super_catalogNodeServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the node's registered services
   This is blocking query unlike {@link ConsulClient#catalogNodeServices}

   @public
   @param node {string} node name 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.catalogNodeServicesWithOptions =  function(node, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["catalogNodeServicesWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_catalogNodeServicesWithOptions != 'undefined') {
      return __super_catalogNodeServicesWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns list of services registered with the local agent.

   @public
   @param resultHandler {function} will be provided with list of services 
   @return {ConsulClient} reference to this, for fluency
   */
  this.localServices =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["localServices(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_localServices != 'undefined') {
      return __super_localServices.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Return all the checks that are registered with the local agent.

   @public
   @param resultHandler {function} will be provided with list of checks 
   @return {ConsulClient} reference to this, for fluency
   */
  this.localChecks =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["localChecks(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_localChecks != 'undefined') {
      return __super_localChecks.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Add a new check to the local agent. The agent is responsible for managing the status of the check
   and keeping the Catalog in sync.

   @public
   @param checkOptions {Object} options used to register new check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.registerCheck =  function(checkOptions, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["registerCheck(io.vertx.ext.consul.CheckOptions,io.vertx.core.Handler)"](__args[0]  != null ? new CheckOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_registerCheck != 'undefined') {
      return __super_registerCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Remove a check from the local agent. The agent will take care of deregistering the check from the Catalog.

   @public
   @param checkId {string} the ID of check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.deregisterCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["deregisterCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deregisterCheck != 'undefined') {
      return __super_deregisterCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.passCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["passCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_passCheck != 'undefined') {
      return __super_passCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "passing". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param note {string} specifies a human-readable message. This will be passed through to the check's <code>Output</code> field. 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.passCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulClient["passCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_passCheckWithNote != 'undefined') {
      return __super_passCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.warnCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["warnCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_warnCheck != 'undefined') {
      return __super_warnCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "warning". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param note {string} specifies a human-readable message. This will be passed through to the check's <code>Output</code> field. 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.warnCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulClient["warnCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_warnCheckWithNote != 'undefined') {
      return __super_warnCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.failCheck =  function(checkId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["failCheck(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_failCheck != 'undefined') {
      return __super_failCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to "critical". Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param note {string} specifies a human-readable message. This will be passed through to the check's <code>Output</code> field. 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.failCheckWithNote =  function(checkId, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulClient["failCheckWithNote(java.lang.String,java.lang.String,io.vertx.core.Handler)"](__args[0], __args[1], function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_failCheckWithNote != 'undefined') {
      return __super_failCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param status {Object} new status of check 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.updateCheck =  function(checkId, status, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_consulClient["updateCheck(java.lang.String,io.vertx.ext.consul.CheckStatus,io.vertx.core.Handler)"](__args[0], io.vertx.ext.consul.CheckStatus.valueOf(__args[1]), function(ar) {
        if (ar.succeeded()) {
          __args[2](null, null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCheck != 'undefined') {
      return __super_updateCheck.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Set status of the check to given status. Used with a check that is of the TTL type. The TTL clock will be reset.

   @public
   @param checkId {string} the ID of check 
   @param status {Object} new status of check 
   @param note {string} specifies a human-readable message. This will be passed through to the check's <code>Output</code> field. 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.updateCheckWithNote =  function(checkId, status, note, resultHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_consulClient["updateCheckWithNote(java.lang.String,io.vertx.ext.consul.CheckStatus,java.lang.String,io.vertx.core.Handler)"](__args[0], io.vertx.ext.consul.CheckStatus.valueOf(__args[1]), __args[2], function(ar) {
        if (ar.succeeded()) {
          __args[3](null, null);
        } else {
          __args[3](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updateCheckWithNote != 'undefined') {
      return __super_updateCheckWithNote.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Get the Raft leader for the datacenter in which the agent is running.
   It returns an address in format "<code>10.1.10.12:8300</code>"

   @public
   @param resultHandler {function} will be provided with address of cluster leader 
   @return {ConsulClient} reference to this, for fluency
   */
  this.leaderStatus =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["leaderStatus(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_leaderStatus != 'undefined') {
      return __super_leaderStatus.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Retrieves the Raft peers for the datacenter in which the the agent is running.
   It returns a list of addresses "<code>10.1.10.12:8300</code>", "<code>10.1.10.13:8300</code>"

   @public
   @param resultHandler {function} will be provided with list of peers 
   @return {ConsulClient} reference to this, for fluency
   */
  this.peersStatus =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["peersStatus(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_peersStatus != 'undefined') {
      return __super_peersStatus.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Initialize a new session

   @public
   @param idHandler {function} will be provided with ID of new session 
   @return {ConsulClient} reference to this, for fluency
   */
  this.createSession =  function(idHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["createSession(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createSession != 'undefined') {
      return __super_createSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Initialize a new session

   @public
   @param options {Object} options used to create session 
   @param idHandler {function} will be provided with ID of new session 
   @return {ConsulClient} reference to this, for fluency
   */
  this.createSessionWithOptions =  function(options, idHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["createSessionWithOptions(io.vertx.ext.consul.SessionOptions,io.vertx.core.Handler)"](__args[0]  != null ? new SessionOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createSessionWithOptions != 'undefined') {
      return __super_createSessionWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the requested session information

   @public
   @param id {string} the ID of requested session 
   @param resultHandler {function} will be provided with info of requested session 
   @return {ConsulClient} reference to this, for fluency
   */
  this.infoSession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["infoSession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoSession != 'undefined') {
      return __super_infoSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the requested session information
   This is blocking query unlike {@link ConsulClient#infoSession}

   @public
   @param id {string} the ID of requested session 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with info of requested session 
   @return {ConsulClient} reference to this, for fluency
   */
  this.infoSessionWithOptions =  function(id, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["infoSessionWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_infoSessionWithOptions != 'undefined') {
      return __super_infoSessionWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Renews the given session. This is used with sessions that have a TTL, and it extends the expiration by the TTL

   @public
   @param id {string} the ID of session that should be renewed 
   @param resultHandler {function} will be provided with info of renewed session 
   @return {ConsulClient} reference to this, for fluency
   */
  this.renewSession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["renewSession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_renewSession != 'undefined') {
      return __super_renewSession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the active sessions

   @public
   @param resultHandler {function} will be provided with list of sessions 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listSessions =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["listSessions(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listSessions != 'undefined') {
      return __super_listSessions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the active sessions
   This is blocking query unlike {@link ConsulClient#listSessions}

   @public
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of sessions 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listSessionsWithOptions =  function(options, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["listSessionsWithOptions(io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listSessionsWithOptions != 'undefined') {
      return __super_listSessionsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the active sessions for a given node

   @public
   @param nodeId {string} the ID of node 
   @param resultHandler {function} will be provided with list of sessions 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listNodeSessions =  function(nodeId, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["listNodeSessions(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listNodeSessions != 'undefined') {
      return __super_listNodeSessions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns the active sessions for a given node
   This is blocking query unlike {@link ConsulClient#listNodeSessions}

   @public
   @param nodeId {string} the ID of node 
   @param options {Object} the blocking options 
   @param resultHandler {function} will be provided with list of sessions 
   @return {ConsulClient} reference to this, for fluency
   */
  this.listNodeSessionsWithOptions =  function(nodeId, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["listNodeSessionsWithOptions(java.lang.String,io.vertx.ext.consul.BlockingQueryOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new BlockingQueryOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_listNodeSessionsWithOptions != 'undefined') {
      return __super_listNodeSessionsWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Destroys the given session

   @public
   @param id {string} the ID of session 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.destroySession =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["destroySession(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_destroySession != 'undefined') {
      return __super_destroySession.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param definition {Object} definition of the prepare query 
   @param resultHandler {function} will be provided with id of created prepare query 
   @return {ConsulClient} reference to this, for fluency
   */
  this.createPreparedQuery =  function(definition, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["createPreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition,io.vertx.core.Handler)"](__args[0]  != null ? new PreparedQueryDefinition(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](ar.result(), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_createPreparedQuery != 'undefined') {
      return __super_createPreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns an existing prepared query

   @public
   @param id {string} the id of the query to read 
   @param resultHandler {function} will be provided with definition of the prepare query 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getPreparedQuery =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["getPreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getPreparedQuery != 'undefined') {
      return __super_getPreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Returns a list of all prepared queries.

   @public
   @param resultHandler {function} will be provided with list of definitions of the all prepare queries 
   @return {ConsulClient} reference to this, for fluency
   */
  this.getAllPreparedQueries =  function(resultHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_consulClient["getAllPreparedQueries(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_getAllPreparedQueries != 'undefined') {
      return __super_getAllPreparedQueries.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param definition {Object} definition of the prepare query 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.updatePreparedQuery =  function(definition, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && (typeof __args[0] === 'object' && __args[0] != null) && typeof __args[1] === 'function') {
      j_consulClient["updatePreparedQuery(io.vertx.ext.consul.PreparedQueryDefinition,io.vertx.core.Handler)"](__args[0]  != null ? new PreparedQueryDefinition(new JsonObject(Java.asJSONCompatible(__args[0]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_updatePreparedQuery != 'undefined') {
      return __super_updatePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Deletes an existing prepared query

   @public
   @param id {string} the id of the query to delete 
   @param resultHandler {function} will be called when complete 
   @return {ConsulClient} reference to this, for fluency
   */
  this.deletePreparedQuery =  function(id, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["deletePreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](null, null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_deletePreparedQuery != 'undefined') {
      return __super_deletePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Executes an existing prepared query.

   @public
   @param query {string} the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template. 
   @param resultHandler {function} will be provided with response 
   @return {ConsulClient} reference to this, for fluency
   */
  this.executePreparedQuery =  function(query, resultHandler) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_consulClient["executePreparedQuery(java.lang.String,io.vertx.core.Handler)"](__args[0], function(ar) {
        if (ar.succeeded()) {
          __args[1](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[1](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_executePreparedQuery != 'undefined') {
      return __super_executePreparedQuery.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Executes an existing prepared query.

   @public
   @param query {string} the ID of the query to execute. This can also be the name of an existing prepared query, or a name that matches a prefix name for a prepared query template. 
   @param options {Object} the options used to execute prepared query 
   @param resultHandler {function} will be provided with response 
   @return {ConsulClient} reference to this, for fluency
   */
  this.executePreparedQueryWithOptions =  function(query, options, resultHandler) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_consulClient["executePreparedQueryWithOptions(java.lang.String,io.vertx.ext.consul.PreparedQueryExecuteOptions,io.vertx.core.Handler)"](__args[0], __args[1]  != null ? new PreparedQueryExecuteOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
        if (ar.succeeded()) {
          __args[2](utils.convReturnDataObject(ar.result()), null);
        } else {
          __args[2](null, ar.cause());
        }
      }) ;
      return that;
    } else if (typeof __super_executePreparedQueryWithOptions != 'undefined') {
      return __super_executePreparedQueryWithOptions.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**
   Close the client and release its resources

   @public

   */
  this.close =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_consulClient["close()"]();
    } else if (typeof __super_close != 'undefined') {
      return __super_close.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_consulClient;
};

ConsulClient._jclass = utils.getJavaClass("io.vertx.ext.consul.ConsulClient");
ConsulClient._jtype = {accept: function(obj) {
    return ConsulClient._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(ConsulClient.prototype, {});
    ConsulClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
ConsulClient._create = function(jdel) {var obj = Object.create(ConsulClient.prototype, {});
  ConsulClient.apply(obj, arguments);
  return obj;
}
/**
 Create a Consul client.

 @memberof module:vertx-consul-js/consul_client
 @param vertx {Vertx} the Vert.x instance 
 @param options {Object} the options 
 @return {ConsulClient} the client
 */
ConsulClient.create =  function() {
  var __args = arguments;
  if (__args.length === 1 && typeof __args[0] === 'object' && __args[0]._jdel) {
    return utils.convReturnVertxGen(ConsulClient, JConsulClient["create(io.vertx.core.Vertx)"](__args[0]._jdel)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(ConsulClient, JConsulClient["create(io.vertx.core.Vertx,io.vertx.ext.consul.ConsulClientOptions)"](__args[0]._jdel, __args[1]  != null ? new ConsulClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = ConsulClient;