/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-auth-oauth2-js/google_auth */
var utils = require('vertx-js/util/utils');
var OpenIDConnectAuth = require('vertx-auth-oauth2-js/open_id_connect_auth');
var Vertx = require('vertx-js/vertx');
var OAuth2Auth = require('vertx-auth-oauth2-js/o_auth2_auth');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JGoogleAuth = Java.type('io.vertx.ext.auth.oauth2.providers.GoogleAuth');
var HttpClientOptions = Java.type('io.vertx.core.http.HttpClientOptions');
var OAuth2ClientOptions = Java.type('io.vertx.ext.auth.oauth2.OAuth2ClientOptions');

/**

 @class
*/
var GoogleAuth = function(j_val) {

  var j_googleAuth = j_val;
  var that = this;
  OpenIDConnectAuth.call(this, j_val);

  var __super_create = this.create;
  var __super_create = this.create;
  var __super_discover = this.discover;
  var __super_create = this.create;
  var __super_create = this.create;
  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_googleAuth;
};

GoogleAuth._jclass = utils.getJavaClass("io.vertx.ext.auth.oauth2.providers.GoogleAuth");
GoogleAuth._jtype = {accept: function(obj) {
    return GoogleAuth._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(GoogleAuth.prototype, {});
    GoogleAuth.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
GoogleAuth._create = function(jdel) {var obj = Object.create(GoogleAuth.prototype, {});
  GoogleAuth.apply(obj, arguments);
  return obj;
}
/**
 Create a OAuth2Auth provider for Google Service Account (Server to Server)

 @memberof module:vertx-auth-oauth2-js/google_auth
 @param vertx {Vertx} 
 @param serviceAccountJson {Object} the configuration json file from your Google API page 
 @param httpClientOptions {Object} custom http client options 
 @return {OAuth2Auth}
 */
GoogleAuth.create =  function() {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
    return utils.convReturnVertxGen(OAuth2Auth, JGoogleAuth["create(io.vertx.core.Vertx,java.lang.String,java.lang.String)"](__args[0]._jdel, __args[1], __args[2])) ;
  } else if (__args.length === 4 && typeof __args[0] === 'object' && __args[0]._jdel && typeof __args[1] === 'string' && typeof __args[2] === 'string' && (typeof __args[3] === 'object' && __args[3] != null)) {
    return utils.convReturnVertxGen(OAuth2Auth, JGoogleAuth["create(io.vertx.core.Vertx,java.lang.String,java.lang.String,io.vertx.core.http.HttpClientOptions)"](__args[0]._jdel, __args[1], __args[2], __args[3]  != null ? new HttpClientOptions(new JsonObject(Java.asJSONCompatible(__args[3]))) : null)) ;
  } else if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(OAuth2Auth, JGoogleAuth["create(io.vertx.core.Vertx,io.vertx.core.json.JsonObject)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]))) ;
  } else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null)) {
    return utils.convReturnVertxGen(OAuth2Auth, JGoogleAuth["create(io.vertx.core.Vertx,io.vertx.core.json.JsonObject,io.vertx.core.http.HttpClientOptions)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]), __args[2]  != null ? new HttpClientOptions(new JsonObject(Java.asJSONCompatible(__args[2]))) : null)) ;
  }else throw new TypeError('function invoked with invalid arguments');
};

/**
 Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the default site in the
 configuration options and attempt to load the well known descriptor. If a site is provided (for example when
 running on a custom instance) that site will be used to do the lookup.
 <p>
 If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
 into the OAuth provider so tokens can be decoded.

 @memberof module:vertx-auth-oauth2-js/google_auth
 @param vertx {Vertx} the vertx instance 
 @param config {Object} the initial config 
 @param handler {function} the instantiated Oauth2 provider instance handler 
 */
GoogleAuth.discover =  function(vertx, config, handler) {
  var __args = arguments;
  if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
    JGoogleAuth["discover(io.vertx.core.Vertx,io.vertx.ext.auth.oauth2.OAuth2ClientOptions,io.vertx.core.Handler)"](__args[0]._jdel, __args[1]  != null ? new OAuth2ClientOptions(new JsonObject(Java.asJSONCompatible(__args[1]))) : null, function(ar) {
      if (ar.succeeded()) {
        __args[2](utils.convReturnVertxGen(OAuth2Auth, ar.result()), null);
      } else {
        __args[2](null, ar.cause());
      }
    });
  }else throw new TypeError('function invoked with invalid arguments');
};

module.exports = GoogleAuth;