/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.range.comparison;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.RangeCodegenUtilKt;
import org.jetbrains.kotlin.codegen.range.comparison.CharComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.ComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.DoubleComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.FloatComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.IntComparisonGenerator;
import org.jetbrains.kotlin.codegen.range.comparison.LongComparisonGenerator;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a \u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"getComparisonGeneratorForPrimitiveType", "Lorg/jetbrains/kotlin/codegen/range/comparison/ComparisonGenerator;", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "getComparisonGeneratorForRangeContainsCall", "codegen", "Lorg/jetbrains/kotlin/codegen/ExpressionCodegen;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isPrimitiveIntOrCoercible", "", "backend"})
public final class ComparisonGeneratorKt {
    @NotNull
    public static final ComparisonGenerator getComparisonGeneratorForPrimitiveType(@NotNull Type type2) {
        ComparisonGenerator comparisonGenerator;
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        if (Intrinsics.areEqual((Object)type2, (Object)Type.CHAR_TYPE)) {
            comparisonGenerator = CharComparisonGenerator.INSTANCE;
        } else if (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(type2)) {
            comparisonGenerator = IntComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.LONG_TYPE)) {
            comparisonGenerator = LongComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.FLOAT_TYPE)) {
            comparisonGenerator = FloatComparisonGenerator.INSTANCE;
        } else if (Intrinsics.areEqual((Object)type2, (Object)Type.DOUBLE_TYPE)) {
            comparisonGenerator = DoubleComparisonGenerator.INSTANCE;
        } else {
            throw (Throwable)new UnsupportedOperationException("Unexpected primitive type: " + type2);
        }
        return comparisonGenerator;
    }

    @Nullable
    public static final ComparisonGenerator getComparisonGeneratorForRangeContainsCall(@NotNull ExpressionCodegen codegen, @NotNull ResolvedCall<? extends CallableDescriptor> call2) {
        Intrinsics.checkParameterIsNotNull((Object)codegen, (String)"codegen");
        Intrinsics.checkParameterIsNotNull(call2, (String)"call");
        CallableDescriptor descriptor2 = call2.getResultingDescriptor();
        Annotated annotated = descriptor2.getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
            annotated = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        }
        if (annotated == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)annotated, (String)"descriptor.extensionRece\u2026eter?.type ?: return null");
        Annotated receiverType = annotated;
        KotlinType kotlinType2 = RangeCodegenUtilKt.getRangeOrProgressionElementType((KotlinType)receiverType);
        if (kotlinType2 == null) {
            return null;
        }
        KotlinType elementType = kotlinType2;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Annotated annotated2 = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        if (annotated2 == null || (annotated2 = annotated2.getType()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)annotated2, (String)"descriptor.valueParamete\u2026ll()?.type ?: return null");
        Annotated valueParameterType = annotated2;
        Type type2 = codegen.asmType(elementType);
        Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"codegen.asmType(elementType)");
        Type asmElementType = type2;
        Type type3 = codegen.asmType((KotlinType)valueParameterType);
        Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"codegen.asmType(valueParameterType)");
        Type asmValueParameterType = type3;
        return Intrinsics.areEqual((Object)asmElementType, (Object)asmValueParameterType) ? ComparisonGeneratorKt.getComparisonGeneratorForPrimitiveType(asmElementType) : (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmElementType) && ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmValueParameterType) ? (ComparisonGenerator)IntComparisonGenerator.INSTANCE : (ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmElementType) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.LONG_TYPE) || ComparisonGeneratorKt.isPrimitiveIntOrCoercible(asmValueParameterType) && Intrinsics.areEqual((Object)asmElementType, (Object)Type.LONG_TYPE) ? (ComparisonGenerator)LongComparisonGenerator.INSTANCE : (Intrinsics.areEqual((Object)asmElementType, (Object)Type.FLOAT_TYPE) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.DOUBLE_TYPE) || Intrinsics.areEqual((Object)asmElementType, (Object)Type.DOUBLE_TYPE) && Intrinsics.areEqual((Object)asmValueParameterType, (Object)Type.FLOAT_TYPE) ? (ComparisonGenerator)DoubleComparisonGenerator.INSTANCE : null)));
    }

    private static final boolean isPrimitiveIntOrCoercible(@NotNull Type $receiver) {
        return Intrinsics.areEqual((Object)$receiver, (Object)Type.INT_TYPE) || Intrinsics.areEqual((Object)$receiver, (Object)Type.SHORT_TYPE) || Intrinsics.areEqual((Object)$receiver, (Object)Type.BYTE_TYPE);
    }
}

