/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.utils;

import io.vertx.lang.groovy.fastclasspathscanner.utils.URLPathEncoder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ClasspathUtils {
    public static URL getClasspathResourceURL(File classpathElt, String relativePath) {
        String classpathEltURL;
        boolean classpathEltIsJar = classpathElt.isFile();
        try {
            classpathEltURL = classpathElt.toURI().toURL().toString();
            if (!classpathEltIsJar && !classpathEltURL.endsWith("/")) {
                classpathEltURL = classpathEltURL + "/";
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String relativePathEncoded = URLPathEncoder.encodePath(relativePath);
        String url = classpathEltIsJar ? "jar:" + classpathEltURL + "!/" + relativePathEncoded : classpathEltURL + relativePathEncoded;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean canRead(File file) {
        try {
            return file.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }
}

