/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy.fastclasspathscanner.scanner;

import io.vertx.lang.groovy.fastclasspathscanner.scanner.ScanSpec;
import io.vertx.lang.groovy.fastclasspathscanner.utils.ClasspathUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.FastPathResolver;
import io.vertx.lang.groovy.fastclasspathscanner.utils.FileUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.JarUtils;
import io.vertx.lang.groovy.fastclasspathscanner.utils.LogNode;
import io.vertx.lang.groovy.fastclasspathscanner.utils.NestedJarHandler;
import java.io.File;
import java.io.IOException;

class RelativePath {
    private final ClassLoader[] classLoaders;
    private final String pathToResolveAgainst;
    private final String relativePath;
    private final boolean isJar;
    private String zipClasspathBaseDir = "";
    private final NestedJarHandler nestedJarHandler;
    private String resolvedPathCached;
    private boolean resolvedPathIsCached;
    private File fileCached;
    private boolean fileIsCached;
    private String canonicalPathCached;
    private boolean canonicalPathIsCached;
    private boolean isFileCached;
    private boolean isFileIsCached;
    private boolean isDirectoryCached;
    private boolean isDirectoryIsCached;
    private boolean existsCached;
    private boolean existsIsCached;

    public RelativePath(String pathToResolveAgainst, String relativePath, ClassLoader[] classLoaders, NestedJarHandler nestedJarHandler) {
        this.classLoaders = classLoaders;
        this.pathToResolveAgainst = pathToResolveAgainst;
        this.nestedJarHandler = nestedJarHandler;
        this.relativePath = relativePath.endsWith("!") ? relativePath.substring(0, relativePath.length() - 1) : (relativePath.endsWith("!/") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!") ? relativePath.substring(0, relativePath.length() - 2) : (relativePath.endsWith("/!/") ? relativePath.substring(0, relativePath.length() - 3) : relativePath)));
        this.isJar = this.relativePath.contains("!") || JarUtils.isJar(this.relativePath);
    }

    public int hashCode() {
        try {
            return this.getCanonicalPath().hashCode() + this.zipClasspathBaseDir.hashCode() * 57;
        }
        catch (IOException e) {
            return 0;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof RelativePath)) {
            return false;
        }
        RelativePath other = (RelativePath)o;
        try {
            String thisCp = this.getCanonicalPath();
            String otherCp = other.getCanonicalPath();
            if (thisCp == null || otherCp == null) {
                return false;
            }
            if (!thisCp.equals(otherCp)) {
                return false;
            }
            return this.getZipClasspathBaseDir().equals(other.getZipClasspathBaseDir());
        }
        catch (IOException e) {
            return false;
        }
    }

    public String toString() {
        try {
            return this.zipClasspathBaseDir.isEmpty() ? this.getCanonicalPath() : this.getCanonicalPath() + "!" + this.zipClasspathBaseDir;
        }
        catch (IOException e) {
            return this.getResolvedPath();
        }
    }

    public ClassLoader[] getClassLoaders() {
        return this.classLoaders;
    }

    public String getResolvedPath() {
        if (!this.resolvedPathIsCached) {
            this.resolvedPathCached = FastPathResolver.resolve(this.pathToResolveAgainst, this.relativePath);
            this.resolvedPathIsCached = true;
        }
        return this.resolvedPathCached;
    }

    public File getFile() throws IOException {
        if (!this.fileIsCached) {
            String path = this.getResolvedPath();
            if (path == null) {
                throw new IOException("Path " + this.relativePath + " could not be resolved relative to " + this.pathToResolveAgainst);
            }
            boolean isRemote = path.startsWith("http://") || path.startsWith("https://");
            int plingIdx = path.indexOf(33);
            if (plingIdx > 0 || isRemote) {
                String nestedJarPath;
                String[] parts = path.split("!");
                int ii = parts.length - 1;
                for (int i = 0; i < ii; ++i) {
                    if (JarUtils.isJar(parts[i])) continue;
                    throw new IOException("Path " + path + " uses nested jar syntax, but contains a segment that does not have a jar extension");
                }
                if (parts.length > 1 && !JarUtils.isJar(parts[parts.length - 1])) {
                    this.zipClasspathBaseDir = parts[parts.length - 1];
                    if (this.zipClasspathBaseDir.startsWith("/")) {
                        this.zipClasspathBaseDir = this.zipClasspathBaseDir.substring(1);
                    }
                    nestedJarPath = path.substring(0, path.lastIndexOf(33));
                } else {
                    nestedJarPath = path;
                }
                try {
                    this.fileCached = this.nestedJarHandler.getInnermostNestedJar(nestedJarPath);
                }
                catch (Exception e) {
                    throw new IOException("Exception while getting jarfile " + this.relativePath, e);
                }
                if (this.fileCached == null || !ClasspathUtils.canRead(this.fileCached)) {
                    throw new IOException("Could not find jarfile " + this.relativePath);
                }
            } else {
                this.fileCached = new File(path);
            }
            try {
                this.fileCached = this.fileCached.getCanonicalFile();
            }
            catch (SecurityException e) {
                throw new IOException(e);
            }
            this.fileIsCached = true;
        }
        return this.fileCached;
    }

    public String getZipClasspathBaseDir() {
        return this.zipClasspathBaseDir;
    }

    public String getCanonicalPath() throws IOException {
        if (!this.canonicalPathIsCached) {
            File file = this.getFile();
            this.canonicalPathCached = file.getPath();
            this.canonicalPathIsCached = true;
        }
        return this.canonicalPathCached;
    }

    public boolean isFile() throws IOException {
        if (!this.isFileIsCached) {
            this.isFileCached = this.getFile().isFile();
            this.isFileIsCached = true;
        }
        return this.isFileCached;
    }

    public boolean isDirectory() throws IOException {
        if (!this.isDirectoryIsCached) {
            this.isDirectoryCached = this.getFile().isDirectory();
            this.isDirectoryIsCached = true;
        }
        return this.isDirectoryCached;
    }

    public boolean isJar() {
        return this.isJar;
    }

    public boolean isClassfile() {
        return FileUtils.isClassfile(this.getResolvedPath());
    }

    private boolean exists() throws IOException {
        if (!this.existsIsCached) {
            this.existsCached = ClasspathUtils.canRead(this.getFile());
            this.existsIsCached = true;
        }
        return this.existsCached;
    }

    public boolean isValidClasspathElement(ScanSpec scanSpec, LogNode log) throws InterruptedException {
        String path = this.getResolvedPath();
        if (path == null) {
            if (log != null) {
                log.log("Ignoring non-local classpath element: " + this.relativePath);
            }
            return false;
        }
        try {
            boolean isDirectory;
            if (!this.exists()) {
                if (log != null) {
                    log.log("Classpath element does not exist: " + path);
                }
                return false;
            }
            boolean isFile = this.isFile();
            if (isFile != !(isDirectory = this.isDirectory())) {
                if (log != null) {
                    log.log("Ignoring invalid classpath element: " + path);
                }
                return false;
            }
            if (isFile) {
                String canonicalPath = this.getCanonicalPath();
                if (!JarUtils.isJar(canonicalPath)) {
                    if (log != null) {
                        log.log("Ignoring non-jar file on classpath: " + path);
                    }
                    return false;
                }
                if (scanSpec.blacklistSystemJars() && JarUtils.isJREJar(path, log)) {
                    if (log != null) {
                        log.log("Ignoring JRE jar: " + path);
                    }
                    return false;
                }
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Could not canonicalize path: " + path, e);
            }
            return false;
        }
        return true;
    }
}

