/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.lang.groovy;

import io.vertx.codetrans.CodeTranslator;
import io.vertx.codetrans.Lang;
import io.vertx.codetrans.lang.groovy.GroovyLang;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocGenerator;
import io.vertx.docgen.JavaDocGenerator;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class GroovyDocGenerator
implements DocGenerator {
    private CodeTranslator translator;
    private JavaDocGenerator javaGen = new JavaDocGenerator();

    public void init(ProcessingEnvironment env) {
        this.translator = new CodeTranslator(env);
        this.javaGen.init(env);
    }

    public String renderSource(ExecutableElement elt, String source) {
        GroovyLang lang = new GroovyLang();
        try {
            return this.translator.translate(elt, (Lang)lang);
        }
        catch (Exception e) {
            System.out.println("Cannot generate " + elt.getEnclosingElement().getSimpleName() + "#" + elt.getSimpleName() + " : " + e.getMessage());
            return "Code not translatable";
        }
    }

    public String getName() {
        return "groovy";
    }

    public String resolveTypeLink(TypeElement elt, Coordinate coordinate) {
        return this.javaGen.resolveTypeLink(elt, coordinate);
    }

    public String resolveConstructorLink(ExecutableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveConstructorLink(elt, coordinate);
    }

    public String resolveMethodLink(ExecutableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveMethodLink(elt, coordinate);
    }

    public String resolveLabel(Element elt, String defaultLabel) {
        return this.javaGen.resolveLabel(elt, defaultLabel);
    }

    public String resolveFieldLink(VariableElement elt, Coordinate coordinate) {
        return this.javaGen.resolveFieldLink(elt, coordinate);
    }
}

