/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.stack.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.vertx.stack.resolver.ResolutionOptions;
import shaded.org.apache.maven.model.Exclusion;

public class Dependency
extends shaded.org.apache.maven.model.Dependency {
    private boolean included = true;
    private boolean transitive = true;

    public Dependency(String groupId, String artifactId, String version) {
        this();
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
    }

    public Dependency(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version);
        this.setType(type);
    }

    public Dependency() {
        this.setType("jar");
    }

    public boolean isIncluded() {
        return this.included;
    }

    public Dependency setIncluded(boolean included) {
        this.included = included;
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Dependency setTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }

    public ResolutionOptions getResolutionOptions() {
        ResolutionOptions options = new ResolutionOptions();
        options.setWithTransitive(this.transitive);
        for (Exclusion exclusion : this.getExclusions()) {
            options.addExclusion(exclusion.getGroupId() + ":" + exclusion.getArtifactId());
        }
        return options;
    }

    public String getGACV() {
        return this.getManagementKey() + ":" + this.getVersion();
    }

    @Override
    @JsonIgnore
    public void setOptional(boolean optional) {
        throw new UnsupportedOperationException("You cannot add an optional dependency to a stack - optional does not make sense in this case");
    }
}

