/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.pool;

import io.netty.channel.EventLoop;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.pool.ConnectResult;
import io.vertx.core.net.impl.pool.ConnectionPool;
import io.vertx.core.net.impl.pool.Lease;
import io.vertx.core.net.impl.pool.PoolConnector;
import io.vertx.core.net.impl.pool.PoolWaiter;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class SqlConnectionPool {
    private final Function<Context, Future<SqlConnection>> connectionProvider;
    private final VertxInternal vertx;
    private final ConnectionPool<PooledConnection> pool;
    private final Supplier<Handler<PooledConnection>> hook;
    private final Function<Connection, Future<Void>> afterAcquire;
    private final Function<Connection, Future<Void>> beforeRecycle;
    private final int pipeliningLimit;
    private final long idleTimeout;
    private final int maxSize;
    private final PoolConnector<PooledConnection> connector = new PoolConnector<PooledConnection>(){

        public void connect(EventLoopContext context, PoolConnector.Listener listener, Handler<AsyncResult<ConnectResult<PooledConnection>>> handler) {
            Future future = (Future)SqlConnectionPool.this.connectionProvider.apply(context);
            future.onComplete(ar -> {
                if (ar.succeeded()) {
                    SqlConnectionBase res = (SqlConnectionBase)ar.result();
                    Connection conn = res.unwrap();
                    if (conn.isValid()) {
                        PooledConnection pooled = new PooledConnection(res.factory(), conn, listener);
                        conn.init(pooled);
                        Handler connectionHandler = (Handler)SqlConnectionPool.this.hook.get();
                        if (connectionHandler != null) {
                            pooled.poolResultHandler = handler;
                            connectionHandler.handle((Object)pooled);
                        } else {
                            handler.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)pooled, (long)SqlConnectionPool.this.pipeliningLimit, 0L)));
                        }
                    } else {
                        handler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION));
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            });
        }

        public boolean isValid(PooledConnection connection) {
            return true;
        }
    };

    public SqlConnectionPool(Function<Context, Future<SqlConnection>> connectionProvider, Supplier<Handler<PooledConnection>> hook, Function<Connection, Future<Void>> afterAcquire, Function<Connection, Future<Void>> beforeRecycle, final VertxInternal vertx, long idleTimeout, int maxSize, int pipeliningLimit, int maxWaitQueueSize, int eventLoopSize) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Pool max size must be > 0");
        }
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException("Pipelining limit must be > 0");
        }
        if (afterAcquire != null && beforeRecycle == null) {
            throw new IllegalArgumentException("afterAcquire and beforeRecycle hooks must be both not null");
        }
        this.pool = ConnectionPool.pool(this.connector, (int[])new int[]{maxSize}, (int)maxWaitQueueSize);
        this.vertx = vertx;
        this.pipeliningLimit = pipeliningLimit;
        this.idleTimeout = idleTimeout;
        this.maxSize = maxSize;
        this.hook = hook;
        this.connectionProvider = connectionProvider;
        this.afterAcquire = afterAcquire;
        this.beforeRecycle = beforeRecycle;
        if (eventLoopSize > 0) {
            final EventLoop[] loops = new EventLoop[eventLoopSize];
            for (int i = 0; i < eventLoopSize; ++i) {
                loops[i] = vertx.nettyEventLoopGroup().next();
            }
            this.pool.contextProvider((Function)new Function<ContextInternal, EventLoopContext>(){
                int idx = 0;

                @Override
                public EventLoopContext apply(ContextInternal contextInternal) {
                    EventLoop loop = loops[this.idx++];
                    if (this.idx == loops.length) {
                        this.idx = 0;
                    }
                    return vertx.createEventLoopContext(loop, null, Thread.currentThread().getContextClassLoader());
                }
            });
        }
    }

    public int available() {
        return this.maxSize - this.pool.size();
    }

    public int size() {
        return this.pool.size();
    }

    public void checkExpired() {
        long now = System.currentTimeMillis();
        this.pool.evict(conn -> conn.expirationTimestamp < now, ar -> {
            if (ar.succeeded()) {
                List res = (List)ar.result();
                for (PooledConnection conn : res) {
                    conn.close((Promise<Void>)Promise.promise());
                }
            }
        });
    }

    public <R> Future<R> execute(ContextInternal context, CommandBase<R> cmd) {
        PromiseInternal p = context.promise();
        this.pool.acquire(context, 0, (Handler)p);
        return p.future().compose(lease -> {
            PooledConnection pooled = (PooledConnection)lease.get();
            Future future = this.afterAcquire != null ? this.afterAcquire.apply(pooled.conn).compose(v -> pooled.schedule(context, cmd)).eventually(v -> this.beforeRecycle.apply(pooled.conn)) : pooled.schedule(context, cmd);
            return future.onComplete(v -> {
                pooled.expirationTimestamp = System.currentTimeMillis() + this.idleTimeout;
                lease.recycle();
            });
        });
    }

    public void acquire(final ContextInternal context, final long timeout, final Handler<AsyncResult<PooledConnection>> handler) {
        class PoolRequest
        implements PoolWaiter.Listener<PooledConnection>,
        Handler<AsyncResult<Lease<PooledConnection>>> {
            private long timerID = -1L;

            PoolRequest() {
            }

            public void handle(AsyncResult<Lease<PooledConnection>> ar) {
                if (this.timerID != -1L) {
                    SqlConnectionPool.this.vertx.cancelTimer(this.timerID);
                }
                if (ar.succeeded()) {
                    Lease lease = (Lease)ar.result();
                    if (SqlConnectionPool.this.afterAcquire != null) {
                        ((Future)SqlConnectionPool.this.afterAcquire.apply(((PooledConnection)lease.get()).conn)).onComplete(ar2 -> {
                            if (ar2.succeeded()) {
                                this.handle((Lease<PooledConnection>)lease);
                            } else {
                                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                            }
                        });
                    } else {
                        this.handle((Lease<PooledConnection>)lease);
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }

            private void handle(Lease<PooledConnection> lease) {
                PooledConnection pooled = (PooledConnection)lease.get();
                pooled.lease = lease;
                handler.handle((Object)Future.succeededFuture((Object)pooled));
            }

            public void onEnqueue(PoolWaiter<PooledConnection> waiter) {
                if (timeout > 0L && this.timerID == -1L) {
                    this.timerID = context.setTimer(timeout, id -> SqlConnectionPool.this.pool.cancel(waiter, ar -> {
                        if (ar.succeeded() && ((Boolean)ar.result()).booleanValue()) {
                            handler.handle((Object)Future.failedFuture((String)"Timeout"));
                        }
                    }));
                }
            }

            public void onConnect(PoolWaiter<PooledConnection> waiter) {
                this.onEnqueue(waiter);
            }
        }
        PoolRequest request = new PoolRequest();
        this.pool.acquire(context, (PoolWaiter.Listener)request, 0, (Handler)request);
    }

    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.pool.close(arg_0 -> SqlConnectionPool.lambda$close$6((Promise)promise, arg_0));
        return promise.future();
    }

    private static /* synthetic */ void lambda$close$6(Promise promise, AsyncResult ar) {
        promise.complete();
    }

    public class PooledConnection
    implements Connection,
    Connection.Holder {
        private final ConnectionFactory factory;
        private final Connection conn;
        private final PoolConnector.Listener listener;
        private Connection.Holder holder;
        private Handler<AsyncResult<ConnectResult<PooledConnection>>> poolResultHandler;
        private Lease<PooledConnection> lease;
        public long expirationTimestamp;

        PooledConnection(ConnectionFactory factory, Connection conn, PoolConnector.Listener listener) {
            this.factory = factory;
            this.conn = conn;
            this.listener = listener;
        }

        public ConnectionFactory factory() {
            return this.factory;
        }

        @Override
        public SocketAddress server() {
            return this.conn.server();
        }

        @Override
        public boolean isSsl() {
            return this.conn.isSsl();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public DatabaseMetadata getDatabaseMetaData() {
            return this.conn.getDatabaseMetaData();
        }

        @Override
        public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
            return this.conn.schedule(context, cmd);
        }

        private void close(Promise<Void> promise) {
            this.conn.close(this, promise);
        }

        @Override
        public void init(Connection.Holder holder) {
            if (this.holder != null) {
                throw new IllegalStateException();
            }
            this.holder = holder;
        }

        @Override
        public void close(Connection.Holder holder, Promise<Void> promise) {
            this.doClose(holder, promise);
        }

        private void doClose(Connection.Holder holder, Promise<Void> promise) {
            if (holder != this.holder) {
                String msg = this.holder == null ? "Connection released twice" : "Connection released by " + holder + " owned by " + this.holder;
                promise.fail(msg);
            } else {
                this.holder = null;
                Handler<AsyncResult<ConnectResult<PooledConnection>>> resultHandler = this.poolResultHandler;
                if (resultHandler != null) {
                    this.poolResultHandler = null;
                    promise.complete();
                    resultHandler.handle((Object)Future.succeededFuture((Object)new ConnectResult((Object)this, (long)SqlConnectionPool.this.pipeliningLimit, 0L)));
                    return;
                }
                if (SqlConnectionPool.this.beforeRecycle == null) {
                    this.cleanup(promise);
                } else {
                    ((Future)SqlConnectionPool.this.beforeRecycle.apply(((PooledConnection)this.lease.get()).conn)).onComplete(ar -> this.cleanup(promise));
                }
            }
        }

        private void cleanup(Promise<Void> promise) {
            Lease<PooledConnection> l = this.lease;
            this.lease = null;
            this.expirationTimestamp = System.currentTimeMillis() + SqlConnectionPool.this.idleTimeout;
            l.recycle();
            promise.complete();
        }

        @Override
        public void handleClosed() {
            Handler<AsyncResult<ConnectResult<PooledConnection>>> resultHandler;
            if (this.holder != null) {
                this.holder.handleClosed();
            }
            if ((resultHandler = this.poolResultHandler) != null) {
                this.poolResultHandler = null;
                resultHandler.handle((Object)Future.failedFuture((Throwable)ConnectionBase.CLOSED_EXCEPTION));
            }
            this.listener.onRemove();
        }

        @Override
        public void handleEvent(Object event) {
            if (this.holder != null) {
                this.holder.handleEvent(event);
            }
        }

        @Override
        public void handleException(Throwable err) {
            if (this.holder != null) {
                this.holder.handleException(err);
            }
        }

        @Override
        public int getProcessId() {
            return this.conn.getProcessId();
        }

        @Override
        public int getSecretKey() {
            return this.conn.getSecretKey();
        }

        @Override
        public Connection unwrap() {
            return this.conn;
        }
    }
}

