/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.netty.buffer.ByteBuf;
import io.vertx.sqlclient.Row;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

public abstract class RowDecoder<C, R> {
    private final Collector<Row, C, R> collector;
    private BiConsumer<C, Row> accumulator;
    private int size;
    private C container;
    private Throwable failure;
    private R result;

    protected RowDecoder(Collector<Row, C, R> collector) {
        this.collector = collector;
        this.reset();
    }

    public int size() {
        return this.size;
    }

    protected abstract Row decodeRow(int var1, ByteBuf var2);

    public void handleRow(int len, ByteBuf in) {
        if (this.failure != null) {
            return;
        }
        Row row = this.decodeRow(len, in);
        if (this.accumulator == null) {
            try {
                this.accumulator = this.collector.accumulator();
            }
            catch (Exception e) {
                this.failure = e;
                return;
            }
        }
        try {
            this.accumulator.accept(this.container, row);
        }
        catch (Exception e) {
            this.failure = e;
            return;
        }
        ++this.size;
    }

    public R result() {
        return this.result;
    }

    public Throwable complete() {
        try {
            this.result = this.collector.finisher().apply(this.container);
        }
        catch (Exception e) {
            this.failure = e;
        }
        return this.failure;
    }

    public void reset() {
        this.size = 0;
        this.failure = null;
        this.result = null;
        try {
            this.container = this.collector.supplier().get();
        }
        catch (Exception e) {
            this.failure = e;
        }
    }
}

