/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import java.util.HashMap;
import java.util.function.Function;

class QueryResultBuilder<T, R extends SqlResultBase<T>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Promise<Boolean> {
    private final Promise<L> handler;
    private final Function<T, R> factory;
    private final ContextInternal context;
    private final QueryTracer tracer;
    private final Object tracingPayload;
    private final ClientMetrics metrics;
    private final Object metric;
    private R first;
    private R current;
    private Throwable failure;
    private boolean suspended;

    QueryResultBuilder(Function<T, R> factory, QueryTracer tracer, Object tracingPayload, ClientMetrics metrics, Object metric, PromiseInternal<L> handler) {
        this.factory = factory;
        this.context = handler.context();
        this.tracer = tracer;
        this.tracingPayload = tracingPayload;
        this.metrics = metrics;
        this.metric = metric;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result, Throwable failure) {
        if (failure != null) {
            this.failure = failure;
        } else {
            SqlResultBase r = (SqlResultBase)this.factory.apply(result);
            r.updated = updatedCount;
            r.size = size;
            r.columnNames = desc != null ? desc.columnNames() : null;
            r.columnDescriptors = desc != null ? desc.columnDescriptor() : null;
            this.handleResult(r);
        }
    }

    private void handleResult(R result) {
        R c = this.current;
        if (c == null) {
            this.first = result;
            this.current = result;
        } else {
            ((SqlResultBase)c).next = result;
            this.current = result;
        }
    }

    @Override
    public <V> void addProperty(PropertyKind<V> property, V value) {
        R r = this.current;
        if (r != null) {
            if (((SqlResultBase)r).properties == null) {
                ((SqlResultBase)r).properties = new HashMap();
            }
            ((SqlResultBase)r).properties.put(property, value);
        }
    }

    public boolean tryComplete(Boolean result) {
        this.suspended = result;
        if (this.failure != null) {
            return this.tryFail(this.failure);
        }
        boolean completed = this.handler.tryComplete(this.first);
        if (completed) {
            if (this.metrics != null) {
                this.metrics.responseBegin(this.metric, null);
                this.metrics.responseEnd(this.metric);
            }
            if (this.tracer != null) {
                this.tracer.receiveResponse(this.context, this.tracingPayload, this.first, null);
            }
        }
        return completed;
    }

    public boolean tryFail(Throwable cause) {
        boolean completed = this.handler.tryFail(cause);
        if (completed) {
            if (this.tracer != null) {
                this.tracer.receiveResponse(this.context, this.tracingPayload, null, cause);
            }
            if (this.metrics != null) {
                this.metrics.requestReset(this.metric);
            }
        }
        return completed;
    }

    public Future<Boolean> future() {
        return this.handler.future().map(l -> this.isSuspended());
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

