/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.reactivex.rxjava3.core.Completable;
import io.vertx.rxjava3.core.AbstractVerticle;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class VerticleTest
extends VertxTestBase {
    private static final RuntimeException err = new RuntimeException();
    private static volatile int startedCount;
    private static volatile int stoppedCount;
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
        startedCount = 0;
        stoppedCount = 0;
    }

    @Test
    public void testStart() {
        this.vertx.deployVerticle(StartVerticle.class.getName()).subscribe(id -> this.vertx.undeploy(id).subscribe(() -> ((VerticleTest)this).testComplete(), arg_0 -> ((VerticleTest)this).fail(arg_0)), arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    @Test
    public void testStartWithFailure() {
        this.vertx.deployVerticle(StartVerticleWithFailure.class.getName()).subscribe(id -> this.fail(), t -> {
            this.assertEquals(t, err);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testStartWithError() {
        this.vertx.deployVerticle(StartVerticleWithError.class.getName()).subscribe(id -> this.fail(), t -> {
            this.assertEquals(t, err);
            this.testComplete();
        });
        this.await();
    }

    @Test
    public void testStartSynchronously() {
        this.vertx.deployVerticle(StartVerticleSynchronously.class.getName()).subscribe(id -> {
            this.assertEquals(1L, startedCount);
            this.vertx.undeploy(id).subscribe(() -> ((VerticleTest)this).testComplete(), arg_0 -> ((VerticleTest)this).fail(arg_0));
        }, arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    @Test
    public void testStop() {
        this.vertx.deployVerticle(StopVerticle.class.getName()).subscribe(id -> this.vertx.undeploy(id).subscribe(() -> this.testComplete(), arg_0 -> ((VerticleTest)this).fail(arg_0)), arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    @Test
    public void testStopWithFailure() {
        this.vertx.deployVerticle(StopVerticleWithFailure.class.getName()).subscribe(id -> this.vertx.undeploy(id).subscribe(() -> this.fail(), t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }), arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    @Test
    public void testStopWithError() {
        this.vertx.deployVerticle(StopVerticleWithError.class.getName()).subscribe(id -> this.vertx.undeploy(id).subscribe(() -> this.fail(), t -> {
            this.assertEquals(t, err);
            this.testComplete();
        }), arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    @Test
    public void testStopSynchronously() {
        this.vertx.deployVerticle(StopVerticleSynchronously.class.getName()).subscribe(id -> this.vertx.undeploy(id).subscribe(() -> {
            this.assertEquals(1L, stoppedCount);
            this.testComplete();
        }, arg_0 -> ((VerticleTest)this).fail(arg_0)), arg_0 -> ((VerticleTest)this).fail(arg_0));
        this.await();
    }

    public static class StopVerticleSynchronously
    extends AbstractVerticle {
        public void stop() {
            stoppedCount++;
        }
    }

    public static class StopVerticleWithError
    extends AbstractVerticle {
        public Completable rxStop() {
            return Completable.error((Throwable)err);
        }
    }

    public static class StopVerticleWithFailure
    extends AbstractVerticle {
        public Completable rxStop() {
            throw err;
        }
    }

    public static class StopVerticle
    extends AbstractVerticle {
        public Completable rxStop() {
            return Completable.complete();
        }
    }

    public static class StartVerticleSynchronously
    extends AbstractVerticle {
        public void start() {
            startedCount++;
        }
    }

    public static class StartVerticleWithError
    extends AbstractVerticle {
        public Completable rxStart() {
            return Completable.error((Throwable)err);
        }
    }

    public static class StartVerticleWithFailure
    extends AbstractVerticle {
        public Completable rxStart() {
            throw err;
        }
    }

    public static class StartVerticle
    extends AbstractVerticle {
        public Completable rxStart() {
            return Completable.complete();
        }
    }
}

