/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.it.WineAndCheese;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.core.http.HttpClient;
import io.vertx.rxjava3.core.http.HttpServer;
import io.vertx.rxjava3.ext.web.client.WebClient;
import io.vertx.rxjava3.ext.web.codec.BodyCodec;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class WebClientTest
extends VertxTestBase {
    private Vertx vertx;
    private WebClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGet() {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().setChunked(true).end("some_content").subscribe());
        try {
            server.listen().blockingGet();
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Single single = this.client.get(8080, "localhost", "/the_uri").as(BodyCodec.buffer()).send();
            for (int i = 0; i < times; ++i) {
                single.subscribe(resp -> {
                    Buffer body = (Buffer)resp.body();
                    this.assertEquals("some_content", body.toString("UTF-8"));
                    this.complete();
                }, arg_0 -> ((WebClientTest)this).fail(arg_0));
            }
            this.await();
        }
        finally {
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPost() {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.bodyHandler(buff -> {
            this.assertEquals("onetwothree", buff.toString());
            req.response().end().subscribe();
        }));
        try {
            server.listen().blockingGet();
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Observable stream = Observable.just((Object)Buffer.buffer((String)"one"), (Object)Buffer.buffer((String)"two"), (Object)Buffer.buffer((String)"three"));
            Single single = this.client.post(8080, "localhost", "/the_uri").sendStream(stream.toFlowable(BackpressureStrategy.BUFFER));
            for (int i = 0; i < times; ++i) {
                single.subscribe(resp -> this.complete(), arg_0 -> ((WebClientTest)this).fail(arg_0));
            }
            this.await();
        }
        finally {
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseMissingBody() throws Exception {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().setStatusCode(403).end().subscribe());
        try {
            server.listen().blockingGet();
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Single single = this.client.get(8080, "localhost", "/the_uri").send();
            for (int i = 0; i < times; ++i) {
                single.subscribe(resp -> {
                    this.assertEquals(403L, resp.statusCode());
                    this.assertNull(resp.body());
                    this.complete();
                }, arg_0 -> ((WebClientTest)this).fail(arg_0));
            }
            this.await();
        }
        finally {
            server.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseBodyAsAsJsonMapped() throws Exception {
        JsonObject expected = new JsonObject().put("cheese", (Object)"Goat Cheese").put("wine", (Object)"Condrieu");
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().end(expected.encode()).subscribe());
        try {
            server.listen().blockingGet();
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Single single = this.client.get(8080, "localhost", "/the_uri").as(BodyCodec.json(WineAndCheese.class)).send();
            single.subscribe(resp -> {
                this.assertEquals(200L, resp.statusCode());
                this.assertEquals(new WineAndCheese().setCheese("Goat Cheese").setWine("Condrieu"), resp.body());
                this.testComplete();
            }, arg_0 -> ((WebClientTest)this).fail(arg_0));
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testErrorHandling() throws Exception {
        try {
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Single single = this.client.get(-1, "localhost", "/the_uri").as(BodyCodec.json(WineAndCheese.class)).send();
            single.subscribe(resp -> this.fail(), error -> {
                this.assertEquals(IllegalArgumentException.class, error.getClass());
                this.testComplete();
            });
            this.await();
        }
        catch (Throwable t) {
            this.fail();
        }
    }
}

