/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it.discovery;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.it.discovery.ServiceDiscoveryTest;
import io.vertx.rxjava3.core.AbstractVerticle;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.eventbus.EventBus;
import io.vertx.rxjava3.core.eventbus.MessageConsumer;
import io.vertx.rxjava3.core.http.HttpClient;
import io.vertx.rxjava3.ext.mongo.MongoClient;
import io.vertx.rxjava3.ext.web.client.WebClient;
import io.vertx.rxjava3.it.discovery.service.HelloService;
import io.vertx.rxjava3.redis.client.Redis;
import io.vertx.rxjava3.servicediscovery.ServiceDiscovery;
import io.vertx.rxjava3.servicediscovery.ServiceReference;
import io.vertx.rxjava3.servicediscovery.types.EventBusService;
import io.vertx.rxjava3.servicediscovery.types.HttpEndpoint;
import io.vertx.rxjava3.servicediscovery.types.MessageSource;
import io.vertx.rxjava3.servicediscovery.types.MongoDataSource;
import io.vertx.rxjava3.servicediscovery.types.RedisDataSource;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;

public class MyRX2Verticle
extends AbstractVerticle {
    public void start() {
        ServiceDiscovery discovery = ServiceDiscovery.create((Vertx)this.vertx, (ServiceDiscoveryOptions)ServiceDiscoveryTest.DISCOVERY_OPTIONS);
        EventBus eb = this.vertx.eventBus();
        eb.consumer("http-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                HttpClient client = (HttpClient)reference.getAs(HttpClient.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("http-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service")).subscribe(client -> {
                result.put("client", (Object)client.getClass().toString());
                ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }, err -> message.fail(0, "FAIL - no service"));
        });
        eb.consumer("web-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-http-service")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                WebClient client = (WebClient)reference.getAs(WebClient.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("web-sugar", message -> {
            JsonObject result = new JsonObject();
            HttpEndpoint.getWebClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-http-service")).subscribe(client -> {
                result.put("client", (Object)client.getClass().toString());
                ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }, err -> message.fail(0, "FAIL - no service"));
        });
        eb.consumer("service-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-service")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                HelloService client = (HelloService)reference.getAs(HelloService.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("service-sugar", message -> {
            JsonObject result = new JsonObject();
            EventBusService.getServiceProxy((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-service"), HelloService.class, ar -> {
                if (ar.failed()) {
                    message.fail(0, "FAIL - no service");
                } else {
                    HelloService client = (HelloService)ar.result();
                    result.put("client", (Object)client.getClass().toString());
                    ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                    result.put("bindings", (Object)this.getBindings(discovery));
                    message.reply((Object)result);
                }
            });
        });
        eb.consumer("redis-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-redis-data-source")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                Redis client = (Redis)reference.getAs(Redis.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("redis-sugar", message -> {
            JsonObject result = new JsonObject();
            RedisDataSource.getRedisClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-redis-data-source")).subscribe(client -> {
                result.put("client", (Object)client.getClass().toString());
                ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }, err -> message.fail(0, "FAIL - no service"));
        });
        eb.consumer("mongo-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-mongo-data-source")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                MongoClient client = (MongoClient)reference.getAs(MongoClient.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("mongo-sugar", message -> {
            JsonObject result = new JsonObject();
            MongoDataSource.getMongoClient((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-mongo-data-source")).subscribe(client -> {
                result.put("client", (Object)client.getClass().toString());
                ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }, err -> message.fail(0, "FAIL - no service"));
        });
        eb.consumer("source1-ref", message -> discovery.getRecord(rec -> rec.getName().equalsIgnoreCase("my-message-source-1")).subscribe(res -> {
            JsonObject result = new JsonObject();
            ServiceReference reference = discovery.getReference(res);
            if (reference == null) {
                message.fail(0, "FAIL - reference is null");
            } else {
                MessageConsumer client = (MessageConsumer)reference.getAs(MessageConsumer.class);
                result.put("client", (Object)client.getClass().toString());
                reference.release();
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }
        }, err -> message.fail(0, "FAIL - No service")));
        eb.consumer("source1-sugar", message -> {
            JsonObject result = new JsonObject();
            MessageSource.getConsumer((ServiceDiscovery)discovery, record -> record.getName().equalsIgnoreCase("my-message-source-1")).subscribe(client -> {
                result.put("client", (Object)client.getClass().toString());
                ServiceDiscovery.releaseServiceObject((ServiceDiscovery)discovery, (Object)client);
                result.put("bindings", (Object)this.getBindings(discovery));
                message.reply((Object)result);
            }, err -> message.fail(0, "FAIL - no service"));
        });
    }

    private synchronized JsonArray getBindings(ServiceDiscovery discovery) {
        JsonArray array = new JsonArray();
        for (ServiceReference ref : discovery.bindings()) {
            array.add((Object)ref.toString());
        }
        return array;
    }
}

