/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.reactivex.rxjava3.core.Flowable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.impl.Utils;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.file.AsyncFile;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermissions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CoreTest
extends VertxTestBase {
    private static final String DEFAULT_FILE_PERMS = "rw-r--r--";
    private Vertx vertx;
    private String pathSep;
    private String testDir;
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
        FileSystem fs = FileSystems.getDefault();
        this.pathSep = fs.getSeparator();
        File ftestDir = this.testFolder.newFolder();
        this.testDir = ftestDir.toString();
    }

    @Test
    public void testAsyncFile() throws Exception {
        String fileName = "some-file.dat";
        int chunkSize = 1000;
        int chunks = 10;
        byte[] expected = TestUtils.randomAlphaString((int)(chunkSize * chunks)).getBytes();
        this.createFile(fileName, expected);
        AsyncFile file = (AsyncFile)this.vertx.fileSystem().open(this.testDir + this.pathSep + fileName, new OpenOptions()).blockingGet();
        this.subscribe(expected, file, 3);
        this.await();
    }

    private void subscribe(byte[] expected, AsyncFile file, int times) {
        file.setReadPos(0L);
        Flowable flowable = file.toFlowable().map(io.vertx.rxjava3.core.buffer.Buffer::getDelegate);
        Buffer actual = Buffer.buffer();
        flowable.subscribe(arg_0 -> ((Buffer)actual).appendBuffer(arg_0), arg_0 -> ((CoreTest)this).fail(arg_0), () -> {
            this.assertEquals(Buffer.buffer((byte[])expected), actual);
            if (times > 0) {
                this.subscribe(expected, file, times - 1);
            } else {
                this.testComplete();
            }
        });
    }

    private void createFile(String fileName, byte[] bytes) throws Exception {
        File file = new File(this.testDir, fileName);
        Path path = Paths.get(file.getCanonicalPath(), new String[0]);
        Files.write(path, bytes, new OpenOption[0]);
        this.setDefaultPerms(path);
    }

    private void setDefaultPerms(Path path) {
        if (!Utils.isWindows()) {
            try {
                Files.setPosixFilePermissions(path, PosixFilePermissions.fromString(DEFAULT_FILE_PERMS));
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

