/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.sqlclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A prepared statement, the statement is pre-compiled and it's more efficient to execute the statement for multiple times.
 * In addition, this kind of statement provides protection against SQL injection attacks.
 *
 * <p>From a prepared statement you can
 *
 * <ul>
 *   <li>use {@link io.vertx.rxjava3.sqlclient.PreparedStatement#query} to create and execute a {@link io.vertx.rxjava3.sqlclient.PreparedQuery}</li>
 *   <li>use {@link io.vertx.rxjava3.sqlclient.PreparedStatement#cursor} to create a {@link io.vertx.rxjava3.sqlclient.Cursor}</li>
 *   <li>use {@link io.vertx.rxjava3.sqlclient.PreparedStatement#createStream} to create a {@link io.vertx.rxjava3.sqlclient.RowStream}</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedStatement original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.PreparedStatement.class)
public class PreparedStatement {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedStatement that = (PreparedStatement) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PreparedStatement> __TYPE_ARG = new TypeArg<>(    obj -> new PreparedStatement((io.vertx.sqlclient.PreparedStatement) obj),
    PreparedStatement::getDelegate
  );

  private final io.vertx.sqlclient.PreparedStatement delegate;
  
  public PreparedStatement(io.vertx.sqlclient.PreparedStatement delegate) {
    this.delegate = delegate;
  }

  public PreparedStatement(Object delegate) {
    this.delegate = (io.vertx.sqlclient.PreparedStatement)delegate;
  }

  public io.vertx.sqlclient.PreparedStatement getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>>(o1 -> io.vertx.rxjava3.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava3.sqlclient.Row>(o2 -> io.vertx.rxjava3.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.sqlclient.Row> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava3.sqlclient.Row>(o1 -> io.vertx.rxjava3.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.sqlclient.Row> TYPE_ARG_2 = new TypeArg<io.vertx.rxjava3.sqlclient.Row>(o1 -> io.vertx.rxjava3.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o1), o1 -> o1.getDelegate());

  /**
   * Create a prepared query for this statement.
   * @return the prepared query
   */
  public io.vertx.rxjava3.sqlclient.PreparedQuery<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> query() { 
    io.vertx.rxjava3.sqlclient.PreparedQuery<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> ret = io.vertx.rxjava3.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.query(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.sqlclient.PreparedStatement#cursor} but with empty arguments.
   * @return 
   */
  public io.vertx.rxjava3.sqlclient.Cursor cursor() { 
    io.vertx.rxjava3.sqlclient.Cursor ret = io.vertx.rxjava3.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor());
    return ret;
  }

  /**
   * Create a cursor with the provided <code>arguments</code>.
   * @param args the list of arguments
   * @return the query
   */
  public io.vertx.rxjava3.sqlclient.Cursor cursor(io.vertx.rxjava3.sqlclient.Tuple args) { 
    io.vertx.rxjava3.sqlclient.Cursor ret = io.vertx.rxjava3.sqlclient.Cursor.newInstance((io.vertx.sqlclient.Cursor)delegate.cursor(args.getDelegate()));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.sqlclient.PreparedStatement#createStream} but with empty arguments.
   * @param fetch 
   * @return 
   */
  public io.vertx.rxjava3.sqlclient.RowStream<io.vertx.rxjava3.sqlclient.Row> createStream(int fetch) { 
    io.vertx.rxjava3.sqlclient.RowStream<io.vertx.rxjava3.sqlclient.Row> ret = io.vertx.rxjava3.sqlclient.RowStream.newInstance((io.vertx.sqlclient.RowStream)delegate.createStream(fetch), TYPE_ARG_1);
    return ret;
  }

  /**
   * Execute the prepared query with a cursor and createStream the result. The createStream opens a cursor
   * with a <code>fetch</code> size to fetch the results.
   * <p/>
   * Note: this requires to be in a transaction, since cursors require it.
   * @param fetch the cursor fetch size
   * @param args the prepared query arguments
   * @return the createStream
   */
  public io.vertx.rxjava3.sqlclient.RowStream<io.vertx.rxjava3.sqlclient.Row> createStream(int fetch, io.vertx.rxjava3.sqlclient.Tuple args) { 
    io.vertx.rxjava3.sqlclient.RowStream<io.vertx.rxjava3.sqlclient.Row> ret = io.vertx.rxjava3.sqlclient.RowStream.newInstance((io.vertx.sqlclient.RowStream)delegate.createStream(fetch, args.getDelegate()), TYPE_ARG_2);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.sqlclient.PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.sqlclient.PreparedStatement#close} but notifies the <code>completionHandler</code> when it's closed.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  public static PreparedStatement newInstance(io.vertx.sqlclient.PreparedStatement arg) {
    return arg != null ? new PreparedStatement(arg) : null;
  }

}
