/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.redis.client;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <b>Auto generated</b> Redis API client wrapper.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.client.RedisAPI original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.client.RedisAPI.class)
public class RedisAPI {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisAPI that = (RedisAPI) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisAPI> __TYPE_ARG = new TypeArg<>(    obj -> new RedisAPI((io.vertx.redis.client.RedisAPI) obj),
    RedisAPI::getDelegate
  );

  private final io.vertx.redis.client.RedisAPI delegate;
  
  public RedisAPI(io.vertx.redis.client.RedisAPI delegate) {
    this.delegate = delegate;
  }

  public RedisAPI(Object delegate) {
    this.delegate = (io.vertx.redis.client.RedisAPI)delegate;
  }

  public io.vertx.redis.client.RedisAPI getDelegate() {
    return delegate;
  }

  public void close() { 
    delegate.close();
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> acl(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAcl(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/acl">acl</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAcl(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.acl(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> append(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAppend(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/append">append</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAppend(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.append(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> asking() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAsking();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/asking">asking</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAsking() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.asking(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> auth(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxAuth(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/auth">auth</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxAuth(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.auth(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgrewriteaof() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgrewriteaof();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgrewriteaof">bgrewriteaof</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgrewriteaof() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgrewriteaof(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bgsave(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBgsave(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bgsave">bgsave</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBgsave(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bgsave(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitcount">bitcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfield(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfield(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield">bitfield</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfield(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfield(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitfieldRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitfieldRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitfield_ro">bitfieldRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitfieldRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitfieldRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitop">bitop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bitpos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBitpos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bitpos">bitpos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBitpos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bitpos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> blpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBlpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/blpop">blpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBlpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.blpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpop">brpop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> brpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBrpoplpush(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/brpoplpush">brpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBrpoplpush(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.brpoplpush(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmax">bzpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> bzpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxBzpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/bzpopmin">bzpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxBzpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.bzpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> client(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxClient(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/client">client</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxClient(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.client(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> cluster(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCluster(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/cluster">cluster</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCluster(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.cluster(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> command(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxCommand(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/command">command</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxCommand(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.command(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> config(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxConfig(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/config">config</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxConfig(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.config(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dbsize() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDbsize();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dbsize">dbsize</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDbsize() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dbsize(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> debug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/debug">debug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.debug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decr">decr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> decrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDecrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/decrby">decrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDecrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.decrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> del(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/del">del</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.del(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> discard() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDiscard();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/discard">discard</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDiscard() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.discard(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> dump(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxDump(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/dump">dump</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxDump(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.dump(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> echo(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEcho(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/echo">echo</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEcho(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.echo(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> eval(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEval(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/eval">eval</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEval(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.eval(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> evalsha(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxEvalsha(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/evalsha">evalsha</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxEvalsha(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.evalsha(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exec() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExec();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exec">exec</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExec() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exec(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> exists(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExists(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/exists">exists</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExists(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.exists(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expire(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpire(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expire">expire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpire(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> expireat(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxExpireat(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/expireat">expireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxExpireat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.expireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushall(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushall(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushall">flushall</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushall(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushall(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> flushdb(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxFlushdb(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/flushdb">flushdb</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxFlushdb(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.flushdb(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geoadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geoadd">geoadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geoadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geodist(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeodist(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geodist">geodist</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeodist(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geodist(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geohash(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeohash(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geohash">geohash</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeohash(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geohash(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> geopos(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeopos(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/geopos">geopos</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeopos(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.geopos(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadius(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradius(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius">georadius</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradius(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadius(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadius_ro">georadiusRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember">georadiusbymember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> georadiusbymemberRo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGeoradiusbymemberRo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/georadiusbymember_ro">georadiusbymemberRo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGeoradiusbymemberRo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.georadiusbymemberRo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> get(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGet(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/get">get</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGet(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.get(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getbit(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetbit(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getbit">getbit</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetbit(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getbit(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getrange">getrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> getset(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxGetset(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/getset">getset</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxGetset(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.getset(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hdel">hdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hello(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHello(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hello">hello</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHello(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hello(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hexists(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHexists(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hexists">hexists</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHexists(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hexists(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hget(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHget(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hget">hget</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHget(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hget(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hgetall(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHgetall(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hgetall">hgetall</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHgetall(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hgetall(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrby">hincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHincrbyfloat(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hincrbyfloat">hincrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHincrbyfloat(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hincrbyfloat(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hkeys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHkeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hkeys">hkeys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHkeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hkeys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hlen">hlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmget">hmget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hmset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHmset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hmset">hmset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHmset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hmset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> host(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHost(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/host:">host</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHost(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.host(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hscan">hscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hset">hset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHsetnx(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hsetnx">hsetnx</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHsetnx(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hsetnx(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hstrlen(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHstrlen(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hstrlen">hstrlen</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHstrlen(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hstrlen(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> hvals(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxHvals(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/hvals">hvals</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxHvals(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.hvals(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incr(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncr(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incr">incr</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncr(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incr(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrby(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrby(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrby">incrby</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrby(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrby(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> incrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxIncrbyfloat(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/incrbyfloat">incrbyfloat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxIncrbyfloat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.incrbyfloat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> info(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxInfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/info">info</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxInfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.info(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> keys(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxKeys(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/keys">keys</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxKeys(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.keys(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lastsave() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLastsave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lastsave">lastsave</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLastsave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lastsave(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> latency(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLatency(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/latency">latency</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLatency(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.latency(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lindex(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLindex(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lindex">lindex</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLindex(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lindex(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> linsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLinsert(arg0, arg1, arg2, arg3);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/linsert">linsert</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @param arg3 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLinsert(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2, java.lang.String arg3) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.linsert(arg0, arg1, arg2, arg3, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> llen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/llen">llen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.llen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lolwut(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLolwut(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lolwut">lolwut</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLolwut(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lolwut(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpop(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpop(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpop">lpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpop(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpush">lpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lpushx">lpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrange">lrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLrem(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lrem">lrem</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLrem(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lrem(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> lset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLset(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/lset">lset</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLset(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.lset(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ltrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxLtrim(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ltrim">ltrim</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxLtrim(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ltrim(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> memory(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMemory(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/memory">memory</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMemory(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.memory(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mget(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMget(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mget">mget</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMget(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mget(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> migrate(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMigrate(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/migrate">migrate</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMigrate(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.migrate(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> module(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxModule(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/module">module</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxModule(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.module(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> monitor() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMonitor();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/monitor">monitor</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMonitor() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.monitor(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> move(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMove(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/move">move</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMove(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.move(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> mset(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMset(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/mset">mset</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMset(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.mset(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> msetnx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMsetnx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/msetnx">msetnx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMsetnx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.msetnx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> multi() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxMulti();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/multi">multi</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxMulti() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.multi(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> object(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxObject(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/object">object</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxObject(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.object(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> persist(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPersist(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/persist">persist</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPersist(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.persist(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpire(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpire(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpire">pexpire</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpire(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpire(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pexpireat(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPexpireat(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pexpireat">pexpireat</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPexpireat(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pexpireat(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfadd">pfadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfcount(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfcount(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfcount">pfcount</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfcount(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfcount(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfdebug(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfdebug(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfdebug">pfdebug</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfdebug(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfdebug(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfmerge(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfmerge(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfmerge">pfmerge</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfmerge(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfmerge(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pfselftest() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPfselftest();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pfselftest">pfselftest</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPfselftest() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pfselftest(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ping(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPing(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ping">ping</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPing(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ping(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> post(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPost(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/post">post</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPost(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.post(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psetex">psetex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psetex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psubscribe">psubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> psync(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPsync(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/psync">psync</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPsync(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.psync(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPttl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pttl">pttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPttl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> publish(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPublish(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/publish">publish</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPublish(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.publish(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> pubsub(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPubsub(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/pubsub">pubsub</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPubsub(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.pubsub(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> punsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxPunsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/punsubscribe">punsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxPunsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.punsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> randomkey() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRandomkey();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/randomkey">randomkey</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRandomkey() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.randomkey(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readonly() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadonly();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readonly">readonly</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadonly() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readonly(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> readwrite() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReadwrite();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/readwrite">readwrite</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReadwrite() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.readwrite(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rename(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRename(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rename">rename</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRename(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rename(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> renamenx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRenamenx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/renamenx">renamenx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRenamenx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.renamenx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replconf(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplconf(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replconf">replconf</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplconf(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replconf(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> replicaof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxReplicaof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/replicaof">replicaof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxReplicaof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.replicaof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore">restore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> restoreAsking(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRestoreAsking(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/restore-asking">restoreAsking</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRestoreAsking(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.restoreAsking(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> role() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRole();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/role">role</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRole() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.role(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpop(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpop(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpop">rpop</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpop(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpop(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpoplpush(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpoplpush">rpoplpush</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpoplpush(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpoplpush(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpush(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpush(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpush">rpush</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpush(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpush(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rpushx(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxRpushx(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/rpushx">rpushx</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxRpushx(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.rpushx(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sadd">sadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> save() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSave();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/save">save</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSave() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.save(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scan">scan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> scard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/scard">scard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.scard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> script(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxScript(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/script">script</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxScript(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.script(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiff(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiff(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiff">sdiff</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiff(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiff(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sdiffstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSdiffstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sdiffstore">sdiffstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSdiffstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sdiffstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> select(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSelect(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/select">select</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSelect(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.select(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> set(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSet(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/set">set</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSet(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.set(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetbit(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setbit">setbit</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetbit(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setbit(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setex">setex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setnx(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetnx(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setnx">setnx</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetnx(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setnx(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> setrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSetrange(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/setrange">setrange</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSetrange(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.setrange(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> shutdown(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxShutdown(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/shutdown">shutdown</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxShutdown(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.shutdown(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinter(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinter(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinter">sinter</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinter(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinter(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sinterstore">sinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sismember(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSismember(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sismember">sismember</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSismember(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sismember(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slaveof(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlaveof(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slaveof">slaveof</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlaveof(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slaveof(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> slowlog(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSlowlog(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/slowlog">slowlog</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSlowlog(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.slowlog(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smembers(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmembers(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smembers">smembers</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmembers(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smembers(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> smove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSmove(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/smove">smove</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSmove(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.smove(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sort(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSort(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sort">sort</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSort(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sort(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> spop(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSpop(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/spop">spop</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSpop(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.spop(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srandmember(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrandmember(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srandmember">srandmember</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrandmember(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srandmember(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> srem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/srem">srem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.srem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sscan">sscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> stralgo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxStralgo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/stralgo">stralgo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxStralgo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.stralgo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> strlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxStrlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/strlen">strlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxStrlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.strlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> subscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/subscribe">subscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.subscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> substr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSubstr(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/substr">substr</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSubstr(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.substr(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunion(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunion(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunion">sunion</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunion(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunion(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sunionstore">sunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> swapdb(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSwapdb(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/swapdb">swapdb</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSwapdb(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.swapdb(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> sync() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxSync();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/sync">sync</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxSync() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.sync(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> time() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTime();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/time">time</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTime() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.time(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> touch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTouch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/touch">touch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTouch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.touch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ttl(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxTtl(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/ttl">ttl</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxTtl(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.ttl(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> type(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxType(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/type">type</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxType(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.type(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unlink(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnlink(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unlink">unlink</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnlink(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unlink(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unsubscribe(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnsubscribe(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unsubscribe">unsubscribe</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnsubscribe(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unsubscribe(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> unwatch() { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxUnwatch();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/unwatch">unwatch</a>.
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxUnwatch() { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.unwatch(new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> wait(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWait(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/wait">wait</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWait(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.wait(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> watch(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxWatch(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/watch">watch</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxWatch(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.watch(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xack(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXack(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xack">xack</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXack(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xack(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xadd">xadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xclaim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXclaim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xclaim">xclaim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXclaim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xclaim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xdel(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXdel(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xdel">xdel</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXdel(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xdel(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xgroup">xgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xinfo(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXinfo(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xinfo">xinfo</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXinfo(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xinfo(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xlen(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXlen(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xlen">xlen</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXlen(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xlen(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xpending(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXpending(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xpending">xpending</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXpending(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xpending(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrange">xrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xread(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXread(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xread">xread</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXread(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xread(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xreadgroup(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXreadgroup(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xreadgroup">xreadgroup</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXreadgroup(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xreadgroup(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xrevrange">xrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xsetid(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXsetid(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xsetid">xsetid</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXsetid(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xsetid(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> xtrim(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxXtrim(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/xtrim">xtrim</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxXtrim(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.xtrim(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zadd(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZadd(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zadd">zadd</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZadd(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zadd(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcard(java.lang.String arg0) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcard(arg0);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcard">zcard</a>.
   * @param arg0 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcard(java.lang.String arg0) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcard(arg0, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zcount">zcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZincrby(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zincrby">zincrby</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZincrby(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zincrby(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zinterstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZinterstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zinterstore">zinterstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZinterstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zinterstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZlexcount(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zlexcount">zlexcount</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZlexcount(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zlexcount(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmax(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmax(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmax">zpopmax</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmax(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmax(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zpopmin(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZpopmin(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zpopmin">zpopmin</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZpopmin(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zpopmin(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrange">zrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebylex">zrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrangebyscore">zrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrank">zrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrem(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrem(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrem">zrem</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrem(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrem(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebylex(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebylex">zremrangebylex</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebylex(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebylex(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyrank(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyrank">zremrangebyrank</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyrank(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyrank(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZremrangebyscore(arg0, arg1, arg2);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zremrangebyscore">zremrangebyscore</a>.
   * @param arg0 
   * @param arg1 
   * @param arg2 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZremrangebyscore(java.lang.String arg0, java.lang.String arg1, java.lang.String arg2) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zremrangebyscore(arg0, arg1, arg2, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrange(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrange(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrange">zrevrange</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrange(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrange(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebylex(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebylex(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebylex">zrevrangebylex</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebylex(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebylex(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrangebyscore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrangebyscore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrangebyscore">zrevrangebyscore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrangebyscore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrangebyscore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zrevrank(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZrevrank(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zrevrank">zrevrank</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZrevrank(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zrevrank(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscan(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscan(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscan">zscan</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscan(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscan(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zscore(java.lang.String arg0, java.lang.String arg1) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZscore(arg0, arg1);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zscore">zscore</a>.
   * @param arg0 
   * @param arg1 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZscore(java.lang.String arg0, java.lang.String arg1) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zscore(arg0, arg1, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> zunionstore(java.util.List<java.lang.String> args) { 
    io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> ret = rxZunionstore(args);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.MaybeHelper.nullObserver());
    return ret;
  }

  /**
   * Redis command <a href="https://redis.io/commands/zunionstore">zunionstore</a>.
   * @param args 
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Maybe<io.vertx.rxjava3.redis.client.Response> rxZunionstore(java.util.List<java.lang.String> args) { 
    return AsyncResultMaybe.toMaybe( handler -> {
      delegate.zunionstore(args, new Handler<AsyncResult<io.vertx.redis.client.Response>>() {
      public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.redis.client.Response.newInstance((io.vertx.redis.client.Response)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.Redis client) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(client.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava3.redis.client.RedisAPI api(io.vertx.rxjava3.redis.client.RedisConnection connection) { 
    io.vertx.rxjava3.redis.client.RedisAPI ret = io.vertx.rxjava3.redis.client.RedisAPI.newInstance((io.vertx.redis.client.RedisAPI)io.vertx.redis.client.RedisAPI.api(connection.getDelegate()));
    return ret;
  }

  public static RedisAPI newInstance(io.vertx.redis.client.RedisAPI arg) {
    return arg != null ? new RedisAPI(arg) : null;
  }

}
