/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.httpproxy;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * Handles the interoperability of the <b>request</b> between the <i><b>user agent</b></i> and the <i><b>origin</b></i>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.httpproxy.ProxyRequest original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.httpproxy.ProxyRequest.class)
public class ProxyRequest {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProxyRequest that = (ProxyRequest) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ProxyRequest> __TYPE_ARG = new TypeArg<>(    obj -> new ProxyRequest((io.vertx.httpproxy.ProxyRequest) obj),
    ProxyRequest::getDelegate
  );

  private final io.vertx.httpproxy.ProxyRequest delegate;
  
  public ProxyRequest(io.vertx.httpproxy.ProxyRequest delegate) {
    this.delegate = delegate;
  }

  public ProxyRequest(Object delegate) {
    this.delegate = (io.vertx.httpproxy.ProxyRequest)delegate;
  }

  public io.vertx.httpproxy.ProxyRequest getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.httpproxy.ProxyResponse>(o1 -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)o1), o1 -> o1.getDelegate());

  /**
   * Create a new <code>ProxyRequest</code> instance, the outbound request will be paused.
   * @param outboundRequest the <code>HttpServerRequest</code> of the <i><b>user agent</b></i>
   * @return a reference to this, so the API can be used fluently
   */
  public static io.vertx.rxjava3.httpproxy.ProxyRequest reverseProxy(io.vertx.rxjava3.core.http.HttpServerRequest outboundRequest) { 
    io.vertx.rxjava3.httpproxy.ProxyRequest ret = io.vertx.rxjava3.httpproxy.ProxyRequest.newInstance((io.vertx.httpproxy.ProxyRequest)io.vertx.httpproxy.ProxyRequest.reverseProxy(outboundRequest.getDelegate()));
    return ret;
  }

  /**
   * @return the HTTP version of the outbound request
   */
  public io.vertx.core.http.HttpVersion version() { 
    io.vertx.core.http.HttpVersion ret = delegate.version();
    return ret;
  }

  /**
   * @return the absolute URI of the outbound request
   */
  public java.lang.String absoluteURI() { 
    java.lang.String ret = delegate.absoluteURI();
    return ret;
  }

  /**
   * @return the HTTP method to be sent to the <i><b>origin</b></i> server.
   */
  public io.vertx.core.http.HttpMethod getMethod() { 
    io.vertx.core.http.HttpMethod ret = delegate.getMethod();
    return ret;
  }

  /**
   * Set the HTTP method to be sent to the <i><b>origin</b></i> server.
   *
   * <p>The initial HTTP method value is the outbound request HTTP method.
   * @param method the new HTTP method
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest setMethod(io.vertx.core.http.HttpMethod method) { 
    delegate.setMethod(method);
    return this;
  }

  /**
   * @return the request URI to be sent to the <i><b>origin</b></i> server.
   */
  public java.lang.String getURI() { 
    java.lang.String ret = delegate.getURI();
    return ret;
  }

  /**
   * Set the request URI to be sent to the <i><b>origin</b></i> server.
   *
   * <p>The initial request URI value is the <i><b>outbound</b></i> request URI.
   * @param uri the new URI
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest setURI(java.lang.String uri) { 
    delegate.setURI(uri);
    return this;
  }

  /**
   * @return the request body to be sent to the <i><b>origin</b></i> server.
   */
  public io.vertx.rxjava3.httpproxy.Body getBody() { 
    io.vertx.rxjava3.httpproxy.Body ret = io.vertx.rxjava3.httpproxy.Body.newInstance((io.vertx.httpproxy.Body)delegate.getBody());
    return ret;
  }

  /**
   * Set the request body to be sent to the <i><b>origin</b></i> server.
   *
   * <p>The initial request body value is the <i><b>outbound</b></i> request body.
   * @param body the new body
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest setBody(io.vertx.rxjava3.httpproxy.Body body) { 
    delegate.setBody(body.getDelegate());
    return this;
  }

  /**
   * @return the headers that will be sent to the origin server, the returned headers can be modified. The headers map is populated with the outbound request headers
   */
  public io.vertx.rxjava3.core.MultiMap headers() { 
    io.vertx.rxjava3.core.MultiMap ret = io.vertx.rxjava3.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Set a body filter.
   *
   * <p> The body filter can rewrite the request body sent to the <i><b>origin</b></i> server.
   * @param filter the filter
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest bodyFilter(java.util.function.Function<io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.buffer.Buffer>,io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer>> filter) { 
    delegate.bodyFilter(new Function<io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer>,io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer>>() {
      public io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer> apply(io.vertx.core.streams.ReadStream<io.vertx.core.buffer.Buffer> arg) {
        io.reactivex.rxjava3.core.Flowable<io.vertx.rxjava3.core.buffer.Buffer> ret = filter.apply(io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)arg, new TypeArg<io.vertx.rxjava3.core.buffer.Buffer>(o0 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o0), o0 -> o0.getDelegate())));
        return io.vertx.rxjava3.impl.ReadStreamSubscriber.asReadStream(ret, obj -> obj.getDelegate()).resume();
      }
    });
    return this;
  }

  /**
   * Proxy this outbound request and response to the <i><b>origin</b></i> server using the specified inbound request.
   * @param inboundRequest the request connected to the <i><b>origin</b></i> server
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable proxy(io.vertx.rxjava3.core.http.HttpClientRequest inboundRequest) { 
    io.reactivex.rxjava3.core.Completable ret = rxProxy(inboundRequest);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Proxy this outbound request and response to the <i><b>origin</b></i> server using the specified inbound request.
   * @param inboundRequest the request connected to the <i><b>origin</b></i> server
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxProxy(io.vertx.rxjava3.core.http.HttpClientRequest inboundRequest) { 
    return AsyncResultCompletable.toCompletable(delegate.proxy(inboundRequest.getDelegate()));
  }

  /**
   * Send this request to the <i><b>origin</b></i> server using the specified inbound request.
   *
   * <p> The <code>completionHandler</code> will be called with the proxy response sent by the <i><b>origin</b></i>.
   * @param inboundRequest the request connected to the <i><b>origin</b></i> server
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> send(io.vertx.rxjava3.core.http.HttpClientRequest inboundRequest) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> ret = rxSend(inboundRequest);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Send this request to the <i><b>origin</b></i> server using the specified inbound request.
   *
   * <p> The <code>completionHandler</code> will be called with the proxy response sent by the <i><b>origin</b></i>.
   * @param inboundRequest the request connected to the <i><b>origin</b></i> server
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.httpproxy.ProxyResponse> rxSend(io.vertx.rxjava3.core.http.HttpClientRequest inboundRequest) { 
    return AsyncResultSingle.toSingle(delegate.send(inboundRequest.getDelegate()), __value -> io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)__value));
  }

  /**
   * Release the proxy request.
   *
   * <p> The HTTP server request is resumed, no HTTP server response is sent.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.httpproxy.ProxyRequest release() { 
    delegate.release();
    return this;
  }

  /**
   * @return the outbound HTTP server request
   */
  public io.vertx.rxjava3.core.http.HttpServerRequest outboundRequest() { 
    io.vertx.rxjava3.core.http.HttpServerRequest ret = io.vertx.rxjava3.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)delegate.outboundRequest());
    return ret;
  }

  /**
   * Create and return the proxy response.
   * @return the proxy response
   */
  public io.vertx.rxjava3.httpproxy.ProxyResponse response() { 
    io.vertx.rxjava3.httpproxy.ProxyResponse ret = io.vertx.rxjava3.httpproxy.ProxyResponse.newInstance((io.vertx.httpproxy.ProxyResponse)delegate.response());
    return ret;
  }

  public static ProxyRequest newInstance(io.vertx.httpproxy.ProxyRequest arg) {
    return arg != null ? new ProxyRequest(arg) : null;
  }

}
