/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler which implements server side http://www.w3.org/TR/cors/[CORS] support for Vert.x-Web.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CorsHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.CorsHandler.class)
public class CorsHandler implements Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CorsHandler that = (CorsHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CorsHandler> __TYPE_ARG = new TypeArg<>(    obj -> new CorsHandler((io.vertx.ext.web.handler.CorsHandler) obj),
    CorsHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CorsHandler delegate;
  
  public CorsHandler(io.vertx.ext.web.handler.CorsHandler delegate) {
    this.delegate = delegate;
  }

  public CorsHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CorsHandler)delegate;
  }

  public io.vertx.ext.web.handler.CorsHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a CORS handler using a regular expression to match origins. An origin follows rfc6454#section-7
   * and is expected to have the format: <code><scheme> "://" <hostname> [ ":" <port> ]</code>
   * @param allowedOriginPattern the allowed origin pattern
   * @return the handler
   */
  public static io.vertx.rxjava3.ext.web.handler.CorsHandler create(java.lang.String allowedOriginPattern) { 
    io.vertx.rxjava3.ext.web.handler.CorsHandler ret = io.vertx.rxjava3.ext.web.handler.CorsHandler.newInstance((io.vertx.ext.web.handler.CorsHandler)io.vertx.ext.web.handler.CorsHandler.create(allowedOriginPattern));
    return ret;
  }

  /**
   * Create a empty CORS handler that allows <code>*</code> origin.
   * @return the handler
   */
  public static io.vertx.rxjava3.ext.web.handler.CorsHandler create() { 
    io.vertx.rxjava3.ext.web.handler.CorsHandler ret = io.vertx.rxjava3.ext.web.handler.CorsHandler.newInstance((io.vertx.ext.web.handler.CorsHandler)io.vertx.ext.web.handler.CorsHandler.create());
    return ret;
  }

  /**
   * Add an origin to the list of allowed Origins. An origin follows rfc6454#section-7
   * and is expected to have the format: <code><scheme> "://" <hostname> [ ":" <port> ]</code>
   * @param origin the well formatted static origin
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler addOrigin(java.lang.String origin) { 
    delegate.addOrigin(origin);
    return this;
  }

  /**
   * Set the list of allowed origins. An origin follows rfc6454#section-7
   * and is expected to have the format: <code><scheme> "://" <hostname> [ ":" <port> ]</code>
   * @param origins the well formatted static origin list
   * @return self
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler addOrigins(java.util.List<java.lang.String> origins) { 
    delegate.addOrigins(origins);
    return this;
  }

  /**
   * Add an allowed method
   * @param method the method to add
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler allowedMethod(io.vertx.core.http.HttpMethod method) { 
    delegate.allowedMethod(method);
    return this;
  }

  /**
   * Add a set of  allowed methods
   * @param methods the methods to add
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler allowedMethods(java.util.Set<io.vertx.core.http.HttpMethod> methods) { 
    delegate.allowedMethods(methods);
    return this;
  }

  /**
   * Add an allowed header
   * @param headerName the allowed header name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler allowedHeader(java.lang.String headerName) { 
    delegate.allowedHeader(headerName);
    return this;
  }

  /**
   * Add a set of allowed headers
   * @param headerNames the allowed header names
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler allowedHeaders(java.util.Set<java.lang.String> headerNames) { 
    delegate.allowedHeaders(headerNames);
    return this;
  }

  /**
   * Add an exposed header
   * @param headerName the exposed header name
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler exposedHeader(java.lang.String headerName) { 
    delegate.exposedHeader(headerName);
    return this;
  }

  /**
   * Add a set of exposed headers
   * @param headerNames the exposed header names
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler exposedHeaders(java.util.Set<java.lang.String> headerNames) { 
    delegate.exposedHeaders(headerNames);
    return this;
  }

  /**
   * Set whether credentials are allowed. Note that user agents will block
   * requests that use a wildcard as origin and include credentials.
   *
   * From the MDN documentation you can read:
   *
   * <blockquote>
   * Important note: when responding to a credentialed request,
   * server must specify a domain, and cannot use wild carding.
   * </blockquote>
   * @param allow true if allowed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler allowCredentials(boolean allow) { 
    delegate.allowCredentials(allow);
    return this;
  }

  /**
   * Set how long the browser should cache the information
   * @param maxAgeSeconds max age in seconds
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.handler.CorsHandler maxAgeSeconds(int maxAgeSeconds) { 
    delegate.maxAgeSeconds(maxAgeSeconds);
    return this;
  }

  public static CorsHandler newInstance(io.vertx.ext.web.handler.CorsHandler arg) {
    return arg != null ? new CorsHandler(arg) : null;
  }

}
