/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A container with the request's headers that are meaningful enough to be parsed
 * Contains:
 * <ul>
 * <li>Accept -> MIME header, parameters and sortable</li>
 * <li>Accept-Charset -> Parameters and sortable</li>
 * <li>Accept-Encoding -> Parameters and sortable</li>
 * <li>Accept-Language -> Parameters and sortable</li>
 * <li>Content-Type -> MIME header and parameters</li>
 * </ul>
 *
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.ParsedHeaderValues original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.ParsedHeaderValues.class)
public class ParsedHeaderValues {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ParsedHeaderValues that = (ParsedHeaderValues) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ParsedHeaderValues> __TYPE_ARG = new TypeArg<>(    obj -> new ParsedHeaderValues((io.vertx.ext.web.ParsedHeaderValues) obj),
    ParsedHeaderValues::getDelegate
  );

  private final io.vertx.ext.web.ParsedHeaderValues delegate;
  
  public ParsedHeaderValues(io.vertx.ext.web.ParsedHeaderValues delegate) {
    this.delegate = delegate;
  }

  public ParsedHeaderValues(Object delegate) {
    this.delegate = (io.vertx.ext.web.ParsedHeaderValues)delegate;
  }

  public io.vertx.ext.web.ParsedHeaderValues getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.ext.web.MIMEHeader> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.ext.web.MIMEHeader>(o1 -> io.vertx.rxjava3.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.ext.web.ParsedHeaderValue> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava3.ext.web.ParsedHeaderValue>(o1 -> io.vertx.rxjava3.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.ext.web.ParsedHeaderValue> TYPE_ARG_2 = new TypeArg<io.vertx.rxjava3.ext.web.ParsedHeaderValue>(o1 -> io.vertx.rxjava3.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.ext.web.LanguageHeader> TYPE_ARG_3 = new TypeArg<io.vertx.rxjava3.ext.web.LanguageHeader>(o1 -> io.vertx.rxjava3.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)o1), o1 -> o1.getDelegate());

  /**
   * @return List of MIME values in the <code>Accept</code> header
   */
  public java.util.List<io.vertx.rxjava3.ext.web.MIMEHeader> accept() { 
    java.util.List<io.vertx.rxjava3.ext.web.MIMEHeader> ret = delegate.accept().stream().map(elt -> io.vertx.rxjava3.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return List of charset values in the <code>Accept-Charset</code> header
   */
  public java.util.List<io.vertx.rxjava3.ext.web.ParsedHeaderValue> acceptCharset() { 
    java.util.List<io.vertx.rxjava3.ext.web.ParsedHeaderValue> ret = delegate.acceptCharset().stream().map(elt -> io.vertx.rxjava3.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return List of encofing values in the <code>Accept-Encoding</code> header
   */
  public java.util.List<io.vertx.rxjava3.ext.web.ParsedHeaderValue> acceptEncoding() { 
    java.util.List<io.vertx.rxjava3.ext.web.ParsedHeaderValue> ret = delegate.acceptEncoding().stream().map(elt -> io.vertx.rxjava3.ext.web.ParsedHeaderValue.newInstance((io.vertx.ext.web.ParsedHeaderValue)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return List of languages in the <code>Accept-Language</code> header
   */
  public java.util.List<io.vertx.rxjava3.ext.web.LanguageHeader> acceptLanguage() { 
    java.util.List<io.vertx.rxjava3.ext.web.LanguageHeader> ret = delegate.acceptLanguage().stream().map(elt -> io.vertx.rxjava3.ext.web.LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)elt)).collect(Collectors.toList());
    return ret;
  }

  /**
   * @return MIME value in the <code>Content-Type</code> header
   */
  public io.vertx.rxjava3.ext.web.MIMEHeader contentType() { 
    io.vertx.rxjava3.ext.web.MIMEHeader ret = io.vertx.rxjava3.ext.web.MIMEHeader.newInstance((io.vertx.ext.web.MIMEHeader)delegate.contentType());
    return ret;
  }

  public static ParsedHeaderValues newInstance(io.vertx.ext.web.ParsedHeaderValues arg) {
    return arg != null ? new ParsedHeaderValues(arg) : null;
  }

}
