/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.eventbus.bridge.tcp;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * TCP EventBus bridge for Vert.x
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.class)
public class TcpEventBusBridge {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TcpEventBusBridge that = (TcpEventBusBridge) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TcpEventBusBridge> __TYPE_ARG = new TypeArg<>(    obj -> new TcpEventBusBridge((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge) obj),
    TcpEventBusBridge::getDelegate
  );

  private final io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate;
  
  public TcpEventBusBridge(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge delegate) {
    this.delegate = delegate;
  }

  public TcpEventBusBridge(Object delegate) {
    this.delegate = (io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)delegate;
  }

  public io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options) { 
    io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options));
    return ret;
  }

  public static io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions) { 
    io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions));
    return ret;
  }

  public static io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.bridge.BridgeOptions options, io.vertx.core.net.NetServerOptions netServerOptions, io.vertx.core.Handler<io.vertx.rxjava3.ext.eventbus.bridge.tcp.BridgeEvent> eventHandler) { 
    io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge ret = io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge.create(vertx.getDelegate(), options, netServerOptions, new Handler<io.vertx.ext.eventbus.bridge.tcp.BridgeEvent>() {
      public void handle(io.vertx.ext.eventbus.bridge.tcp.BridgeEvent event) {
        eventHandler.handle(io.vertx.rxjava3.ext.eventbus.bridge.tcp.BridgeEvent.newInstance((io.vertx.ext.eventbus.bridge.tcp.BridgeEvent)event));
      }
    }));
    return ret;
  }

  /**
   * Listen on default port 7000 with a handler to report the state of the socket listen operation.
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = rxListen();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Listen on default port 7000 with a handler to report the state of the socket listen operation.
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen() { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.listen(new Handler<AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge>>() {
      public void handle(AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Listen on specific port and bind to specific address
   * @param port tcp port
   * @param address tcp address to the bind
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen(int port, java.lang.String address) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = rxListen(port, address);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Listen on specific port and bind to specific address
   * @param port tcp port
   * @param address tcp address to the bind
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port, java.lang.String address) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.listen(port, address, new Handler<AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge>>() {
      public void handle(AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Listen on specific port
   * @param port tcp port
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> listen(int port) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> ret = rxListen(port);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Listen on specific port
   * @param port tcp port
   * @return self
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge> rxListen(int port) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.listen(port, new Handler<AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge>>() {
      public void handle(AsyncResult<io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.ext.eventbus.bridge.tcp.TcpEventBusBridge.newInstance((io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Close the current socket.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the current socket.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.close(handler);
    });
  }

  public static TcpEventBusBridge newInstance(io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge arg) {
    return arg != null ? new TcpEventBusBridge(arg) : null;
  }

}
