/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.webauthn;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating FIDO2 MetaDataService.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.webauthn.MetaDataService original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.webauthn.MetaDataService.class)
public class MetaDataService {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MetaDataService that = (MetaDataService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MetaDataService> __TYPE_ARG = new TypeArg<>(    obj -> new MetaDataService((io.vertx.ext.auth.webauthn.MetaDataService) obj),
    MetaDataService::getDelegate
  );

  private final io.vertx.ext.auth.webauthn.MetaDataService delegate;
  
  public MetaDataService(io.vertx.ext.auth.webauthn.MetaDataService delegate) {
    this.delegate = delegate;
  }

  public MetaDataService(Object delegate) {
    this.delegate = (io.vertx.ext.auth.webauthn.MetaDataService)delegate;
  }

  public io.vertx.ext.auth.webauthn.MetaDataService getDelegate() {
    return delegate;
  }

  /**
   * Fetches the FIDO2 TOC for the given URL and process the entries to the metadata store.
   * Only valid entries will be stored. The operation will return <code>true</code> only if all
   * entries have been added. <code>false</code> if they have been processed but at least one was
   * invalid.
   *
   * The operation will only fail on network problems.
   * @param url the url to the TOC
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> fetchTOC(java.lang.String url) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxFetchTOC(url);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Fetches the FIDO2 TOC for the given URL and process the entries to the metadata store.
   * Only valid entries will be stored. The operation will return <code>true</code> only if all
   * entries have been added. <code>false</code> if they have been processed but at least one was
   * invalid.
   *
   * The operation will only fail on network problems.
   * @param url the url to the TOC
   * @return fluent self
   */
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxFetchTOC(java.lang.String url) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.fetchTOC(url, handler);
    });
  }

  /**
   * Manually feed a Meta Data Statement to the service.
   * @param statement the json statement
   * @return fluent self
   */
  public io.vertx.rxjava3.ext.auth.webauthn.MetaDataService addStatement(io.vertx.core.json.JsonObject statement) { 
    delegate.addStatement(statement);
    return this;
  }

  /**
   * Clears all loaded statements, both from the TOC and manually inserted.
   * The flush operation will not cancel any in-flight TOC download/processing.
   * @return fluent self
   */
  public io.vertx.rxjava3.ext.auth.webauthn.MetaDataService flush() { 
    delegate.flush();
    return this;
  }

  /**
   * Verify the metadata for a given authenticator. The MDS will lookup the metadata by the AAGUID. If no AAGUID is
   * known, the result will be <code>null</code>.
   *
   * When a statement is found, the statement will be used to verify the certificate chain. A failure during this
   * verification will throw a {@link java.lang.RuntimeException}.
   * @param authenticator authenticator to verify
   * @return an MDS statement for this authenticator or <code>null</code>.
   */
  public io.vertx.core.json.JsonObject verify(io.vertx.ext.auth.webauthn.Authenticator authenticator) { 
    io.vertx.core.json.JsonObject ret = delegate.verify(authenticator);
    return ret;
  }

  public static MetaDataService newInstance(io.vertx.ext.auth.webauthn.MetaDataService arg) {
    return arg != null ? new MetaDataService(arg) : null;
  }

}
