/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2.authorization;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Implementation of the Keycloak Authorization Provider.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization.class)
public class KeycloakAuthorization extends io.vertx.rxjava3.ext.auth.authorization.AuthorizationProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeycloakAuthorization that = (KeycloakAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KeycloakAuthorization> __TYPE_ARG = new TypeArg<>(    obj -> new KeycloakAuthorization((io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization) obj),
    KeycloakAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization delegate;
  
  public KeycloakAuthorization(io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public KeycloakAuthorization(Object delegate) {
    super((io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization)delegate;
  }

  public io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization getDelegate() {
    return delegate;
  }

  /**
   * Factory method to create an Authorization Provider for tokens adhering to the Keycloak token format.
   * When the user is known to not be a JWT, (e.g.: a OAuth2 response token) then the root claim
   * is expected to be the extracted from the user  under the key: <code>accessToken</code>.
   * @return a AuthorizationProvider
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.authorization.KeycloakAuthorization create() { 
    io.vertx.rxjava3.ext.auth.oauth2.authorization.KeycloakAuthorization ret = io.vertx.rxjava3.ext.auth.oauth2.authorization.KeycloakAuthorization.newInstance((io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization)io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization.create());
    return ret;
  }

  public static KeycloakAuthorization newInstance(io.vertx.ext.auth.oauth2.authorization.KeycloakAuthorization arg) {
    return arg != null ? new KeycloakAuthorization(arg) : null;
  }

}
