/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Functional interface that allows users to implement custom RBAC verifiers for OAuth2/OpenId Connect.
 *
 * Users are to implement the <code>isAuthorized</code> method to verify authorities. For provides that do not
 * export the permissions/roles in the token, this interface allows you to communicate with 3rd party services
 * such as graph APIs to collect the required data.
 *
 * The contract is that once an authority is checked for a given user, it's value is cached during the execution
 * of the request. If a user is stored to a persistent storage, or the token is introspected, the cache is cleared
 * and a new call will be handled to the implementation.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2RBAC original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.OAuth2RBAC.class)
public class OAuth2RBAC {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2RBAC that = (OAuth2RBAC) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuth2RBAC> __TYPE_ARG = new TypeArg<>(    obj -> new OAuth2RBAC((io.vertx.ext.auth.oauth2.OAuth2RBAC) obj),
    OAuth2RBAC::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2RBAC delegate;
  
  public OAuth2RBAC(io.vertx.ext.auth.oauth2.OAuth2RBAC delegate) {
    this.delegate = delegate;
  }

  public OAuth2RBAC(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.OAuth2RBAC)delegate;
  }

  public io.vertx.ext.auth.oauth2.OAuth2RBAC getDelegate() {
    return delegate;
  }

  /**
   * This method should verify if the user has the given authority and return either a boolean value or an error.
   *
   * Note that false and errors are not the same. A user might not have a given authority but that doesn't mean that
   * there was an error during the call.
   * @param user the given user to assert on
   * @param authority the authority to lookup
   * @return 
   */
  @Deprecated()
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> isAuthorized(io.vertx.rxjava3.ext.auth.oauth2.AccessToken user, java.lang.String authority) { 
    io.reactivex.rxjava3.core.Single<java.lang.Boolean> ret = rxIsAuthorized(user, authority);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * This method should verify if the user has the given authority and return either a boolean value or an error.
   *
   * Note that false and errors are not the same. A user might not have a given authority but that doesn't mean that
   * there was an error during the call.
   * @param user the given user to assert on
   * @param authority the authority to lookup
   * @return 
   */
  @Deprecated()
  public io.reactivex.rxjava3.core.Single<java.lang.Boolean> rxIsAuthorized(io.vertx.rxjava3.ext.auth.oauth2.AccessToken user, java.lang.String authority) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.isAuthorized(user.getDelegate(), authority, handler);
    });
  }

  public static OAuth2RBAC newInstance(io.vertx.ext.auth.oauth2.OAuth2RBAC arg) {
    return arg != null ? new OAuth2RBAC(arg) : null;
  }

}
