/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Helper class for processing Keycloak principal.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.KeycloakHelper original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.KeycloakHelper.class)
public class KeycloakHelper {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KeycloakHelper that = (KeycloakHelper) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<KeycloakHelper> __TYPE_ARG = new TypeArg<>(    obj -> new KeycloakHelper((io.vertx.ext.auth.oauth2.KeycloakHelper) obj),
    KeycloakHelper::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.KeycloakHelper delegate;
  
  public KeycloakHelper(io.vertx.ext.auth.oauth2.KeycloakHelper delegate) {
    this.delegate = delegate;
  }

  public KeycloakHelper(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.KeycloakHelper)delegate;
  }

  public io.vertx.ext.auth.oauth2.KeycloakHelper getDelegate() {
    return delegate;
  }


  /**
   * Get raw `id_token` string from the principal.
   * @param principal user principal
   * @return the raw id token string
   */
  @Deprecated()
  public static java.lang.String rawIdToken(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.rawIdToken(principal);
    return ret;
  }

  /**
   * Get decoded `id_token` from the principal.
   * @param principal user principal
   * @return the id token
   */
  @Deprecated()
  public static io.vertx.core.json.JsonObject idToken(io.vertx.core.json.JsonObject principal) { 
    io.vertx.core.json.JsonObject ret = io.vertx.ext.auth.oauth2.KeycloakHelper.idToken(principal);
    return ret;
  }

  /**
   * Get raw `access_token` string from the principal.
   * @param principal user principal
   * @return the raw access token string
   */
  @Deprecated()
  public static java.lang.String rawAccessToken(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.rawAccessToken(principal);
    return ret;
  }

  /**
   * Get decoded `access_token` from the principal.
   * @param principal user principal
   * @return the access token
   */
  @Deprecated()
  public static io.vertx.core.json.JsonObject accessToken(io.vertx.core.json.JsonObject principal) { 
    io.vertx.core.json.JsonObject ret = io.vertx.ext.auth.oauth2.KeycloakHelper.accessToken(principal);
    return ret;
  }

  @Deprecated()
  public static int authTime(io.vertx.core.json.JsonObject principal) { 
    int ret = io.vertx.ext.auth.oauth2.KeycloakHelper.authTime(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String sessionState(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.sessionState(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String acr(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.acr(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String name(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.name(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String email(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.email(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String preferredUsername(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.preferredUsername(principal);
    return ret;
  }

  @Deprecated()
  public static java.lang.String nickName(io.vertx.core.json.JsonObject principal) { 
    java.lang.String ret = io.vertx.ext.auth.oauth2.KeycloakHelper.nickName(principal);
    return ret;
  }

  @Deprecated()
  public static java.util.Set<java.lang.String> allowedOrigins(io.vertx.core.json.JsonObject principal) { 
    java.util.Set<java.lang.String> ret = io.vertx.ext.auth.oauth2.KeycloakHelper.allowedOrigins(principal);
    return ret;
  }

  /**
   * Parse the token string with base64 decoder.
   * This will only obtain the "payload" part of the token.
   * @param token token string
   * @return token payload json object
   */
  @Deprecated()
  public static io.vertx.core.json.JsonObject parseToken(java.lang.String token) { 
    io.vertx.core.json.JsonObject ret = io.vertx.ext.auth.oauth2.KeycloakHelper.parseToken(token);
    return ret;
  }

  public static KeycloakHelper newInstance(io.vertx.ext.auth.oauth2.KeycloakHelper arg) {
    return arg != null ? new KeycloakHelper(arg) : null;
  }

}
