/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AccessToken extension to the User interface
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.AccessToken original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken extends io.vertx.rxjava3.ext.auth.User {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AccessToken that = (AccessToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg<>(    obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken) obj),
    AccessToken::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.AccessToken delegate;
  
  public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AccessToken(Object delegate) {
    super((io.vertx.ext.auth.oauth2.AccessToken)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.AccessToken)delegate;
  }

  public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
    return delegate;
  }

  /**
   * Check if the access token own the required scopes to access to the resource.
   * @return 
   */
  public boolean isScopeGranted() { 
    boolean ret = delegate.isScopeGranted();
    return ret;
  }

  /**
   * The Access Token if present parsed as a JsonObject
   * @return JSON
   */
  public io.vertx.core.json.JsonObject accessToken() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.core.json.JsonObject ret = delegate.accessToken();
    cached_0 = ret;
    return ret;
  }

  /**
   * The Id Token if present parsed as a JsonObject
   * @return JSON
   */
  public io.vertx.core.json.JsonObject idToken() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.core.json.JsonObject ret = delegate.idToken();
    cached_1 = ret;
    return ret;
  }

  /**
   * The RAW String if available for the Access Token
   * @return String
   */
  public java.lang.String opaqueAccessToken() { 
    java.lang.String ret = delegate.opaqueAccessToken();
    return ret;
  }

  /**
   * The RAW String if available for the Refresh Token
   * @return String
   */
  public java.lang.String opaqueRefreshToken() { 
    java.lang.String ret = delegate.opaqueRefreshToken();
    return ret;
  }

  /**
   * The RAW String if available for the Id Token
   * @return String
   */
  public java.lang.String opaqueIdToken() { 
    java.lang.String ret = delegate.opaqueIdToken();
    return ret;
  }

  public java.lang.String tokenType() { 
    java.lang.String ret = delegate.tokenType();
    return ret;
  }

  public io.vertx.rxjava3.ext.auth.oauth2.AccessToken setTrustJWT(boolean trust) { 
    delegate.setTrustJWT(trust);
    return this;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable refresh() { 
    io.reactivex.rxjava3.core.Completable ret = rxRefresh();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxRefresh() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.refresh(callback);
    });
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable revoke(java.lang.String token_type) { 
    io.reactivex.rxjava3.core.Completable ret = rxRevoke(token_type);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxRevoke(java.lang.String token_type) { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.revoke(token_type, callback);
    });
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable logout() { 
    io.reactivex.rxjava3.core.Completable ret = rxLogout();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxLogout() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.logout(callback);
    });
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable introspect() { 
    io.reactivex.rxjava3.core.Completable ret = rxIntrospect();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxIntrospect() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.introspect(callback);
    });
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable introspect(java.lang.String tokenType) { 
    io.reactivex.rxjava3.core.Completable ret = rxIntrospect(tokenType);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxIntrospect(java.lang.String tokenType) { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.introspect(tokenType, callback);
    });
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> userInfo() { 
    io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> ret = rxUserInfo();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.core.json.JsonObject> rxUserInfo() { 
    return AsyncResultSingle.toSingle( callback -> {
      delegate.userInfo(callback);
    });
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> fetch(java.lang.String resource) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> ret = rxFetch(resource);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> rxFetch(java.lang.String resource) { 
    return AsyncResultSingle.toSingle( callback -> {
      delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> fetch(io.vertx.core.http.HttpMethod method, java.lang.String resource, io.vertx.core.json.JsonObject headers, io.vertx.rxjava3.core.buffer.Buffer payload) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> ret = rxFetch(method, resource, headers, payload);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response> rxFetch(io.vertx.core.http.HttpMethod method, java.lang.String resource, io.vertx.core.json.JsonObject headers, io.vertx.rxjava3.core.buffer.Buffer payload) { 
    return AsyncResultSingle.toSingle( callback -> {
      delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  private io.vertx.core.json.JsonObject cached_0;
  private io.vertx.core.json.JsonObject cached_1;
  public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
    return arg != null ? new AccessToken(arg) : null;
  }

}
