/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.http;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An HTTP and WebSockets server.
 * <p>
 * You receive HTTP requests by providing a {@link io.vertx.rxjava3.core.http.HttpServer#requestHandler}. As requests arrive on the server the handler
 * will be called with the requests.
 * <p>
 * You receive WebSockets by providing a {@link io.vertx.rxjava3.core.http.HttpServer#webSocketHandler}. As WebSocket connections arrive on the server, the
 * WebSocket is passed to the handler.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.HttpServer.class)
public class HttpServer implements io.vertx.rxjava3.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServer that = (HttpServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg<>(    obj -> new HttpServer((io.vertx.core.http.HttpServer) obj),
    HttpServer::getDelegate
  );

  private final io.vertx.core.http.HttpServer delegate;
  
  public HttpServer(io.vertx.core.http.HttpServer delegate) {
    this.delegate = delegate;
  }

  public HttpServer(Object delegate) {
    this.delegate = (io.vertx.core.http.HttpServer)delegate;
  }

  public io.vertx.core.http.HttpServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.core.http.HttpServerRequest> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.core.http.HttpServerRequest>(o1 -> io.vertx.rxjava3.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)o1), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.core.http.ServerWebSocket> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava3.core.http.ServerWebSocket>(o1 -> io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the request stream for the server. As HTTP requests are received by the server,
   * instances of {@link io.vertx.rxjava3.core.http.HttpServerRequest} will be created and passed to the stream .
   * @return the request stream
   */
  public io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.HttpServerRequest> requestStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.HttpServerRequest> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.requestStream(), TYPE_ARG_0);
    cached_0 = ret;
    return ret;
  }

  /**
   * Set the request handler for the server to <code>requestHandler</code>. As HTTP requests are received by the server,
   * instances of {@link io.vertx.rxjava3.core.http.HttpServerRequest} will be created and passed to this handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpServer requestHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.HttpServerRequest> handler) { 
    delegate.requestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.rxjava3.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event));
      }
    });
    return this;
  }

  /**
   * Set a <code>handler</code> for handling invalid requests. When an invalid request is received by the server
   * this handler will be called with the request. The handler can send any HTTP response, when the response
   * ends, the server shall close the connection. {@link io.vertx.rxjava3.core.http.HttpServerRequest#decoderResult} can be used
   * to obtain the Netty decoder result and the failure cause reported by the decoder.
   *
   * <p> Currently this handler is only used for HTTP/1.x requests.
   *
   * <p> When no specific handler is set, the {@link io.vertx.rxjava3.core.http.HttpServerRequest} is used.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpServer invalidRequestHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.HttpServerRequest> handler) { 
    io.vertx.rxjava3.core.http.HttpServer ret = io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)delegate.invalidRequestHandler(new Handler<io.vertx.core.http.HttpServerRequest>() {
      public void handle(io.vertx.core.http.HttpServerRequest event) {
        handler.handle(io.vertx.rxjava3.core.http.HttpServerRequest.newInstance((io.vertx.core.http.HttpServerRequest)event));
      }
    }));
    return ret;
  }

  /**
   * Set a connection handler for the server.
   * <br/>
   * The handler will always be called on the event-loop thread.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpServer connectionHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.HttpConnection> handler) { 
    delegate.connectionHandler(new Handler<io.vertx.core.http.HttpConnection>() {
      public void handle(io.vertx.core.http.HttpConnection event) {
        handler.handle(io.vertx.rxjava3.core.http.HttpConnection.newInstance((io.vertx.core.http.HttpConnection)event));
      }
    });
    return this;
  }

  /**
   * Set an exception handler called for socket errors happening before the HTTP connection
   * is established, e.g during the TLS handshake.
   * @param handler the handler to set
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpServer exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Return the WebSocket stream for the server. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.rxjava3.core.http.ServerWebSocket} instance will be created and passed to the stream .
   * @return the WebSocket stream
   */
  public io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.ServerWebSocket> webSocketStream() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.ServerWebSocket> ret = io.vertx.rxjava3.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.webSocketStream(), TYPE_ARG_1);
    cached_1 = ret;
    return ret;
  }

  /**
   * Set the WebSocket handler for the server to <code>wsHandler</code>. If a WebSocket connect handshake is successful a
   * new {@link io.vertx.rxjava3.core.http.ServerWebSocket} instance will be created and passed to the handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.http.HttpServer webSocketHandler(io.vertx.core.Handler<io.vertx.rxjava3.core.http.ServerWebSocket> handler) { 
    delegate.webSocketHandler(new Handler<io.vertx.core.http.ServerWebSocket>() {
      public void handle(io.vertx.core.http.ServerWebSocket event) {
        handler.handle(io.vertx.rxjava3.core.http.ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)event));
      }
    });
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> listen(int port, java.lang.String host) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> ret = rxListen(port, host);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually
   * listening (or has failed).
   * @param port the port to listen on
   * @param host the host to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> listen(io.vertx.rxjava3.core.net.SocketAddress address) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> ret = rxListen(address);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Tell the server to start listening on the given address supplying
   * a handler that will be called when the server is actually
   * listening (or has failed).
   * @param address the address to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> rxListen(io.vertx.rxjava3.core.net.SocketAddress address) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(address.getDelegate(), new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> listen(int port) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> ret = rxListen(port);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @param port the port to listen on
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> listen() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> ret = rxListen();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#listen} but supplying a handler that will be called when the server is actually listening (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.core.http.HttpServer> rxListen() { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(new Handler<AsyncResult<io.vertx.core.http.HttpServer>>() {
      public void handle(AsyncResult<io.vertx.core.http.HttpServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava3.core.http.HttpServer.newInstance((io.vertx.core.http.HttpServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    });
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava3.core.http.HttpServer#close} but supplying a handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  private io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.HttpServerRequest> cached_0;
  private io.vertx.rxjava3.core.streams.ReadStream<io.vertx.rxjava3.core.http.ServerWebSocket> cached_1;
  public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
    return arg != null ? new HttpServer(arg) : null;
  }

}
