/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.circuitbreaker;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An implementation of the circuit breaker pattern for Vert.x
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.circuitbreaker.CircuitBreaker original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.circuitbreaker.CircuitBreaker.class)
public class CircuitBreaker {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CircuitBreaker that = (CircuitBreaker) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CircuitBreaker> __TYPE_ARG = new TypeArg<>(    obj -> new CircuitBreaker((io.vertx.circuitbreaker.CircuitBreaker) obj),
    CircuitBreaker::getDelegate
  );

  private final io.vertx.circuitbreaker.CircuitBreaker delegate;
  
  public CircuitBreaker(io.vertx.circuitbreaker.CircuitBreaker delegate) {
    this.delegate = delegate;
  }

  public CircuitBreaker(Object delegate) {
    this.delegate = (io.vertx.circuitbreaker.CircuitBreaker)delegate;
  }

  public io.vertx.circuitbreaker.CircuitBreaker getDelegate() {
    return delegate;
  }

  /**
   * Creates a new instance of {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}.
   * @param name the name
   * @param vertx the Vert.x instance
   * @param options the configuration option
   * @return the created instance
   */
  public static io.vertx.rxjava3.circuitbreaker.CircuitBreaker create(java.lang.String name, io.vertx.rxjava3.core.Vertx vertx, io.vertx.circuitbreaker.CircuitBreakerOptions options) { 
    io.vertx.rxjava3.circuitbreaker.CircuitBreaker ret = io.vertx.rxjava3.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates a new instance of {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}, with default options.
   * @param name the name
   * @param vertx the Vert.x instance
   * @return the created instance
   */
  public static io.vertx.rxjava3.circuitbreaker.CircuitBreaker create(java.lang.String name, io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.circuitbreaker.CircuitBreaker ret = io.vertx.rxjava3.circuitbreaker.CircuitBreaker.newInstance((io.vertx.circuitbreaker.CircuitBreaker)io.vertx.circuitbreaker.CircuitBreaker.create(name, vertx.getDelegate()));
    return ret;
  }

  /**
   * Closes the circuit breaker. It stops sending events on its state on the event bus.
   * This method is not related to the <code>close</code> state of the circuit breaker. To set the circuit breaker in the
   * <code>close</code> state, use {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#reset}.
   * @return 
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker close() { 
    delegate.close();
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to open.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker openHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.openHandler(handler);
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to half-open.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker halfOpenHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.halfOpenHandler(handler);
    return this;
  }

  /**
   * Sets a  invoked when the circuit breaker state switches to close.
   * @param handler the handler, must not be <code>null</code>
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker closeHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Single<T> executeWithFallback(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    io.reactivex.rxjava3.core.Single<T> ret = rxExecuteWithFallback(command, fallback);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeWithFallback} but using a callback.
   * @param command the operation
   * @param fallback the fallback
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Single<T> rxExecuteWithFallback(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.executeWithFallback(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()));
      }
    }, fallback, handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Single<T> execute(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command) { 
    io.reactivex.rxjava3.core.Single<T> ret = rxExecute(command);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeWithFallback} but using the circuit breaker default fallback.
   * @param command the operation
   * @return 
   */
  public <T> io.reactivex.rxjava3.core.Single<T> rxExecute(io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.execute(new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, TypeArg.unknown()));
      }
    }, handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeAndReportWithFallback} but using the circuit breaker default
   * fallback.
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.rxjava3.circuitbreaker.CircuitBreaker executeAndReport(io.vertx.rxjava3.core.Promise<T> resultPromise, io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command) { 
    delegate.executeAndReport(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, resultPromise.__typeArg_0));
      }
    });
    return this;
  }

  /**
   * Executes the given operation with the circuit breaker control. The operation is generally calling an
   * <em>external</em> system. The operation receives a  object as parameter and <strong>must</strong>
   * call  when the operation has terminated successfully. The operation must also
   * call  in case of failure.
   * <p>
   * The operation is not invoked if the circuit breaker is open, and the given fallback is called immediately. The
   * circuit breaker also monitor the completion of the operation before a configure timeout. The operation is
   * considered as failed if it does not terminate in time.
   * <p>
   * Unlike {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker#executeWithFallback},  this method does return a  object, but
   * let the caller pass a  object on which the result is reported. If the fallback is called, the future
   * is successfully completed with the value returned by the fallback function. If the fallback throws an exception,
   * the future is marked as failed.
   * @param resultPromise the promise on which the operation result is reported
   * @param command the operation
   * @param fallback the fallback function. It gets an exception as parameter and returns the <em>fallback</em> result
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.rxjava3.circuitbreaker.CircuitBreaker executeAndReportWithFallback(io.vertx.rxjava3.core.Promise<T> resultPromise, io.vertx.core.Handler<io.vertx.rxjava3.core.Promise<T>> command, java.util.function.Function<java.lang.Throwable,T> fallback) { 
    delegate.executeAndReportWithFallback(resultPromise.getDelegate(), new Handler<io.vertx.core.Promise<T>>() {
      public void handle(io.vertx.core.Promise<T> event) {
        command.handle(io.vertx.rxjava3.core.Promise.newInstance((io.vertx.core.Promise)event, resultPromise.__typeArg_0));
      }
    }, fallback);
    return this;
  }

  /**
   * Sets a <em>default</em>  invoked when the bridge is open to handle the "request", or on failure
   * if {@link io.vertx.circuitbreaker.CircuitBreakerOptions} is enabled.
   * <p>
   * The function gets the exception as parameter and returns the <em>fallback</em> result.
   * @param handler the handler
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public <T> io.vertx.rxjava3.circuitbreaker.CircuitBreaker fallback(java.util.function.Function<java.lang.Throwable,T> handler) { 
    delegate.fallback(handler);
    return this;
  }

  /**
   * Resets the circuit breaker state (number of failure set to 0 and state set to closed).
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker reset() { 
    delegate.reset();
    return this;
  }

  /**
   * Explicitly opens the circuit.
   * @return the current {@link io.vertx.rxjava3.circuitbreaker.CircuitBreaker}
   */
  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker open() { 
    delegate.open();
    return this;
  }

  /**
   * @return the current state.
   */
  public io.vertx.circuitbreaker.CircuitBreakerState state() { 
    io.vertx.circuitbreaker.CircuitBreakerState ret = delegate.state();
    return ret;
  }

  /**
   * @return the current number of failures.
   */
  public long failureCount() { 
    long ret = delegate.failureCount();
    return ret;
  }

  /**
   * @return the name of the circuit breaker.
   */
  public java.lang.String name() { 
    if (cached_0 != null) {
      return cached_0;
    }
    java.lang.String ret = delegate.name();
    cached_0 = ret;
    return ret;
  }

  public io.vertx.rxjava3.circuitbreaker.CircuitBreaker retryPolicy(java.util.function.Function<java.lang.Integer,java.lang.Long> retryPolicy) { 
    delegate.retryPolicy(retryPolicy);
    return this;
  }

  private java.lang.String cached_0;
  public static CircuitBreaker newInstance(io.vertx.circuitbreaker.CircuitBreaker arg) {
    return arg != null ? new CircuitBreaker(arg) : null;
  }

}
