/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.net.SocketAddress;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;

public class EqualityTest {
    @Test
    public void testBufferEquality() {
        Buffer buf1 = Buffer.buffer((String)"The quick brown fox jumps over the lazy dog");
        Buffer buf2 = buf1.copy();
        Assert.assertNotSame((Object)buf1, (Object)buf2);
        Assert.assertEquals((Object)buf1, (Object)buf2);
    }

    @Test
    public void testBufferSet() {
        Buffer buf1 = Buffer.buffer((String)"The quick brown fox jumps over the lazy dog");
        Buffer buf2 = buf1.copy();
        Assert.assertEquals((long)1L, (long)Stream.of(buf1, buf2).collect(Collectors.toSet()).size());
    }

    @Test
    public void testSocketAddressEquality() {
        SocketAddress address1 = SocketAddress.newInstance((io.vertx.core.net.SocketAddress)new SocketAddressImpl(8888, "guest"));
        SocketAddress address2 = SocketAddress.newInstance((io.vertx.core.net.SocketAddress)new SocketAddressImpl(8888, "guest"));
        Assert.assertNotSame((Object)address1, (Object)address2);
        Assert.assertEquals((Object)address1, (Object)address2);
    }

    @Test
    public void testSocketAddressSet() {
        SocketAddress address1 = SocketAddress.newInstance((io.vertx.core.net.SocketAddress)new SocketAddressImpl(8888, "guest"));
        SocketAddress address2 = SocketAddress.newInstance((io.vertx.core.net.SocketAddress)new SocketAddressImpl(8888, "guest"));
        Assert.assertEquals((long)1L, (long)Stream.of(address1, address2).collect(Collectors.toSet()).size());
    }
}

