/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.vertx.core.Verticle;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.reactivex.core.AbstractVerticle;
import io.vertx.reactivex.core.RxHelper;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.WebSocket;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Test;

public class CoreApiTest
extends VertxTestBase {
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    @Test
    public void testDeployVerticle() throws Exception {
        final CountDownLatch deployLatch = new CountDownLatch(2);
        RxHelper.deployVerticle((Vertx)this.vertx, (Verticle)new AbstractVerticle(){

            public void start() {
                deployLatch.countDown();
            }
        }).subscribe(resp -> deployLatch.countDown());
        this.awaitLatch(deployLatch);
    }

    @Test
    public void testWebSocket() {
        this.waitFor(2);
        AtomicLong serverReceived = new AtomicLong();
        this.vertx.createHttpServer(new HttpServerOptions().setIdleTimeout(2)).webSocketHandler(ws -> ws.toFlowable().subscribe(msg -> {
            serverReceived.incrementAndGet();
            ws.writeTextMessage("pong");
        }, err -> {
            this.assertEquals(1L, serverReceived.get());
            this.complete();
        }, () -> ((CoreApiTest)this).fail())).rxListen(8080, "localhost").blockingGet();
        HttpClient client = this.vertx.createHttpClient();
        AtomicLong clientReceived = new AtomicLong();
        client.rxWebSocket(8080, "localhost", "/").doAfterSuccess(ws -> ws.writeTextMessage("ping")).flatMapPublisher(WebSocket::toFlowable).subscribe(msg -> clientReceived.incrementAndGet(), err -> {
            this.assertEquals(1L, clientReceived.get());
            this.complete();
        }, () -> ((CoreApiTest)this).fail());
        this.await();
    }
}

