/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.test;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.plugins.RxJavaPlugins;
import io.vertx.core.Future;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import org.junit.Assert;
import org.junit.Test;

public class AsyncResultTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingle() {
        Future fut = Future.future();
        try {
            Single justMe = Single.just((Object)"me");
            RxJavaPlugins.setOnSingleAssembly(single -> justMe);
            Single single2 = AsyncResultSingle.toSingle(arg_0 -> ((Future)fut).setHandler(arg_0));
            Assert.assertSame((Object)single2, (Object)justMe);
        }
        finally {
            RxJavaPlugins.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaybe() {
        Future fut = Future.future();
        try {
            Maybe justMe = Maybe.just((Object)"me");
            RxJavaPlugins.setOnMaybeAssembly(single -> justMe);
            Maybe maybe = AsyncResultMaybe.toMaybe(arg_0 -> ((Future)fut).setHandler(arg_0));
            Assert.assertSame((Object)maybe, (Object)justMe);
        }
        finally {
            RxJavaPlugins.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompletable() {
        Future fut = Future.future();
        try {
            Completable complete = Completable.complete();
            RxJavaPlugins.setOnCompletableAssembly(single -> complete);
            Completable completable = AsyncResultCompletable.toCompletable(arg_0 -> ((Future)fut).setHandler(arg_0));
            Assert.assertSame((Object)completable, (Object)complete);
        }
        finally {
            RxJavaPlugins.reset();
        }
    }
}

