/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.sql;

import io.reactivex.observers.BaseTestConsumer;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.reactivex.ext.jdbc.JDBCClient;
import io.vertx.reactivex.ext.sql.SQLClient;
import io.vertx.reactivex.ext.sql.SQLClientHelper;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.junit.Test;

public class UsingConnectionSafetyTest
extends VertxTestBase {
    private static final int MAX_POOL_SIZE = 5;
    private static final JsonObject config = new JsonObject().put("driver_class", "org.hsqldb.jdbcDriver").put("url", "jdbc:hsqldb:mem:test?shutdown=true").put("max_pool_size", Integer.valueOf(5));
    private SQLClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.client = new JDBCClient(io.vertx.ext.jdbc.JDBCClient.createNonShared((Vertx)this.vertx, (JsonObject)config));
    }

    @Test
    public void testUsingConnectionFlowable() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionFlowable((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionObservable() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionObservable((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionSingle() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionSingle((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionMaybe() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionMaybe((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    @Test
    public void testUsingConnectionCompletable() throws Exception {
        this.doTest(runtimeException -> SQLClientHelper.usingConnectionCompletable((SQLClient)this.client, conn -> {
            throw runtimeException;
        }).test());
    }

    private void doTest(Function<RuntimeException, BaseTestConsumer> test) {
        for (int i = 0; i < 6; ++i) {
            RuntimeException expected = new RuntimeException();
            BaseTestConsumer testConsumer = test.apply(expected);
            testConsumer.awaitDone(5L, TimeUnit.SECONDS).assertNoValues().assertError((Throwable)expected);
        }
    }

    public void tearDown() throws Exception {
        this.client.rxClose().blockingAwait();
    }
}

