/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.it.WineAndCheese;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.http.HttpClient;
import io.vertx.reactivex.core.http.HttpServer;
import io.vertx.reactivex.ext.web.client.WebClient;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class WebClientTest
extends VertxTestBase {
    private Vertx vertx;
    private WebClient client;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    @Test
    public void testGet() {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().setChunked(true).end("some_content"));
        try {
            server.listen(ar -> {
                this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
                Single single = this.client.get(8080, "localhost", "/the_uri").as(BodyCodec.buffer()).rxSend();
                for (int i = 0; i < times; ++i) {
                    single.subscribe(resp -> {
                        Buffer body = (Buffer)resp.body();
                        this.assertEquals("some_content", body.toString("UTF-8"));
                        this.complete();
                    }, arg_0 -> ((WebClientTest)this).fail(arg_0));
                }
            });
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testPost() {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.bodyHandler(buff -> {
            this.assertEquals("onetwothree", buff.toString());
            req.response().end();
        }));
        try {
            server.listen(ar -> {
                this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
                Observable stream = Observable.just((Object)Buffer.buffer((String)"one"), (Object)Buffer.buffer((String)"two"), (Object)Buffer.buffer((String)"three"));
                Single single = this.client.post(8080, "localhost", "/the_uri").rxSendStream(stream);
                for (int i = 0; i < times; ++i) {
                    single.subscribe(resp -> this.complete(), arg_0 -> ((WebClientTest)this).fail(arg_0));
                }
            });
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testResponseMissingBody() throws Exception {
        int times = 5;
        this.waitFor(times);
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().setStatusCode(403).end());
        try {
            server.listen(ar -> {
                this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
                Single single = this.client.get(8080, "localhost", "/the_uri").rxSend();
                for (int i = 0; i < times; ++i) {
                    single.subscribe(resp -> {
                        this.assertEquals(403L, resp.statusCode());
                        this.assertNull(resp.body());
                        this.complete();
                    }, arg_0 -> ((WebClientTest)this).fail(arg_0));
                }
            });
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testResponseBodyAsAsJsonMapped() throws Exception {
        JsonObject expected = new JsonObject().put("cheese", "Goat Cheese").put("wine", "Condrieu");
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestStream().handler(req -> req.response().end(expected.encode()));
        try {
            server.listen(ar -> {
                this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
                Single single = this.client.get(8080, "localhost", "/the_uri").as(BodyCodec.json(WineAndCheese.class)).rxSend();
                single.subscribe(resp -> {
                    this.assertEquals(200L, resp.statusCode());
                    this.assertEquals(new WineAndCheese().setCheese("Goat Cheese").setWine("Condrieu"), resp.body());
                    this.testComplete();
                }, arg_0 -> ((WebClientTest)this).fail(arg_0));
            });
            this.await();
        }
        finally {
            server.close();
        }
    }

    @Test
    public void testErrorHandling() throws Exception {
        try {
            this.client = WebClient.wrap((HttpClient)this.vertx.createHttpClient(new HttpClientOptions()));
            Single single = this.client.get(-1, "localhost", "/the_uri").as(BodyCodec.json(WineAndCheese.class)).rxSend();
            single.subscribe(resp -> this.fail(), error -> {
                this.assertEquals(IllegalArgumentException.class, error.getClass());
                this.testComplete();
            });
            this.await();
        }
        catch (Throwable t) {
            this.fail();
        }
    }
}

