/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.it;

import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Observer;
import io.reactivex.SingleSource;
import io.reactivex.observers.TestObserver;
import io.vertx.core.file.OpenOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.file.AsyncFile;
import io.vertx.test.core.Repeat;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;

public class AsyncFileTest
extends VertxTestBase {
    private Vertx vertx;

    public void setUp() throws Exception {
        super.setUp();
        this.vertx = new Vertx(((VertxTestBase)this).vertx);
    }

    @Test
    @Repeat(times=100)
    public void flowableToAsyncFile() throws Exception {
        this.sourceToAsyncFile((flow, asyncFile) -> Completable.create(emitter -> flow.subscribe((FlowableSubscriber)asyncFile.toSubscriber().onWriteStreamEnd(() -> ((CompletableEmitter)emitter).onComplete()))));
    }

    @Test
    @Repeat(times=100)
    public void observableToAsyncFile() throws Exception {
        this.sourceToAsyncFile((flow, asyncFile) -> Completable.create(emitter -> flow.toObservable().subscribe((Observer)asyncFile.toObserver().onWriteStreamEnd(() -> ((CompletableEmitter)emitter).onComplete()))));
    }

    private void sourceToAsyncFile(BiFunction<Flowable<Buffer>, AsyncFile, Completable> func) throws Exception {
        File file = TestUtils.tmpFile((String)"txt");
        this.assertTrue(!file.exists() || file.delete());
        List bytes = IntStream.range(0, 131072).boxed().map(step -> (byte)TestUtils.randomChar()).collect(Collectors.toList());
        Flowable flow = Flowable.fromIterable(bytes).buffer(256, () -> new ArrayList(256)).map(ba -> {
            Buffer buffer = Buffer.buffer();
            ba.forEach(arg_0 -> ((Buffer)buffer).appendByte(arg_0));
            return buffer;
        });
        Completable writeToFile = this.vertx.fileSystem().rxOpen(file.toString(), new OpenOptions().setWrite(true)).flatMapCompletable(asyncFile -> (Completable)func.apply((Flowable<Buffer>)flow, (AsyncFile)asyncFile));
        ((TestObserver)writeToFile.andThen((SingleSource)this.vertx.fileSystem().rxReadFile(file.toString())).test().await()).assertValue((Object)bytes.stream().collect(Buffer::buffer, Buffer::appendByte, Buffer::appendBuffer));
    }
}

