/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.rabbitmq;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BasicProperties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rabbitmq.QueueOptions;
import io.vertx.rabbitmq.RabbitMQConfirmation;
import io.vertx.rabbitmq.RabbitMQOptions;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.rabbitmq.RabbitMQConsumer;
import io.vertx.rxjava.rabbitmq.RabbitMQMessage;
import java.util.Map;
import rx.Single;

@RxGen(value=io.vertx.rabbitmq.RabbitMQClient.class)
public class RabbitMQClient {
    public static final TypeArg<RabbitMQClient> __TYPE_ARG = new TypeArg(obj -> new RabbitMQClient((io.vertx.rabbitmq.RabbitMQClient)obj), RabbitMQClient::getDelegate);
    private final io.vertx.rabbitmq.RabbitMQClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RabbitMQClient that = (RabbitMQClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RabbitMQClient(io.vertx.rabbitmq.RabbitMQClient delegate) {
        this.delegate = delegate;
    }

    public RabbitMQClient(Object delegate) {
        this.delegate = (io.vertx.rabbitmq.RabbitMQClient)delegate;
    }

    public io.vertx.rabbitmq.RabbitMQClient getDelegate() {
        return this.delegate;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static RabbitMQClient create(io.vertx.rxjava.core.Vertx vertx, RabbitMQOptions config) {
        RabbitMQClient ret = RabbitMQClient.newInstance(io.vertx.rabbitmq.RabbitMQClient.create((Vertx)vertx.getDelegate(), (RabbitMQOptions)config));
        return ret;
    }

    public void basicAck(long deliveryTag, boolean multiple, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicAck(deliveryTag, multiple, resultHandler);
    }

    public void basicAck(long deliveryTag, boolean multiple) {
        this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicAck(long deliveryTag, boolean multiple) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicAck(deliveryTag, multiple, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicNack(deliveryTag, multiple, requeue, resultHandler);
    }

    public void basicNack(long deliveryTag, boolean multiple, boolean requeue) {
        this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicNack(long deliveryTag, boolean multiple, boolean requeue) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicNack(deliveryTag, multiple, requeue, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicGet(String queue, boolean autoAck, final Handler<AsyncResult<RabbitMQMessage>> resultHandler) {
        this.delegate.basicGet(queue, autoAck, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQMessage>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQMessage> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQMessage.newInstance((io.vertx.rabbitmq.RabbitMQMessage)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicGet(String queue, boolean autoAck) {
        this.basicGet(queue, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQMessage> rxBasicGet(String queue, boolean autoAck) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicGet(queue, autoAck, (Handler<AsyncResult<RabbitMQMessage>>)fut)));
    }

    public void basicConsumer(String queue, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue) {
        this.basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicConsumer(String queue, QueueOptions options, final Handler<AsyncResult<RabbitMQConsumer>> resultHandler) {
        this.delegate.basicConsumer(queue, options, (Handler)new Handler<AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer>>(){

            public void handle(AsyncResult<io.vertx.rabbitmq.RabbitMQConsumer> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)RabbitMQConsumer.newInstance((io.vertx.rabbitmq.RabbitMQConsumer)ar.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void basicConsumer(String queue, QueueOptions options) {
        this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)((Handler)ar -> {}));
    }

    public Single<RabbitMQConsumer> rxBasicConsumer(String queue, QueueOptions options) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicConsumer(queue, options, (Handler<AsyncResult<RabbitMQConsumer>>)fut)));
    }

    public void basicPublish(String exchange, String routingKey, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, Buffer body) {
        this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicPublish(String exchange, String routingKey, Buffer body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicPublish(exchange, routingKey, body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void addConfirmListener(int maxQueueSize, final Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>> resultHandler) {
        this.delegate.addConfirmListener(maxQueueSize, (Handler)new Handler<AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>>>(){

            public void handle(AsyncResult<io.vertx.core.streams.ReadStream<RabbitMQConfirmation>> ar) {
                if (ar.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture(ReadStream.newInstance((io.vertx.core.streams.ReadStream)ar.result(), TypeArg.unknown())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
    }

    public void addConfirmListener(int maxQueueSize) {
        this.addConfirmListener(maxQueueSize, (Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>>)((Handler)ar -> {}));
    }

    public Single<ReadStream<RabbitMQConfirmation>> rxAddConfirmListener(int maxQueueSize) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.addConfirmListener(maxQueueSize, (Handler<AsyncResult<ReadStream<RabbitMQConfirmation>>>)fut)));
    }

    public void confirmSelect(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.confirmSelect(resultHandler);
    }

    public void confirmSelect() {
        this.confirmSelect((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxConfirmSelect() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.confirmSelect((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(resultHandler);
    }

    public void waitForConfirms() {
        this.waitForConfirms((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWaitForConfirms() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.waitForConfirms((Handler<AsyncResult<Void>>)fut)));
    }

    public void waitForConfirms(long timeout, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.waitForConfirms(timeout, resultHandler);
    }

    public void waitForConfirms(long timeout) {
        this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxWaitForConfirms(long timeout) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.waitForConfirms(timeout, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, resultHandler);
    }

    public void basicQos(int prefetchCount) {
        this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicQos(int prefetchCount) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchCount, boolean global) {
        this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicQos(int prefetchCount, boolean global) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicQos(prefetchSize, prefetchCount, global, resultHandler);
    }

    public void basicQos(int prefetchSize, int prefetchCount, boolean global) {
        this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicQos(int prefetchSize, int prefetchCount, boolean global) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicQos(prefetchSize, prefetchCount, global, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type, durable, autoDelete, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, config, resultHandler);
    }

    public void exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, JsonObject config) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeDeclare(exchange, type, durable, autoDelete, config, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeDelete(String exchange, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeDelete(exchange, resultHandler);
    }

    public void exchangeDelete(String exchange) {
        this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeDelete(String exchange) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeDelete(exchange, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, resultHandler);
    }

    public void exchangeBind(String destination, String source, String routingKey) {
        this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeBind(String destination, String source, String routingKey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeBind(destination, source, routingKey, arguments, resultHandler);
    }

    public void exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeBind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeBind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, resultHandler);
    }

    public void exchangeUnbind(String destination, String source, String routingKey) {
        this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeUnbind(String destination, String source, String routingKey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.exchangeUnbind(destination, source, routingKey, arguments, resultHandler);
    }

    public void exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        this.exchangeUnbind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxExchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.exchangeUnbind(destination, source, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueDeclareAuto(Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.queueDeclareAuto(resultHandler);
    }

    public void queueDeclareAuto() {
        this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)((Handler)ar -> {}));
    }

    public Single<JsonObject> rxQueueDeclareAuto() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueDeclareAuto((Handler<AsyncResult<JsonObject>>)fut)));
    }

    public void queueBind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, resultHandler);
    }

    public void queueBind(String queue, String exchange, String routingKey) {
        this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxQueueBind(String queue, String exchange, String routingKey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueBind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueBind(queue, exchange, routingKey, arguments, resultHandler);
    }

    public void queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueBind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxQueueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueBind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, resultHandler);
    }

    public void queueUnbind(String queue, String exchange, String routingKey) {
        this.queueUnbind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxQueueUnbind(String queue, String exchange, String routingKey) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue, exchange, routingKey, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.queueUnbind(queue, exchange, routingKey, arguments, resultHandler);
    }

    public void queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        this.queueUnbind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxQueueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueUnbind(queue, exchange, routingKey, arguments, (Handler<AsyncResult<Void>>)fut)));
    }

    public void messageCount(String queue, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.messageCount(queue, resultHandler);
    }

    public void messageCount(String queue) {
        this.messageCount(queue, (Handler<AsyncResult<Long>>)((Handler)ar -> {}));
    }

    public Single<Long> rxMessageCount(String queue) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.messageCount(queue, (Handler<AsyncResult<Long>>)fut)));
    }

    public void start(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.start(resultHandler);
    }

    public void start() {
        this.start((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxStart() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.start((Handler<AsyncResult<Void>>)fut)));
    }

    public void stop(Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.stop(resultHandler);
    }

    public void stop() {
        this.stop((Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxStop() {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.stop((Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isConnected() {
        boolean ret = this.delegate.isConnected();
        return ret;
    }

    public void restartConnect(int attempts, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.restartConnect(attempts, resultHandler);
    }

    public void restartConnect(int attempts) {
        this.restartConnect(attempts, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxRestartConnect(int attempts) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.restartConnect(attempts, (Handler<AsyncResult<Void>>)fut)));
    }

    public boolean isOpenChannel() {
        boolean ret = this.delegate.isOpenChannel();
        return ret;
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublish(exchange, routingKey, properties, body.getDelegate(), resultHandler);
    }

    public void basicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        this.basicPublish(exchange, routingKey, properties, body, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicPublish(String exchange, String routingKey, BasicProperties properties, Buffer body) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicPublish(exchange, routingKey, properties, body, (Handler<AsyncResult<Void>>)fut)));
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.basicPublishWithDeliveryTag(exchange, routingKey, properties, body.getDelegate(), deliveryTagHandler, resultHandler);
    }

    public void basicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, (Handler<AsyncResult<Void>>)((Handler)ar -> {}));
    }

    public Single<Void> rxBasicPublishWithDeliveryTag(String exchange, String routingKey, BasicProperties properties, Buffer body, Handler<Long> deliveryTagHandler) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.basicPublishWithDeliveryTag(exchange, routingKey, properties, body, deliveryTagHandler, (Handler<AsyncResult<Void>>)fut)));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, resultHandler);
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue, durable, exclusive, autoDelete, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)fut)));
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config, Handler<AsyncResult<AMQP.Queue.DeclareOk>> resultHandler) {
        this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, config, resultHandler);
    }

    public void queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeclareOk> rxQueueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, JsonObject config) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueDeclare(queue, durable, exclusive, autoDelete, config, (Handler<AsyncResult<AMQP.Queue.DeclareOk>>)fut)));
    }

    public void queueDelete(String queue, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDelete(queue, resultHandler);
    }

    public void queueDelete(String queue) {
        this.queueDelete(queue, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDelete(String queue) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueDelete(queue, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)fut)));
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty, Handler<AsyncResult<AMQP.Queue.DeleteOk>> resultHandler) {
        this.delegate.queueDeleteIf(queue, ifUnused, ifEmpty, resultHandler);
    }

    public void queueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)((Handler)ar -> {}));
    }

    public Single<AMQP.Queue.DeleteOk> rxQueueDeleteIf(String queue, boolean ifUnused, boolean ifEmpty) {
        return Single.create((Single.OnSubscribe)new SingleOnSubscribeAdapter(fut -> this.queueDeleteIf(queue, ifUnused, ifEmpty, (Handler<AsyncResult<AMQP.Queue.DeleteOk>>)fut)));
    }

    public static RabbitMQClient newInstance(io.vertx.rabbitmq.RabbitMQClient arg) {
        return arg != null ? new RabbitMQClient(arg) : null;
    }
}

