/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.streams;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.Handler;

/**
 * Represents a stream of items that can be read from.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.rxjava.core.streams.Pump} to pump data from it
 * to a {@link io.vertx.rxjava.core.streams.WriteStream}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.ReadStream original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.streams.ReadStream.class)
public interface ReadStream<T> extends StreamBase {

  io.vertx.core.streams.ReadStream getDelegate();

  /**
   * Set an exception handler on the read stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> exceptionHandler(Handler<Throwable> handler);

  /**
   * Set a data handler. As data is read, the handler will be called with the data.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> handler(Handler<T> handler);

  /**
   * Pause the <code>ReadSupport</code>. While it's paused, no data will be sent to the <code>dataHandler</code>
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> pause();

  /**
   * Resume reading. If the <code>ReadSupport</code> has been paused, reading will recommence on it.
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> resume();

  /**
   * Set an end handler. Once the stream has ended, and there is no more data to be read, this handler will be called.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> endHandler(Handler<Void> endHandler);

  rx.Observable<T> toObservable();


  public static <T>ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg) {
    return arg != null ? new ReadStreamImpl<T>(arg) : null;
  }

  public static <T>ReadStream<T> newInstance(io.vertx.core.streams.ReadStream arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new ReadStreamImpl<T>(arg, __typeArg_T) : null;
  }
}

class ReadStreamImpl<T> implements ReadStream<T> {
  private final io.vertx.core.streams.ReadStream delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public ReadStreamImpl(io.vertx.core.streams.ReadStream delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.streams.ReadStream getDelegate() {
    return delegate;
  }

  private rx.Observable<T> observable;

  public synchronized rx.Observable<T> toObservable() {
    if (observable == null) {
      java.util.function.Function<Object, T> conv = (java.util.function.Function<Object, T>) __typeArg_0.wrap;
      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  /**
   * Set an exception handler on the read stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Set a data handler. As data is read, the handler will be called with the data.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> handler(Handler<T> handler) { 
    delegate.handler(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    });
    return this;
  }

  /**
   * Pause the <code>ReadSupport</code>. While it's paused, no data will be sent to the <code>dataHandler</code>
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> pause() { 
    delegate.pause();
    return this;
  }

  /**
   * Resume reading. If the <code>ReadSupport</code> has been paused, reading will recommence on it.
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Set an end handler. Once the stream has ended, and there is no more data to be read, this handler will be called.
   * @param endHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public ReadStream<T> endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

}
