/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.metrics.Measured;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.net.NetClient.class)
public class NetClient implements Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<NetClient> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  /**
   * Whether the metrics are enabled for this measured object
   * @return true if the metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public NetClient connect(int port, String host, Handler<AsyncResult<NetSocket>> connectHandler) { 
    delegate.connect(port, host, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return 
   * @deprecated use {@link #rxConnect} instead
   */
  @Deprecated()
  public Observable<NetSocket> connectObservable(int port, String host) { 
    io.vertx.rx.java.ObservableFuture<NetSocket> connectHandler = io.vertx.rx.java.RxHelper.observableFuture();
    connect(port, host, connectHandler.toHandler());
    return connectHandler;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @return 
   */
  public Single<NetSocket> rxConnect(int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public NetClient connect(int port, String host, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) { 
    delegate.connect(port, host, serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return 
   * @deprecated use {@link #rxConnect} instead
   */
  @Deprecated()
  public Observable<NetSocket> connectObservable(int port, String host, String serverName) { 
    io.vertx.rx.java.ObservableFuture<NetSocket> connectHandler = io.vertx.rx.java.RxHelper.observableFuture();
    connect(port, host, serverName, connectHandler.toHandler());
    return connectHandler;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return 
   */
  public Single<NetSocket> rxConnect(int port, String host, String serverName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(port, host, serverName, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public NetClient connect(SocketAddress remoteAddress, Handler<AsyncResult<NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return 
   * @deprecated use {@link #rxConnect} instead
   */
  @Deprecated()
  public Observable<NetSocket> connectObservable(SocketAddress remoteAddress) { 
    io.vertx.rx.java.ObservableFuture<NetSocket> connectHandler = io.vertx.rx.java.RxHelper.observableFuture();
    connect(remoteAddress, connectHandler.toHandler());
    return connectHandler;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @return 
   */
  public Single<NetSocket> rxConnect(SocketAddress remoteAddress) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(remoteAddress, fut);
    }));
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @param connectHandler 
   * @return a reference to this, so the API can be used fluently
   */
  public NetClient connect(SocketAddress remoteAddress, String serverName, Handler<AsyncResult<NetSocket>> connectHandler) { 
    delegate.connect(remoteAddress.getDelegate(), serverName, new Handler<AsyncResult<io.vertx.core.net.NetSocket>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
        if (ar.succeeded()) {
          connectHandler.handle(io.vertx.core.Future.succeededFuture(NetSocket.newInstance(ar.result())));
        } else {
          connectHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return 
   * @deprecated use {@link #rxConnect} instead
   */
  @Deprecated()
  public Observable<NetSocket> connectObservable(SocketAddress remoteAddress, String serverName) { 
    io.vertx.rx.java.ObservableFuture<NetSocket> connectHandler = io.vertx.rx.java.RxHelper.observableFuture();
    connect(remoteAddress, serverName, connectHandler.toHandler());
    return connectHandler;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.rxjava.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return 
   */
  public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(remoteAddress, serverName, fut);
    }));
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   */
  public void close() { 
    delegate.close();
  }


  public static  NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }
}
