/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.MultiMap;
import io.vertx.core.Handler;
import io.vertx.rxjava.core.net.SocketAddress;

/**
 * Represents a server side WebSocket.
 * <p>
 * Instances of this class are passed into a {@link io.vertx.rxjava.core.http.HttpServer#websocketHandler} or provided
 * when a WebSocket handshake is manually {@link io.vertx.rxjava.core.http.HttpServerRequest#upgrade}ed.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.ServerWebSocket original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.http.ServerWebSocket.class)
public class ServerWebSocket implements WebSocketBase {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServerWebSocket that = (ServerWebSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<ServerWebSocket> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new ServerWebSocket((io.vertx.core.http.ServerWebSocket) obj),
    ServerWebSocket::getDelegate
  );

  private final io.vertx.core.http.ServerWebSocket delegate;
  
  public ServerWebSocket(io.vertx.core.http.ServerWebSocket delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.ServerWebSocket getDelegate() {
    return delegate;
  }

  private rx.Observable<Buffer> observable;

  public synchronized rx.Observable<Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param t 
   */
  public void end(Buffer t) { 
    delegate.end(t.getDelegate());
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.ServerWebSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>Websocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the websocket sub protocol selected by the websocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writeTextMessage(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  /**
   * Writes a ping to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section 5.5.2.
   * <p>
   * There is no pingHandler because RFC 6455 section 5.5.2 clearly states that the only response to a ping is a pong
   * with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writePing(Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * Writes a pong to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section 5.5.2.
   * <p>
   * There is no need to manually write a Pong, as the server and client both handle responding to a ping with a pong
   * automatically and this is exposed to users.RFC 6455 Section 5.5.3 states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase writePong(Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.ServerWebSocket#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase binaryMessageHandler(Handler<Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Set a pong message handler on the connection.  This handler will be invoked every time a pong message is received
   * on the server, and can be used by both clients and servers since the RFC 6455 Sections 5.5.2 and 5.5.3 do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since pings should immediately be responded to with a pong with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public WebSocketBase pongHandler(Handler<Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Close the WebSocket.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * @return the remote address for this socket
   */
  public SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    SocketAddress ret = SocketAddress.newInstance(delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this socket
   */
  public SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    SocketAddress ret = SocketAddress.newInstance(delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  public ServerWebSocket exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public ServerWebSocket handler(Handler<Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  public ServerWebSocket pause() { 
    delegate.pause();
    return this;
  }

  public ServerWebSocket resume() { 
    delegate.resume();
    return this;
  }

  public ServerWebSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public ServerWebSocket write(Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public ServerWebSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public ServerWebSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public ServerWebSocket writeFrame(WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  public ServerWebSocket writeFinalTextFrame(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  public ServerWebSocket writeFinalBinaryFrame(Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  public ServerWebSocket writeBinaryMessage(Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  public ServerWebSocket closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  public ServerWebSocket frameHandler(Handler<WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(WebSocketFrame.newInstance(event));
      }
    });
    return this;
  }

  public String uri() { 
    String ret = delegate.uri();
    return ret;
  }

  /**
   * @return the WebSocket handshake path.
   */
  public String path() { 
    String ret = delegate.path();
    return ret;
  }

  /**
   * @return the WebSocket handshake query string.
   */
  public String query() { 
    String ret = delegate.query();
    return ret;
  }

  /**
   * @return the headers in the WebSocket handshake
   */
  public MultiMap headers() { 
    if (cached_2 != null) {
      return cached_2;
    }
    MultiMap ret = MultiMap.newInstance(delegate.headers());
    cached_2 = ret;
    return ret;
  }

  /**
   * Accept the WebSocket and terminate the WebSocket handshake.
   * <p/>
   * This method should be called from the websocket handler to explicitely accept the websocker and
   * terminate the WebSocket handshake.
   */
  public void accept() { 
    delegate.accept();
  }

  /**
   * Reject the WebSocket.
   * <p>
   * Calling this method from the websocket handler when it is first passed to you gives you the opportunity to reject
   * the websocket, which will cause the websocket handshake to fail by returning
   * a  response code.
   * <p>
   * You might use this method, if for example you only want to accept WebSockets with a particular path.
   */
  public void reject() { 
    delegate.reject();
  }

  /**
   * Like {@link io.vertx.rxjava.core.http.ServerWebSocket#reject} but with a <code>status</code>.
   * @param status 
   */
  public void reject(int status) { 
    delegate.reject(status);
  }

  private SocketAddress cached_0;
  private SocketAddress cached_1;
  private MultiMap cached_2;

  public static  ServerWebSocket newInstance(io.vertx.core.http.ServerWebSocket arg) {
    return arg != null ? new ServerWebSocket(arg) : null;
  }
}
