/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.rxjava.core.buffer.Buffer;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.core.Handler;

/**
 * Represents an file upload from an HTML FORM.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.HttpServerFileUpload original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.http.HttpServerFileUpload.class)
public class HttpServerFileUpload implements ReadStream<Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HttpServerFileUpload that = (HttpServerFileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<HttpServerFileUpload> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new HttpServerFileUpload((io.vertx.core.http.HttpServerFileUpload) obj),
    HttpServerFileUpload::getDelegate
  );

  private final io.vertx.core.http.HttpServerFileUpload delegate;
  
  public HttpServerFileUpload(io.vertx.core.http.HttpServerFileUpload delegate) {
    this.delegate = delegate;
  }

  public io.vertx.core.http.HttpServerFileUpload getDelegate() {
    return delegate;
  }

  private rx.Observable<Buffer> observable;

  public synchronized rx.Observable<Buffer> toObservable() {
    if (observable == null) {
      java.util.function.Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
      observable = io.vertx.rx.java.RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  public HttpServerFileUpload exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public HttpServerFileUpload handler(Handler<Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(Buffer.newInstance(event));
      }
    });
    return this;
  }

  public HttpServerFileUpload endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public HttpServerFileUpload pause() { 
    delegate.pause();
    return this;
  }

  public HttpServerFileUpload resume() { 
    delegate.resume();
    return this;
  }

  /**
   * Stream the content of this upload to the given file on storage.
   * @param filename the name of the file
   * @return 
   */
  public HttpServerFileUpload streamToFileSystem(String filename) { 
    delegate.streamToFileSystem(filename);
    return this;
  }

  /**
   * @return the filename which was used when upload the file.
   */
  public String filename() { 
    String ret = delegate.filename();
    return ret;
  }

  /**
   * @return the name of the attribute
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the content type for the upload
   */
  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the contentTransferEncoding for the upload
   */
  public String contentTransferEncoding() { 
    String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset for the upload
   */
  public String charset() { 
    String ret = delegate.charset();
    return ret;
  }

  /**
   * The size of the upload may not be available until it is all read.
   * Check {@link io.vertx.rxjava.core.http.HttpServerFileUpload#isSizeAvailable} to determine this
   * @return the size of the upload (in bytes)
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return true if the size of the upload can be retrieved via {@link io.vertx.rxjava.core.http.HttpServerFileUpload#size}.
   */
  public boolean isSizeAvailable() { 
    boolean ret = delegate.isSizeAvailable();
    return ret;
  }


  public static  HttpServerFileUpload newInstance(io.vertx.core.http.HttpServerFileUpload arg) {
    return arg != null ? new HttpServerFileUpload(arg) : null;
  }
}
