/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.eventbus;

import java.util.Map;
import rx.Observable;
import rx.Single;

/**
 *
 * Encapsulates a message being sent from Vert.x. Used with event bus interceptors
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.SendContext original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.eventbus.SendContext.class)
public class SendContext<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SendContext that = (SendContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<SendContext> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new SendContext((io.vertx.core.eventbus.SendContext) obj),
    SendContext::getDelegate
  );

  private final io.vertx.core.eventbus.SendContext delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public SendContext(io.vertx.core.eventbus.SendContext delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public SendContext(io.vertx.core.eventbus.SendContext delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.eventbus.SendContext getDelegate() {
    return delegate;
  }

  /**
   * @return The message being sent
   */
  public Message<T> message() { 
    Message<T> ret = Message.newInstance(delegate.message(), __typeArg_0);
    return ret;
  }

  /**
   * Call the next interceptor
   */
  public void next() { 
    delegate.next();
  }

  /**
   * @return true if the message is being sent (point to point) or False if the message is being published
   */
  public boolean send() { 
    boolean ret = delegate.send();
    return ret;
  }

  /**
   * @return the value sent or published (before being processed by the codec)
   */
  public Object sentBody() { 
    Object ret = (Object) delegate.sentBody();
    return ret;
  }


  public static <T>SendContext<T> newInstance(io.vertx.core.eventbus.SendContext arg) {
    return arg != null ? new SendContext<T>(arg) : null;
  }

  public static <T>SendContext<T> newInstance(io.vertx.core.eventbus.SendContext arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new SendContext<T>(arg, __typeArg_T) : null;
  }
}
