/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import java.util.Map;
import rx.Observable;
import rx.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import java.util.function.Function;

/**
 * Represents the result of an action that may, or may not, have occurred yet.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.Future original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.rxjava.RxGen(io.vertx.core.Future.class)
public class Future<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Future that = (Future) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.rxjava.TypeArg<Future> __TYPE_ARG = new io.vertx.lang.rxjava.TypeArg<>(
    obj -> new Future((io.vertx.core.Future) obj),
    Future::getDelegate
  );

  private final io.vertx.core.Future delegate;
  public final io.vertx.lang.rxjava.TypeArg<T> __typeArg_0;
  
  public Future(io.vertx.core.Future delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.vertx.lang.rxjava.TypeArg.unknown();
  }

  public Future(io.vertx.core.Future delegate, io.vertx.lang.rxjava.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.core.Future getDelegate() {
    return delegate;
  }

  /**
   * Create a future that hasn't completed yet and that is passed to the <code>handler</code> before it is returned.
   * @param handler the handler
   * @return the future.
   */
  public static <T> Future<T> future(Handler<Future<T>> handler) { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.future(new Handler<io.vertx.core.Future<T>>() {
      public void handle(io.vertx.core.Future<T> event) {
        handler.handle(Future.newInstance(event, io.vertx.lang.rxjava.TypeArg.unknown()));
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a future that hasn't completed yet
   * @return the future
   */
  public static <T> Future<T> future() { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.future(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a succeeded future with a null result
   * @return the future
   */
  public static <T> Future<T> succeededFuture() { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.succeededFuture(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Created a succeeded future with the specified result.
   * @param result the result
   * @return the future
   */
  public static <T> Future<T> succeededFuture(T result) { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.succeededFuture(result), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a failed future with the specified failure cause.
   * @param t the failure cause as a Throwable
   * @return the future
   */
  public static <T> Future<T> failedFuture(Throwable t) { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.failedFuture(t), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Create a failed future with the specified failure message.
   * @param failureMessage the failure message
   * @return the future
   */
  public static <T> Future<T> failedFuture(String failureMessage) { 
    Future<T> ret = Future.newInstance(io.vertx.core.Future.failedFuture(failureMessage), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Has the future completed?
   * <p>
   * It's completed if it's either succeeded or failed.
   * @return true if completed, false if not
   */
  public boolean isComplete() { 
    boolean ret = delegate.isComplete();
    return ret;
  }

  /**
   * Set a handler for the result.
   * <p>
   * If the future has already been completed it will be called immediately. Otherwise it will be called when the
   * future is completed.
   * @param handler the Handler that will be called with the result
   * @return a reference to this, so it can be used fluently
   */
  public Future<T> setHandler(Handler<AsyncResult<T>> handler) { 
    delegate.setHandler(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

  /**
   * Set a handler for the result.
   * <p>
   * If the future has already been completed it will be called immediately. Otherwise it will be called when the
   * future is completed.
   * @return 
   * @deprecated use {@link #rxSetHandler} instead
   */
  @Deprecated()
  public Observable<T> setHandlerObservable() { 
    io.vertx.rx.java.ObservableFuture<T> handler = io.vertx.rx.java.RxHelper.observableFuture();
    setHandler(handler.toHandler());
    return handler;
  }

  /**
   * Set a handler for the result.
   * <p>
   * If the future has already been completed it will be called immediately. Otherwise it will be called when the
   * future is completed.
   * @return 
   */
  public Single<T> rxSetHandler() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setHandler(fut);
    }));
  }

  /**
   * Set the result. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   */
  public void complete(T result) { 
    delegate.complete(__typeArg_0.unwrap(result));
  }

  /**
   *  Set a null result. Any handler will be called, if there is one, and the future will be marked as completed.
   */
  public void complete() { 
    delegate.complete();
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param cause the failure cause
   */
  public void fail(Throwable cause) { 
    delegate.fail(cause);
  }

  /**
   * Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @param failureMessage the failure message
   */
  public void fail(String failureMessage) { 
    delegate.fail(failureMessage);
  }

  /**
   * Set the failure. Any handler will be called, if there is one, and the future will be marked as completed.
   * @param result the result
   * @return false when the future is already completed
   */
  public boolean tryComplete(T result) { 
    boolean ret = delegate.tryComplete(__typeArg_0.unwrap(result));
    return ret;
  }

  /**
   * Try to set the result. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @return false when the future is already completed
   */
  public boolean tryComplete() { 
    boolean ret = delegate.tryComplete();
    return ret;
  }

  /**
   * Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @param cause the failure cause
   * @return false when the future is already completed
   */
  public boolean tryFail(Throwable cause) { 
    boolean ret = delegate.tryFail(cause);
    return ret;
  }

  /**
   * Try to set the failure. When it happens, any handler will be called, if there is one, and the future will be marked as completed.
   * @param failureMessage the failure message
   * @return false when the future is already completed
   */
  public boolean tryFail(String failureMessage) { 
    boolean ret = delegate.tryFail(failureMessage);
    return ret;
  }

  /**
   * The result of the operation. This will be null if the operation failed.
   * @return the result or null if the operation failed.
   */
  public T result() { 
    T ret = (T)__typeArg_0.wrap(delegate.result());
    return ret;
  }

  /**
   * A Throwable describing failure. This will be null if the operation succeeded.
   * @return the cause or null if the operation succeeded.
   */
  public Throwable cause() { 
    Throwable ret = delegate.cause();
    return ret;
  }

  /**
   * Did it succeed?
   * @return true if it succeded or false otherwise
   */
  public boolean succeeded() { 
    boolean ret = delegate.succeeded();
    return ret;
  }

  /**
   * Did it fail?
   * @return true if it failed or false otherwise
   */
  public boolean failed() { 
    boolean ret = delegate.failed();
    return ret;
  }

  /**
   * Compose this future with a provided <code>next</code> future.<p>
   *
   * When this (the one on which <code>compose</code> is called) future succeeds, the <code>handler</code> will be called with
   * the completed value, this handler should complete the next future.<p>
   *
   * If the <code>handler</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the <code>next</code> future and the <code>handler</code>
   * will not be called.
   * @param handler the handler
   * @param next the next future
   * @return the next future, used for chaining
   */
  public <U> Future<U> compose(Handler<T> handler, Future<U> next) { 
    Future<U> ret = Future.newInstance(delegate.compose(new Handler<T>() {
      public void handle(T event) {
        handler.handle((T)__typeArg_0.wrap(event));
      }
    }, next.getDelegate()), next.__typeArg_0);
    return ret;
  }

  /**
   * Compose this future with a <code>mapper</code> function.<p>
   *
   * When this future (the one on which <code>compose</code> is called) succeeds, the <code>mapper</code> will be called with
   * the completed value and this mapper returns another future object. This returned future completion will complete
   * the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the composed future
   */
  public <U> Future<U> compose(Function<T,Future<U>> mapper) { 
    Future<U> ret = Future.newInstance(delegate.compose(new java.util.function.Function<T,io.vertx.core.Future<U>>() {
      public io.vertx.core.Future<U> apply(T arg) {
        Future<U> ret = mapper.apply((T)__typeArg_0.wrap(arg));
        return ret.getDelegate();
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future succeeds, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future fails, the failure will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public <U> Future<U> map(Function<T,U> mapper) { 
    Future<U> ret = Future.newInstance(delegate.map(new java.util.function.Function<T,U>() {
      public U apply(T arg) {
        U ret = mapper.apply((T)__typeArg_0.wrap(arg));
        return ret;
      }
    }), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Map the result of a future to a specific <code>value</code>.<p>
   *
   * When this future succeeds, this <code>value</code> will complete the future returned by this method call.<p>
   *
   * When this future fails, the failure will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public <V> Future<V> map(V value) { 
    Future<V> ret = Future.newInstance(delegate.map(value), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * Map the result of a future to <code>null</code>.<p>
   *
   * This is a conveniency for <code>future.map((T) null)</code> or <code>future.map((Void) null)</code>.<p>
   *
   * When this future succeeds, <code>null</code> will complete the future returned by this method call.<p>
   *
   * When this future fails, the failure will be propagated to the returned future.
   * @return the mapped future
   */
  public <V> Future<V> mapEmpty() { 
    Future<V> ret = Future.newInstance(delegate.mapEmpty(), io.vertx.lang.rxjava.TypeArg.unknown());
    return ret;
  }

  /**
   * @return an handler completing this future
   */
  public Handler<AsyncResult<T>> completer() { 
    if (cached_0 != null) {
      return cached_0;
    }
    Handler<AsyncResult<T>> ret = new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          delegate.completer().handle(io.vertx.core.Future.succeededFuture(__typeArg_0.unwrap(ar.result())));
        } else {
          delegate.completer().handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    };
    cached_0 = ret;
    return ret;
  }

  /**
   * Handles a failure of this Future by returning the result of another Future.
   * If the mapper fails, then the returned future will be failed with this failure.
   * @param mapper A function which takes the exception of a failure and returns a new future.
   * @return A recovered future
   */
  public Future<T> recover(Function<Throwable,Future<T>> mapper) { 
    Future<T> ret = Future.newInstance(delegate.recover(new java.util.function.Function<java.lang.Throwable,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(java.lang.Throwable arg) {
        Future<T> ret = mapper.apply(arg);
        return ret.getDelegate();
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * Apply a <code>mapper</code> function on this future.<p>
   *
   * When this future fails, the <code>mapper</code> will be called with the completed value and this mapper
   * returns a value. This value will complete the future returned by this method call.<p>
   *
   * If the <code>mapper</code> throws an exception, the returned future will be failed with this exception.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future and the <code>mapper</code>
   * will not be called.
   * @param mapper the mapper function
   * @return the mapped future
   */
  public Future<T> otherwise(Function<Throwable,T> mapper) { 
    Future<T> ret = Future.newInstance(delegate.otherwise(new java.util.function.Function<java.lang.Throwable,T>() {
      public T apply(java.lang.Throwable arg) {
        T ret = mapper.apply(arg);
        return __typeArg_0.unwrap(ret);
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * Map the failure of a future to a specific <code>value</code>.<p>
   *
   * When this future fails, this <code>value</code> will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @param value the value that eventually completes the mapped future
   * @return the mapped future
   */
  public Future<T> otherwise(T value) { 
    Future<T> ret = Future.newInstance(delegate.otherwise(__typeArg_0.unwrap(value)), __typeArg_0);
    return ret;
  }

  /**
   * Map the failure of a future to <code>null</code>.<p>
   *
   * This is a convenience for <code>future.otherwise((T) null)</code>.<p>
   *
   * When this future fails, the <code>null</code> value will complete the future returned by this method call.<p>
   *
   * When this future succeeds, the result will be propagated to the returned future.
   * @return the mapped future
   */
  public Future<T> otherwiseEmpty() { 
    Future<T> ret = Future.newInstance(delegate.otherwiseEmpty(), __typeArg_0);
    return ret;
  }

  private Handler<AsyncResult<T>> cached_0;

  public static <T>Future<T> newInstance(io.vertx.core.Future arg) {
    return arg != null ? new Future<T>(arg) : null;
  }

  public static <T>Future<T> newInstance(io.vertx.core.Future arg, io.vertx.lang.rxjava.TypeArg<T> __typeArg_T) {
    return arg != null ? new Future<T>(arg, __typeArg_T) : null;
  }
}
