/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test.api;

import com.acme.rxjava.pkg.MyInterface;
import com.acme.rxjava.pkg.sub.SubInterface;
import io.vertx.codegen.testmodel.RefedInterface1Impl;
import io.vertx.codegen.testmodel.TestDataObject;
import io.vertx.codegen.testmodel.TestEnum;
import io.vertx.codegen.testmodel.TestInterfaceImpl;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.rx.java.test.AsyncResultChecker;
import io.vertx.rxjava.codegen.testmodel.Factory;
import io.vertx.rxjava.codegen.testmodel.RefedInterface1;
import io.vertx.rxjava.codegen.testmodel.RefedInterface2;
import io.vertx.rxjava.codegen.testmodel.TestInterface;
import io.vertx.test.core.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import rx.Observable;

public class ApiTest {
    final TestInterface obj = new TestInterface(new TestInterfaceImpl());

    @Test
    public void testMethodWithBasicParams() {
        this.obj.methodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
    }

    @Test
    public void testMethodWithBasicBoxedParams() {
        this.obj.methodWithBasicBoxedParams((byte)123, (short)12345, 1234567, 1265615234L, Float.valueOf(12.345f), 12.34566, true, Character.valueOf('X'));
    }

    @Test
    public void testMethodWithHandlerBasicTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerBasicTypes(checker.expectedResult((byte)123), checker.expectedResult((short)12345), checker.expectedResult(1234567), checker.expectedResult(1265615234L), checker.expectedResult(Float.valueOf(12.345f)), checker.expectedResult(12.34566), checker.expectedResult(true), checker.expectedResult(Character.valueOf('X')), checker.expectedResult("quux!"));
        Assert.assertEquals((long)9L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultBasicTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultByte(false, checker.asyncExpectedResult((byte)123));
        this.obj.methodWithHandlerAsyncResultShort(false, checker.asyncExpectedResult((short)12345));
        this.obj.methodWithHandlerAsyncResultInteger(false, checker.asyncExpectedResult(1234567));
        this.obj.methodWithHandlerAsyncResultLong(false, checker.asyncExpectedResult(1265615234L));
        this.obj.methodWithHandlerAsyncResultFloat(false, checker.asyncExpectedResult(Float.valueOf(12.345f)));
        this.obj.methodWithHandlerAsyncResultDouble(false, checker.asyncExpectedResult(12.34566));
        this.obj.methodWithHandlerAsyncResultBoolean(false, checker.asyncExpectedResult(true));
        this.obj.methodWithHandlerAsyncResultCharacter(false, checker.asyncExpectedResult(Character.valueOf('X')));
        this.obj.methodWithHandlerAsyncResultString(false, checker.asyncExpectedResult("quux!"));
        Assert.assertEquals((long)9L, (long)checker.count);
        checker.count = 0;
        this.obj.methodWithHandlerAsyncResultByte(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultShort(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultInteger(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultLong(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultFloat(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultDouble(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultBoolean(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultCharacter(true, checker.failureAsserter("foobar!"));
        this.obj.methodWithHandlerAsyncResultString(true, checker.failureAsserter("foobar!"));
        Assert.assertEquals((long)9L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureBasicTypes() throws Exception {
        Assert.assertEquals((long)123L, (long)this.get(this.obj.methodWithHandlerAsyncResultByteObservable(false)).byteValue());
        Assert.assertEquals((long)12345L, (long)this.get(this.obj.methodWithHandlerAsyncResultShortObservable(false)).shortValue());
        Assert.assertEquals((long)1234567L, (long)this.get(this.obj.methodWithHandlerAsyncResultIntegerObservable(false)).intValue());
        Assert.assertEquals((long)1265615234L, (long)this.get(this.obj.methodWithHandlerAsyncResultLongObservable(false)));
        Assert.assertEquals((float)12.345f, (float)this.get(this.obj.methodWithHandlerAsyncResultFloatObservable(false)).floatValue(), (float)0.0f);
        Assert.assertEquals((double)12.34566, (double)this.get(this.obj.methodWithHandlerAsyncResultDoubleObservable(false)), (double)0.0);
        Assert.assertEquals((Object)true, (Object)this.get(this.obj.methodWithHandlerAsyncResultBooleanObservable(false)));
        Assert.assertEquals((long)88L, (long)this.get(this.obj.methodWithHandlerAsyncResultCharacterObservable(false)).charValue());
        Assert.assertEquals((Object)"quux!", (Object)this.get(this.obj.methodWithHandlerAsyncResultStringObservable(false)));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultByteObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultShortObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultIntegerObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultLongObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultFloatObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultDoubleObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultBooleanObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultCharacterObservable(true));
        this.assertFailure("foobar!", this.obj.methodWithHandlerAsyncResultStringObservable(true));
    }

    private <T> T get(Observable<T> future) throws Exception {
        return (T)future.toBlocking().first();
    }

    private <T> void assertFailure(String message, Observable<T> future) throws Exception {
        try {
            future.toBlocking().first();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testMethodWithUserTypes() {
        RefedInterface1 refed = new RefedInterface1(new RefedInterface1Impl());
        refed.setString("aardvarks");
        this.obj.methodWithUserTypes(refed);
    }

    @Test
    public void testObjectParam() {
        this.obj.methodWithObjectParam("JsonObject", new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123)));
        this.obj.methodWithObjectParam("JsonArray", new JsonArray().add("foo").add("bar").add("wib"));
    }

    @Test
    public void testDataObjectParam() {
        TestDataObject options = new TestDataObject();
        options.setFoo("hello");
        options.setBar(123);
        options.setWibble(1.23);
        this.obj.methodWithDataObjectParam(options);
    }

    @Test
    public void testListOfDataObjectsParam() {
        ArrayList<TestDataObject> list = new ArrayList<TestDataObject>();
        TestDataObject object1 = new TestDataObject();
        object1.setFoo("hello");
        object1.setBar(123);
        object1.setWibble(1.23);
        list.add(object1);
        TestDataObject object2 = new TestDataObject();
        object2.setFoo("world");
        object2.setBar(123);
        object2.setWibble(1.23);
        list.add(object2);
        this.obj.methodWithListOfDataObjectsParam(list);
    }

    @Test
    public void testSetOfDataObjectsParam() {
        HashSet<TestDataObject> set = new HashSet<TestDataObject>();
        TestDataObject object1 = new TestDataObject();
        object1.setFoo("hello");
        object1.setBar(123);
        object1.setWibble(1.23);
        set.add(object1);
        TestDataObject object2 = new TestDataObject();
        object2.setFoo("world");
        object2.setBar(123);
        object2.setWibble(1.23);
        set.add(object2);
        this.obj.methodWithSetOfDataObjectsParam(set);
    }

    @Test
    public void testNullDataObjectParam() {
        this.obj.methodWithNullDataObjectParam(null);
    }

    @Test
    public void testMethodWithHandlerDataObject() {
        TestDataObject dataObject = new TestDataObject();
        dataObject.setFoo("foo");
        dataObject.setBar(123);
        AtomicInteger count = new AtomicInteger();
        this.obj.methodWithHandlerDataObject((Handler<TestDataObject>)((Handler)it -> {
            Assert.assertEquals((Object)dataObject.getFoo(), (Object)it.getFoo());
            Assert.assertEquals((long)dataObject.getBar(), (long)it.getBar());
            count.incrementAndGet();
        }));
        Assert.assertEquals((long)1L, (long)count.get());
    }

    @Test
    public void testMethodWithHandlerAsyncResultDataObject() {
        TestDataObject dataObject = new TestDataObject();
        dataObject.setFoo("foo");
        dataObject.setBar(123);
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultDataObject(false, (Handler<AsyncResult<TestDataObject>>)((Handler)result -> {
            Assert.assertTrue((boolean)result.succeeded());
            Assert.assertFalse((boolean)result.failed());
            TestDataObject res = (TestDataObject)result.result();
            Assert.assertEquals((Object)dataObject.getFoo(), (Object)res.getFoo());
            Assert.assertNull((Object)result.cause());
            ++checker.count;
        }));
        this.obj.methodWithHandlerAsyncResultDataObject(true, (Handler<AsyncResult<TestDataObject>>)((Handler)result -> checker.assertAsyncFailure("foobar!", result)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerStringReturn() {
        Handler<String> handler = this.obj.methodWithHandlerStringReturn("the-result");
        handler.handle((Object)"the-result");
        boolean failed = false;
        try {
            handler.handle((Object)"not-expected");
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testMethodWithHandlerGenericReturn() {
        AtomicReference result = new AtomicReference();
        this.obj.methodWithHandlerGenericReturn(result::set).handle((Object)"the-result");
        Assert.assertEquals((Object)"the-result", result.get());
        this.obj.methodWithHandlerGenericReturn(result::set).handle((Object)this.obj);
        Assert.assertEquals((Object)this.obj, result.get());
    }

    @Test
    public void testMethodWithHandlerVertxGenReturn() {
        this.obj.methodWithHandlerVertxGenReturn("the-gen-result").handle((Object)new RefedInterface1(new RefedInterface1Impl().setString("the-gen-result")));
    }

    @Test
    public void testMethodWithHandlerAsyncResultStringReturn() {
        Handler<AsyncResult<String>> succeedingHandler = this.obj.methodWithHandlerAsyncResultStringReturn("the-result", false);
        succeedingHandler.handle((Object)Future.succeededFuture((Object)"the-result"));
        boolean failed = false;
        try {
            succeedingHandler.handle((Object)Future.succeededFuture((Object)"not-expected"));
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        Handler<AsyncResult<String>> failingHandler = this.obj.methodWithHandlerAsyncResultStringReturn("an-error", true);
        failingHandler.handle((Object)Future.failedFuture((String)"an-error"));
        failed = false;
        try {
            failingHandler.handle((Object)Future.succeededFuture((Object)"whatever"));
        }
        catch (Throwable ignore) {
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
    }

    @Test
    public void testMethodWithHandlerAsyncResultGenericReturn() {
        AtomicReference result = new AtomicReference();
        Handler succeedingHandler = this.obj.methodWithHandlerAsyncResultGenericReturn(ar -> result.set(ar.succeeded() ? ar.result() : ar.cause()));
        succeedingHandler.handle((Object)Future.succeededFuture((Object)"the-result"));
        Assert.assertEquals((Object)"the-result", result.get());
        succeedingHandler.handle((Object)Future.succeededFuture((Object)this.obj));
        Assert.assertEquals((Object)this.obj, result.get());
    }

    @Test
    public void testMethodWithHandlerAsyncResultVertxGenReturn() {
        this.obj.methodWithHandlerAsyncResultVertxGenReturn("the-gen-result", false).handle((Object)Future.succeededFuture((Object)new RefedInterface1(new RefedInterface1Impl().setString("the-gen-result"))));
        this.obj.methodWithHandlerAsyncResultVertxGenReturn("it-failed-dude", true).handle((Object)Future.failedFuture((Throwable)new Exception("it-failed-dude")));
    }

    @Test
    public void testMethodWithHandlerListAndSet() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListAndSet(checker.expectedResult(Arrays.asList("foo", "bar", "wibble")), checker.expectedResult(Arrays.asList(5, 12, 100)), checker.expectedResult(new HashSet<String>(Arrays.asList("foo", "bar", "wibble"))), checker.expectedResult(new HashSet<Integer>(Arrays.asList(5, 12, 100))));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListAndSet() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListString(checker.asyncExpectedResult(Arrays.asList("foo", "bar", "wibble")));
        this.obj.methodWithHandlerAsyncResultListInteger(checker.asyncExpectedResult(Arrays.asList(5, 12, 100)));
        this.obj.methodWithHandlerAsyncResultSetString(checker.asyncExpectedResult(new HashSet<String>(Arrays.asList("foo", "bar", "wibble"))));
        this.obj.methodWithHandlerAsyncResultSetInteger(checker.asyncExpectedResult(new HashSet<Integer>(Arrays.asList(5, 12, 100))));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListAndSet() throws Exception {
        Assert.assertEquals(Arrays.asList("foo", "bar", "wibble"), this.get(this.obj.methodWithHandlerAsyncResultListStringObservable()));
        Assert.assertEquals(Arrays.asList(5, 12, 100), this.get(this.obj.methodWithHandlerAsyncResultListIntegerObservable()));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar", "wibble")), this.get(this.obj.methodWithHandlerAsyncResultSetStringObservable()));
        Assert.assertEquals(new HashSet<Integer>(Arrays.asList(5, 12, 100)), this.get(this.obj.methodWithHandlerAsyncResultSetIntegerObservable()));
    }

    @Test
    public void testMethodWithHandlerListVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListVertxGen(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList("foo", "bar"), it.stream().map(RefedInterface1::getString).collect(Collectors.toList()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListAbstractVertxGen(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList("abstractfoo", "abstractbar"), it.stream().map(RefedInterface2::getString).collect(Collectors.toList()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListVertxGen(checker.asyncResultHandler(event -> {
            Assert.assertEquals((long)2L, (long)event.size());
            Assert.assertEquals((Object)"foo", (Object)((RefedInterface1)event.get(0)).getString());
            Assert.assertEquals((Object)"bar", (Object)((RefedInterface1)event.get(1)).getString());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListAbstractVertxGen(checker.asyncResultHandler(event -> {
            Assert.assertEquals((long)2L, (long)event.size());
            Assert.assertEquals((Object)"abstractfoo", (Object)((RefedInterface2)event.get(0)).getString());
            Assert.assertEquals((Object)"abstractbar", (Object)((RefedInterface2)event.get(1)).getString());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListVertxGen() throws Exception {
        List<RefedInterface1> result = this.get(this.obj.methodWithHandlerAsyncResultListVertxGenObservable());
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"foo", (Object)result.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)result.get(1).getString());
    }

    @Test
    public void testMethodWithHandlerSetVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetVertxGen(checker.resultHandler(event -> {
            List list = event.stream().map(it -> it.getString()).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("bar", "foo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetAbstractVertxGen(checker.resultHandler(event -> {
            List list = event.stream().map(it -> it.getString()).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("abstractbar", "abstractfoo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetVertxGen(checker.asyncResultHandler(event -> {
            List list = event.stream().map(RefedInterface1::getString).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("bar", "foo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetAbstractVertxGen() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetAbstractVertxGen(checker.asyncResultHandler(event -> {
            List list = event.stream().map(RefedInterface2::getString).collect(Collectors.toList());
            Collections.sort(list);
            Assert.assertEquals(Arrays.asList("abstractbar", "abstractfoo"), list);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetVertxGen() throws Exception {
        Set<RefedInterface1> result = this.get(this.obj.methodWithHandlerAsyncResultSetVertxGenObservable());
        List list = result.stream().map(RefedInterface1::getString).collect(Collectors.toList());
        Collections.sort(list);
        Assert.assertEquals(Arrays.asList("bar", "foo"), list);
    }

    @Test
    public void testMethodWithHandlerListJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListJsonObject(checker.expectedResult(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListNullJsonObject(checker.expectedResult(Collections.singletonList(null)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListJsonObject(checker.asyncExpectedResult(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListNullJsonObject(checker.asyncExpectedResult(Collections.singletonList(null)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListJsonObject() throws Exception {
        List<JsonObject> result = this.get(this.obj.methodWithHandlerAsyncResultListJsonObjectObservable());
        Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), result);
    }

    @Test
    public void testMethodWithFutureListNullJsonObject() throws Exception {
        List<JsonObject> result = this.get(this.obj.methodWithHandlerAsyncResultListNullJsonObjectObservable());
        Assert.assertEquals(Collections.singletonList(null), result);
    }

    @Test
    public void testMethodWithHandlerSetJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetJsonObject(checker.resultHandler(r -> Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList(r))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetNullJsonObject(checker.resultHandler(r -> Assert.assertEquals(Collections.singletonList(null), new ArrayList(r))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetNullJsonObject() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetNullJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals(Collections.singletonList(null), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetJsonObject() throws Exception {
        Set<JsonObject> result = this.get(this.obj.methodWithHandlerAsyncResultSetJsonObjectObservable());
        Assert.assertEquals(Arrays.asList(new JsonObject().put("cheese", "stilton"), new JsonObject().put("socks", "tartan")), new ArrayList<JsonObject>(result));
    }

    @Test
    public void testMethodWithFutureSetNullJsonObject() throws Exception {
        Set<JsonObject> result = this.get(this.obj.methodWithHandlerAsyncResultSetNullJsonObjectObservable());
        Assert.assertEquals(Collections.singletonList(null), new ArrayList<JsonObject>(result));
    }

    @Test
    public void testMethodWithHandlerListJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListJsonArray(checker.expectedResult(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListNullJsonArray(checker.expectedResult(Collections.singletonList(null)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListJsonArray(checker.asyncExpectedResult(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple"))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListNullJsonArray(checker.asyncExpectedResult(Collections.singletonList(null)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureListJsonArray() throws Exception {
        List<JsonArray> result = this.get(this.obj.methodWithHandlerAsyncResultListJsonArrayObservable());
        Assert.assertEquals(result, Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")));
    }

    @Test
    public void testMethodWithFutureListNullJsonArray() throws Exception {
        List<JsonArray> result = this.get(this.obj.methodWithHandlerAsyncResultListNullJsonArrayObservable());
        Assert.assertEquals(result, Collections.singletonList(null));
    }

    @Test
    public void testMethodWithHandlerSetJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetJsonArray(checker.resultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetNullJsonArray(checker.resultHandler(it -> Assert.assertEquals(Collections.singletonList(null), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetNullJsonArray() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetNullJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals(Collections.singletonList(null), new ArrayList(it))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureSetJsonArray() throws Exception {
        Set<JsonArray> result = this.get(this.obj.methodWithHandlerAsyncResultSetJsonArrayObservable());
        Assert.assertEquals(Arrays.asList(new JsonArray().add("green").add("blue"), new JsonArray().add("yellow").add("purple")), new ArrayList<JsonArray>(result));
    }

    @Test
    public void testMethodWithFutureSetNullJsonArray() throws Exception {
        Set<JsonArray> result = this.get(this.obj.methodWithHandlerAsyncResultSetNullJsonArrayObservable());
        Assert.assertEquals(Collections.singletonList(null), new ArrayList<JsonArray>(result));
    }

    @Test
    public void testMethodWithHandlerListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListDataObject(checker.resultHandler(list -> {
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerNullListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListNullDataObject(checker.resultHandler(list -> {
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertNull(list.get(0));
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetDataObject(checker.resultHandler(set -> {
            ArrayList list = new ArrayList(set);
            Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerNullSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetNullDataObject(checker.resultHandler(set -> {
            Assert.assertEquals((long)1L, (long)set.size());
            ArrayList list = new ArrayList(set);
            Assert.assertNull(list.get(0));
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListDataObject(checker.asyncResultHandler(list -> {
            Assert.assertEquals((long)2L, (long)list.size());
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultNullListDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListNullDataObject(checker.asyncResultHandler(list -> {
            Assert.assertEquals((long)1L, (long)list.size());
            Assert.assertNull(list.get(0));
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetDataObject(checker.asyncResultHandler(set -> {
            ArrayList list = new ArrayList(set);
            Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
            Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
            Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
            Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
            Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
            Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
            Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultNullSetDataObject() throws Exception {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetNullDataObject(checker.asyncResultHandler(set -> {
            Assert.assertEquals((long)1L, (long)set.size());
            ArrayList list = new ArrayList(set);
            Assert.assertNull(list.get(0));
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerUserTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerUserTypes(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString())));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithConcreteHandlerUserTypeSubtype() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithConcreteHandlerUserTypeSubtype(Factory.createConcreteHandlerUserType(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithAbstractHandlerUserTypeSubtype() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithAbstractHandlerUserTypeSubtype(Factory.createAbstractHandlerUserType(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithAbstractHandlerUserTypeSubtypeExtension() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithConcreteHandlerUserTypeSubtypeExtension(Factory.createConcreteHandlerUserTypeExtension(checker.resultHandler(it -> Assert.assertEquals((Object)"echidnas", (Object)it.getString()))));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultUserTypes() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultUserTypes(checker.asyncResultHandler(it -> Assert.assertEquals((Object)"cheetahs", (Object)it.getString())));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureUserTypes() throws Exception {
        RefedInterface1 result = this.get(this.obj.methodWithHandlerAsyncResultUserTypesObservable());
        Assert.assertEquals((Object)"cheetahs", (Object)result.getString());
    }

    @Test
    public void testMethodWithHandlerVoid() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerVoid(checker.resultHandler(Assert::assertNull));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultVoid() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultVoid(false, checker.asyncResultHandler(Assert::assertNull));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureVoid() throws Exception {
        Void result = this.get(this.obj.methodWithHandlerAsyncResultVoidObservable(false));
        Assert.assertEquals(null, (Object)result);
    }

    @Test
    public void testMethodWithHandlerAsyncResultVoidFails() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultVoid(true, checker.failureAsserter("foo!"));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithFutureVoidFails() throws Exception {
        this.assertFailure("foo!", this.obj.methodWithHandlerAsyncResultVoidObservable(true));
    }

    @Test
    public void testMethodWithHandlerThrowable() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerThrowable(checker.resultHandler(t -> {
            Assert.assertTrue((boolean)(t instanceof VertxException));
            Assert.assertEquals((Object)"cheese!", (Object)t.getMessage());
        }));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithGenericParam() {
        this.obj.methodWithGenericParam("String", "foo");
        this.obj.methodWithGenericParam("Ref", new RefedInterface1Impl().setString("bar"));
        this.obj.methodWithGenericParam("JsonObject", new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123)));
        this.obj.methodWithGenericParam("JsonArray", new JsonArray().add("foo").add("bar").add("wib"));
    }

    @Test
    public void testMethodWithGenericHandler() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithGenericHandler("String", checker.expectedResult("foo"));
        this.obj.methodWithGenericHandler("Ref", checker.resultHandler(it -> Assert.assertEquals((Object)"bar", (Object)it.getString())));
        this.obj.methodWithGenericHandler("JsonObject", checker.expectedResult(new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123))));
        this.obj.methodWithGenericHandler("JsonArray", checker.expectedResult(new JsonArray().add("foo").add("bar").add("wib")));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithGenericHandlerAsyncResult() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithGenericHandlerAsyncResult("String", checker.asyncExpectedResult("foo"));
        this.obj.methodWithGenericHandlerAsyncResult("Ref", checker.asyncResultHandler(it -> Assert.assertEquals((Object)"bar", (Object)it.getString())));
        this.obj.methodWithGenericHandlerAsyncResult("JsonObject", checker.asyncExpectedResult(new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123))));
        this.obj.methodWithGenericHandlerAsyncResult("JsonArray", checker.asyncExpectedResult(new JsonArray().add("foo").add("bar").add("wib")));
        Assert.assertEquals((long)4L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerListEnum(checker.expectedResult(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerSetEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerSetEnum(checker.expectedResult(ApiTest.set(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerListAsyncResultEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultListEnum(checker.asyncExpectedResult(Arrays.asList(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodWithHandlerAsyncResultSetEnum() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultSetEnum(checker.asyncExpectedResult(ApiTest.set(TestEnum.TIM, TestEnum.JULIEN)));
        Assert.assertEquals((long)1L, (long)checker.count);
    }

    @Test
    public void testMethodListParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        this.obj.methodWithListParams(Arrays.asList("foo", "bar"), Arrays.asList((byte)2, (byte)3), Arrays.asList((short)12, (short)13), Arrays.asList(1234, 1345), Arrays.asList(123L, 456L), Arrays.asList(new JsonObject().put("foo", "bar"), new JsonObject().put("eek", "wibble")), Arrays.asList(new JsonArray().add("foo"), new JsonArray().add("blah")), Arrays.asList(refed1, refed2), Arrays.asList(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)), Arrays.asList(TestEnum.JULIEN, TestEnum.TIM));
    }

    @Test
    public void testMethodSetParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        this.obj.methodWithSetParams(ApiTest.set("foo", "bar"), ApiTest.set((byte)2, (byte)3), ApiTest.set((short)12, (short)13), ApiTest.set(1234, 1345), ApiTest.set(123L, 456L), ApiTest.set(new JsonObject().put("foo", "bar"), new JsonObject().put("eek", "wibble")), ApiTest.set(new JsonArray().add("foo"), new JsonArray().add("blah")), ApiTest.set(refed1, refed2), ApiTest.set(new TestDataObject().setFoo("String 1").setBar(1).setWibble(1.1), new TestDataObject().setFoo("String 2").setBar(2).setWibble(2.2)), ApiTest.set(TestEnum.TIM, TestEnum.JULIEN));
    }

    @Test
    public void testMethodMapParams() {
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        this.obj.methodWithMapParams(ApiTest.map("foo", "bar", "eek", "wibble"), ApiTest.map("foo", (byte)2, "eek", (byte)3), ApiTest.map("foo", (short)12, "eek", (short)13), ApiTest.map("foo", 1234, "eek", 1345), ApiTest.map("foo", 123L, "eek", 456L), ApiTest.map("foo", new JsonObject().put("foo", "bar"), "eek", new JsonObject().put("eek", "wibble")), ApiTest.map("foo", new JsonArray().add("foo"), "eek", new JsonArray().add("blah")), ApiTest.map("foo", refed1, "eek", refed2));
    }

    @Test
    public void testMethodWithGenericObservable() throws Exception {
        Assert.assertEquals((Object)"foo", this.get(this.obj.methodWithGenericHandlerAsyncResultObservable("String")));
        RefedInterface1Impl ref = (RefedInterface1Impl)this.get(this.obj.methodWithGenericHandlerAsyncResultObservable("Ref"));
        Assert.assertEquals((Object)"bar", (Object)ref.getString());
        Assert.assertEquals((Object)new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123)), this.get(this.obj.methodWithGenericHandlerAsyncResultObservable("JsonObject")));
        Assert.assertEquals((Object)new JsonArray().add("foo").add("bar").add("wib"), this.get(this.obj.methodWithGenericHandlerAsyncResultObservable("JsonArray")));
    }

    @Test
    public void testBasicReturns() {
        Assert.assertEquals((long)123L, (long)this.obj.methodWithByteReturn());
        Assert.assertEquals((long)12345L, (long)this.obj.methodWithShortReturn());
        Assert.assertEquals((long)12345464L, (long)this.obj.methodWithIntReturn());
        Assert.assertEquals((long)65675123L, (long)this.obj.methodWithLongReturn());
        Assert.assertEquals((float)1.23f, (float)this.obj.methodWithFloatReturn(), (float)0.0f);
        Assert.assertEquals((double)3.34535, (double)this.obj.methodWithDoubleReturn(), (double)0.0);
        Assert.assertEquals((Object)true, (Object)this.obj.methodWithBooleanReturn());
        Assert.assertEquals((long)89L, (long)this.obj.methodWithCharReturn());
        Assert.assertEquals((Object)"orangutan", (Object)this.obj.methodWithStringReturn());
    }

    @Test
    public void testVertxGenReturn() {
        RefedInterface1 r = this.obj.methodWithVertxGenReturn();
        Assert.assertEquals((Object)"chaffinch", (Object)r.getString());
    }

    @Test
    public void testVertxGenNullReturn() {
        RefedInterface1 r = this.obj.methodWithVertxGenNullReturn();
        Assert.assertNull((Object)r);
    }

    @Test
    public void testAbstractVertxGenReturn() {
        RefedInterface2 r = this.obj.methodWithAbstractVertxGenReturn();
        Assert.assertEquals((Object)"abstractchaffinch", (Object)r.getString());
    }

    @Test
    public void testDataObjectReturn() {
        TestDataObject r = this.obj.methodWithDataObjectReturn();
        Assert.assertEquals((Object)"foo", (Object)r.getFoo());
        Assert.assertEquals((long)123L, (long)r.getBar());
    }

    @Test
    public void testDataObjectNullReturn() {
        TestDataObject r = this.obj.methodWithDataObjectNullReturn();
        Assert.assertNull((Object)r);
    }

    @Test
    public void testListStringReturn() {
        Assert.assertEquals(Arrays.asList("foo", "bar", "wibble"), this.obj.methodWithListStringReturn());
    }

    @Test
    public void testListLongReturn() {
        Assert.assertEquals(ApiTest.list(123L, 456L), this.obj.methodWithListLongReturn());
    }

    @Test
    public void testListJsonObjectReturn() {
        List<JsonObject> list = this.obj.methodWithListJsonObjectReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        JsonObject json1 = list.get(0);
        Assert.assertEquals((Object)"bar", (Object)json1.getValue("foo"));
        JsonObject json2 = list.get(1);
        Assert.assertEquals((Object)"eek", (Object)json2.getValue("blah"));
    }

    @Test
    public void testListJsonArrayReturn() {
        List<JsonArray> list = this.obj.methodWithListJsonArrayReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        JsonArray json1 = list.get(0);
        Assert.assertEquals((Object)"foo", (Object)json1.getValue(0));
        JsonArray json2 = list.get(1);
        Assert.assertEquals((Object)"blah", (Object)json2.getValue(0));
    }

    @Test
    public void testListVertxGenReturn() {
        List<RefedInterface1> list = this.obj.methodWithListVertxGenReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        RefedInterface1 refed1 = list.get(0);
        RefedInterface1 refed2 = list.get(1);
        Assert.assertEquals((Object)"foo", (Object)refed1.getString());
        Assert.assertEquals((Object)"bar", (Object)refed2.getString());
    }

    @Test
    public void testListDataObjectReturn() {
        List<TestDataObject> list = this.obj.methodWithListDataObjectReturn();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"String 1", (Object)list.get(0).getFoo());
        Assert.assertEquals((long)1L, (long)list.get(0).getBar());
        Assert.assertEquals((double)1.1, (double)list.get(0).getWibble(), (double)0.0);
        Assert.assertEquals((Object)"String 2", (Object)list.get(1).getFoo());
        Assert.assertEquals((long)2L, (long)list.get(1).getBar());
        Assert.assertEquals((double)2.2, (double)list.get(1).getWibble(), (double)0.0);
    }

    @Test
    public void testSetStringReturn() {
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo", "bar", "wibble")), this.obj.methodWithSetStringReturn());
    }

    @Test
    public void testSetLongReturn() {
        Assert.assertEquals(ApiTest.set(123L, 456L), this.obj.methodWithSetLongReturn());
    }

    @Test
    public void testSetJsonObjectReturn() {
        Set<JsonObject> set = this.obj.methodWithSetJsonObjectReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        JsonObject json1 = new JsonObject();
        json1.put("foo", "bar");
        Assert.assertTrue((boolean)set.contains(json1));
        JsonObject json2 = new JsonObject();
        json2.put("blah", "eek");
        Assert.assertTrue((boolean)set.contains(json2));
    }

    @Test
    public void testSetJsonArrayReturn() {
        Set<JsonArray> set = this.obj.methodWithSetJsonArrayReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        JsonArray json1 = new JsonArray();
        json1.add("foo");
        Assert.assertTrue((boolean)set.contains(json1));
        JsonArray json2 = new JsonArray();
        json2.add("blah");
        Assert.assertTrue((boolean)set.contains(json2));
    }

    @Test
    public void testSetVertxGenReturn() {
        Set<RefedInterface1> set = this.obj.methodWithSetVertxGenReturn();
        Assert.assertEquals((long)2L, (long)set.size());
        RefedInterface1 refed1 = new RefedInterface1(new RefedInterface1Impl());
        refed1.setString("foo");
        RefedInterface1 refed2 = new RefedInterface1(new RefedInterface1Impl());
        refed2.setString("bar");
        ArrayList<RefedInterface1> list = new ArrayList<RefedInterface1>(set);
        Assert.assertTrue((((RefedInterface1)list.get(0)).getString().equals("foo") && ((RefedInterface1)list.get(1)).getString().equals("bar") || ((RefedInterface1)list.get(0)).getString().equals("bar") && ((RefedInterface1)list.get(1)).getString().equals("foo") ? 1 : 0) != 0);
    }

    @Test
    public void testSetDataObjectReturn() {
        Set<TestDataObject> set = this.obj.methodWithSetDataObjectReturn();
        ArrayList<TestDataObject> list = new ArrayList<TestDataObject>(set);
        Collections.sort(list, (c1, c2) -> Integer.valueOf(c1.getBar()).compareTo(c2.getBar()));
        Assert.assertEquals((Object)"String 1", (Object)((TestDataObject)list.get(0)).getFoo());
        Assert.assertEquals((long)1L, (long)((TestDataObject)list.get(0)).getBar());
        Assert.assertEquals((double)1.1, (double)((TestDataObject)list.get(0)).getWibble(), (double)0.0);
        Assert.assertEquals((Object)"String 2", (Object)((TestDataObject)list.get(1)).getFoo());
        Assert.assertEquals((long)2L, (long)((TestDataObject)list.get(1)).getBar());
        Assert.assertEquals((double)2.2, (double)((TestDataObject)list.get(1)).getWibble(), (double)0.0);
    }

    @Test
    public void testMapStringReturn() {
        Map<String, String> map = this.obj.methodWithMapStringReturn((Handler<String>)((Handler)s -> {}));
        Assert.assertEquals((Object)"bar", (Object)map.get("foo"));
    }

    @Test
    public void testMapLongReturn() {
        Map<String, Long> map = this.obj.methodWithMapLongReturn((Handler<String>)((Handler)s -> {}));
        Assert.assertEquals((long)123L, (long)map.get("foo"));
    }

    @Test
    public void testMapJsonObjectReturn() {
        Map<String, JsonObject> map = this.obj.methodWithMapJsonObjectReturn((Handler<String>)((Handler)s -> {}));
        JsonObject m = map.get("foo");
        Assert.assertEquals((Object)"eek", (Object)m.getValue("wibble"));
    }

    @Test
    public void testMapJsonArrayReturn() {
        Map<String, JsonArray> map = this.obj.methodWithMapJsonArrayReturn((Handler<String>)((Handler)s -> {}));
        JsonArray m = map.get("foo");
        Assert.assertEquals((Object)"wibble", (Object)m.getValue(0));
    }

    @Test
    public void testOverloadedMethods() {
        RefedInterface1 refed = new RefedInterface1(new RefedInterface1Impl());
        refed.setString("dog");
        Assert.assertEquals((Object)"meth1", (Object)this.obj.overloadedMethod("cat", refed));
        AtomicBoolean called = new AtomicBoolean(false);
        Assert.assertEquals((Object)"meth2", (Object)this.obj.overloadedMethod("cat", refed, 12345L, (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.getAndSet(false));
        Assert.assertEquals((Object)"meth3", (Object)this.obj.overloadedMethod("cat", (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.getAndSet(false));
        Assert.assertEquals((Object)"meth4", (Object)this.obj.overloadedMethod("cat", refed, (Handler<String>)((Handler)it -> {
            Assert.assertEquals((Object)"giraffe", (Object)it);
            called.set(true);
        })));
        Assert.assertTrue((boolean)called.get());
    }

    @Test
    public void testSuperInterfaces() {
        this.obj.superMethodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
        this.obj.otherSuperMethodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
    }

    @Test
    public void testMethodWithGenericReturn() {
        Object ret = this.obj.methodWithGenericReturn("JsonObject");
        Assert.assertTrue((String)("Was expecting " + ret + " to implement JsonObject"), (boolean)(ret instanceof JsonObject));
        Assert.assertEquals((Object)new JsonObject().put("foo", "hello").put("bar", Integer.valueOf(123)), ret);
        ret = this.obj.methodWithGenericReturn("JsonArray");
        Assert.assertTrue((String)("Was expecting " + ret + " to implement JsonArray"), (boolean)(ret instanceof JsonArray));
        Assert.assertEquals((Object)new JsonArray().add("foo").add("bar").add("wib"), ret);
    }

    @Test
    public void testFluentMethod() {
        TestInterface ret = this.obj.fluentMethod("bar");
        Assert.assertSame((Object)this.obj, (Object)ret);
    }

    @Test
    public void testStaticFactoryMethod() {
        RefedInterface1 ret = TestInterface.staticFactoryMethod("bar");
        Assert.assertEquals((Object)"bar", (Object)ret.getString());
    }

    @Test
    public void testMethodWithCachedReturn() {
        RefedInterface1 ret1 = this.obj.methodWithCachedReturn("bar");
        Assert.assertEquals((Object)"bar", (Object)ret1.getString());
        RefedInterface1 ret2 = this.obj.methodWithCachedReturn("bar");
        Assert.assertSame((Object)ret1, (Object)ret2);
        RefedInterface1 ret3 = this.obj.methodWithCachedReturn("bar");
        Assert.assertSame((Object)ret1, (Object)ret3);
    }

    @Test
    public void testMethodWithCachedListReturn() {
        List<RefedInterface1> ret1 = this.obj.methodWithCachedListReturn();
        Assert.assertEquals((long)2L, (long)ret1.size());
        Assert.assertEquals((Object)"foo", (Object)ret1.get(0).getString());
        Assert.assertEquals((Object)"bar", (Object)ret1.get(1).getString());
        List<RefedInterface1> ret2 = this.obj.methodWithCachedListReturn();
        Assert.assertSame(ret1, ret2);
        List<RefedInterface1> ret3 = this.obj.methodWithCachedListReturn();
        Assert.assertSame(ret1, ret3);
    }

    @Test
    public void testMethodWithCachedReturnPrimitive() {
        int value = TestUtils.randomInt();
        Assert.assertEquals((long)value, (long)this.obj.methodWithCachedReturnPrimitive(value));
        Assert.assertEquals((long)value, (long)this.obj.methodWithCachedReturnPrimitive(value));
    }

    @Test
    public void testJsonReturns() {
        JsonObject ret1 = this.obj.methodWithJsonObjectReturn();
        Assert.assertEquals((Object)new JsonObject().put("cheese", "stilton"), (Object)ret1);
        JsonArray ret2 = this.obj.methodWithJsonArrayReturn();
        Assert.assertEquals((Object)new JsonArray().add("socks").add("shoes"), (Object)ret2);
    }

    @Test
    public void testNullJsonReturns() {
        JsonObject ret1 = this.obj.methodWithNullJsonObjectReturn();
        Assert.assertEquals(null, (Object)ret1);
        JsonArray ret2 = this.obj.methodWithNullJsonArrayReturn();
        Assert.assertEquals(null, (Object)ret2);
    }

    @Test
    public void testListEnumReturn() {
        Assert.assertEquals(Arrays.asList(TestEnum.JULIEN, TestEnum.TIM), this.obj.methodWithListEnumReturn());
    }

    @Test
    public void testsetEnumReturn() {
        Assert.assertEquals(ApiTest.set(TestEnum.JULIEN, TestEnum.TIM), this.obj.methodWithSetEnumReturn());
    }

    @Test
    public void testJsonParams() {
        this.obj.methodWithJsonParams(new JsonObject().put("cat", "lion").put("cheese", "cheddar"), new JsonArray().add("house").add("spider"));
    }

    @Test
    public void testNullJsonParams() {
        this.obj.methodWithNullJsonParams(null, null);
    }

    @Test
    public void testJsonHandlerParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerJson(checker.resultHandler(it -> Assert.assertEquals((Object)new JsonObject().put("cheese", "stilton"), (Object)it)), checker.resultHandler(it -> Assert.assertEquals((Object)new JsonArray().add("socks").add("shoes"), (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testNullJsonHandlerParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerNullJson(checker.resultHandler(it -> Assert.assertEquals(null, (Object)it)), checker.resultHandler(it -> Assert.assertEquals(null, (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testJsonHandlerAsyncResultParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals((Object)new JsonObject().put("cheese", "stilton"), (Object)it)));
        this.obj.methodWithHandlerAsyncResultJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals((Object)new JsonArray().add("socks").add("shoes"), (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testNullJsonHandlerAsyncResultParams() {
        AsyncResultChecker checker = new AsyncResultChecker();
        this.obj.methodWithHandlerAsyncResultNullJsonObject(checker.asyncResultHandler(it -> Assert.assertEquals(null, (Object)it)));
        this.obj.methodWithHandlerAsyncResultNullJsonArray(checker.asyncResultHandler(it -> Assert.assertEquals(null, (Object)it)));
        Assert.assertEquals((long)2L, (long)checker.count);
    }

    @Test
    public void testJsonFutureParams() throws Exception {
        Assert.assertEquals((Object)new JsonObject().put("cheese", "stilton"), (Object)this.get(this.obj.methodWithHandlerAsyncResultJsonObjectObservable()));
        Assert.assertEquals((Object)new JsonArray().add("socks").add("shoes"), (Object)this.get(this.obj.methodWithHandlerAsyncResultJsonArrayObservable()));
    }

    @Test
    public void testNullJsonFutureParams() throws Exception {
        Assert.assertEquals(null, (Object)this.get(this.obj.methodWithHandlerAsyncResultNullJsonObjectObservable()));
        Assert.assertEquals(null, (Object)this.get(this.obj.methodWithHandlerAsyncResultNullJsonArrayObservable()));
    }

    @Test
    public void testCustomModule() {
        MyInterface my = MyInterface.create();
        TestInterface testInterface = my.method();
        testInterface.methodWithBasicParams((byte)123, (short)12345, 1234567, 1265615234L, 12.345f, 12.34566, true, 'X', "foobar");
        SubInterface sub = my.sub();
        Assert.assertEquals((Object)"olleh", (Object)sub.reverse("hello"));
    }

    @Test
    public void testThrowableParam() {
        Assert.assertEquals((Object)"throwable_message", (Object)this.obj.methodWithThrowableParam(new Exception("throwable_message")));
    }

    private static <V> Map<String, V> map(String key1, V value1) {
        HashMap<String, V> map = new HashMap<String, V>();
        map.put(key1, value1);
        return map;
    }

    private static <V> Map<String, V> map(String key1, V value1, String key2, V value2) {
        HashMap<String, V> map = new HashMap<String, V>();
        map.put(key1, value1);
        map.put(key2, value2);
        return map;
    }

    private static <E> Set<E> set(E ... elements) {
        return new HashSet<E>(Arrays.asList(elements));
    }

    private static <E> List<E> list(E ... elements) {
        return Arrays.asList(elements);
    }
}

