/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Verticle;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.rxjava.core.AbstractVerticle;
import io.vertx.rxjava.core.Vertx;
import io.vertx.rxjava.core.http.HttpServer;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Test;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;

public class ObservableTest
extends VertxTestBase {
    @Test
    public void testDeploy() throws Exception {
        final AtomicInteger count = new AtomicInteger();
        this.vertx.deployVerticle((Verticle)new AbstractVerticle(){

            public void start() throws Exception {
                HttpServer s1 = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080)).requestHandler(req -> {});
                HttpServer s2 = this.vertx.createHttpServer(new HttpServerOptions().setPort(8081)).requestHandler(req -> {});
                Observable f1 = s1.listenObservable();
                Observable f2 = s2.listenObservable();
                Action1 done = server -> {
                    if (count.incrementAndGet() == 2) {
                        ObservableTest.this.testComplete();
                    }
                };
                f1.subscribe(done);
                f2.subscribe(done);
            }
        });
        this.await();
    }

    @Test
    public void testObservablePeriodic() throws Exception {
        Vertx vertx = new Vertx(this.vertx);
        Observable stream = vertx.periodicStream(1L).toObservable();
        stream.subscribe((Subscriber)new Subscriber<Long>(){

            public void onNext(Long aLong) {
                this.unsubscribe();
                ObservableTest.this.testComplete();
            }

            public void onCompleted() {
                ObservableTest.this.fail();
            }

            public void onError(Throwable e) {
                ObservableTest.this.fail(e.getMessage());
            }
        });
        this.await();
    }
}

