/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import rx.Subscriber;

public class MySubscriber<T>
extends Subscriber<T> {
    private final Object completed = new Object(){

        public String toString() {
            return "Completed";
        }
    };
    final ArrayBlockingQueue<Object> events = new ArrayBlockingQueue(100);

    public void onCompleted() {
        this.events.add(this.completed);
    }

    public void onError(Throwable e) {
        this.events.add(e);
    }

    public void onNext(T t) {
        this.events.add(t);
    }

    MySubscriber<T> assertItem(T expected) {
        return this.assertEvent(expected);
    }

    MySubscriber<T> assertError(Throwable expected) {
        return this.assertEvent(expected);
    }

    MySubscriber<T> assertCompleted() {
        return this.assertEvent(this.completed);
    }

    MySubscriber<T> assertEmpty() {
        if (!this.events.isEmpty()) {
            throw new AssertionError((Object)("Was expecting no events instead of " + this.events));
        }
        return this;
    }

    private MySubscriber<T> assertEvent(Object expected) {
        Object event;
        try {
            event = this.events.poll(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        if (event == null) {
            throw new AssertionError((Object)("Was expecting at least event " + expected));
        }
        if (expected == this.completed) {
            Assert.assertEquals((Object)this.completed, (Object)event);
        } else if (expected instanceof Throwable) {
            Assert.assertEquals((Object)expected, (Object)event);
        } else {
            this.assertEquals(expected, event);
        }
        return this;
    }

    protected void assertEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

