/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rx.java.test;

import io.vertx.core.Handler;
import io.vertx.rx.java.ObservableHandler;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.test.MySubscriber;
import org.junit.Assert;
import org.junit.Test;
import rx.Subscription;

public class HandlerTest {
    @Test
    public void testMultiNotifyBeforeSubscribe() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        o.toHandler().handle((Object)"abc");
        MySubscriber subscriber = new MySubscriber();
        o.subscribe(subscriber);
        subscriber.assertEmpty();
    }

    @Test
    public void testSingleNotifyBeforeSubscribe() {
        ObservableHandler o = RxHelper.observableHandler();
        o.toHandler().handle((Object)"abc");
        MySubscriber subscriber = new MySubscriber();
        o.subscribe(subscriber);
        subscriber.assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiNotifyAfterSubscribe() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertItem("abc").assertEmpty();
    }

    @Test
    public void testSingleNotifyAfterSubscribe() {
        ObservableHandler o = RxHelper.observableHandler();
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiUnsubscribeBeforeNotify() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        MySubscriber subscriber = new MySubscriber();
        Subscription sub = o.subscribe(subscriber);
        sub.unsubscribe();
        Assert.assertTrue((boolean)sub.isUnsubscribed());
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertEmpty();
    }

    @Test
    public void testSingleUnsubscribeBeforeNotify() {
        ObservableHandler o = RxHelper.observableHandler();
        MySubscriber subscriber = new MySubscriber();
        Subscription sub = o.subscribe(subscriber);
        sub.unsubscribe();
        Assert.assertTrue((boolean)sub.isUnsubscribed());
        subscriber.assertEmpty();
        o.toHandler().handle((Object)"abc");
        subscriber.assertEmpty();
    }

    @Test
    public void testMultiNotifyTwice() {
        ObservableHandler o = RxHelper.observableHandler((boolean)true);
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        o.toHandler().handle((Object)"abc");
        o.toHandler().handle((Object)"def");
        subscriber.assertItem("abc").assertItem("def").assertEmpty();
    }

    @Test
    public void testSingleNotifyTwice() {
        ObservableHandler o = RxHelper.observableHandler();
        MySubscriber<String> subscriber = new MySubscriber<String>();
        o.subscribe(subscriber);
        o.toHandler().handle((Object)"abc");
        o.toHandler().handle((Object)"def");
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testMultiFulfillAdaptedSubscriber() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toHandler(subscriber, (boolean)true);
        o.handle((Object)"abc");
        subscriber.assertItem("abc").assertEmpty();
    }

    @Test
    public void testSingleFulfillAdaptedSubscriber() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toHandler(subscriber);
        o.handle((Object)"abc");
        subscriber.assertItem("abc").assertCompleted().assertEmpty();
    }

    @Test
    public void testFulfillAdaptedFunctions1() {
        MySubscriber<String> subscriber = new MySubscriber<String>();
        Handler o = RxHelper.toHandler(subscriber::onNext);
        o.handle((Object)"abc");
        subscriber.assertItem("abc").assertEmpty();
    }
}

